/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.demo;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;

public class TokensRegexRetokenizeDemo {
    public static void runPipeline(StanfordCoreNLP pipeline, String text, PrintWriter out2) {
        Annotation annotation = new Annotation(text);
        pipeline.annotate(annotation);
        out2.println();
        out2.println("The top level annotation");
        out2.println(annotation.toShorterString(new String[0]));
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
                String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
                String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String ne = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normalized = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                out2.println("token: word=" + word + ", lemma=" + lemma + ", pos=" + pos + ", ne=" + ne + ", normalized=" + normalized);
            }
        }
        out2.flush();
    }

    public static void main(String[] args) throws IOException {
        String rules = args.length > 0 ? args[0] : "edu/stanford/nlp/ling/tokensregex/demo/rules/retokenize.rules.txt";
        PrintWriter out2 = args.length > 2 ? new PrintWriter(args[2]) : new PrintWriter(System.out);
        String text = args.length > 1 ? IOUtils.slurpFileNoExceptions(args[1]) : "Do we tokenize on hyphens? one-two-three-four.  How about dates? 03-16-2015.";
        Properties propertiesDefaultTokenize = new Properties();
        propertiesDefaultTokenize.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        StanfordCoreNLP pipelineDefaultRetokenize = new StanfordCoreNLP();
        out2.println("Default tokenization: ");
        TokensRegexRetokenizeDemo.runPipeline(pipelineDefaultRetokenize, text, out2);
        Properties properties = new Properties();
        properties.setProperty("annotators", "tokenize,retokenize,ssplit,pos,lemma,ner");
        properties.setProperty("customAnnotatorClass.retokenize", "edu.stanford.nlp.pipeline.TokensRegexAnnotator");
        properties.setProperty("retokenize.rules", rules);
        StanfordCoreNLP pipelineWithRetokenize = new StanfordCoreNLP(properties);
        out2.println();
        out2.println("Always tokenize hyphens: ");
        TokensRegexRetokenizeDemo.runPipeline(pipelineWithRetokenize, text, out2);
    }
}

