/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.TrieMap;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CollectionFactory;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.MapFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class TrieMapUtils {
    private static final MapFactory TRIE_MAP_FACTORY = new TrieMapFactory();

    public static <K> Counter<Iterable<K>> trieMapCounter() {
        return new ClassicCounter<Iterable<K>>(TrieMapUtils.trieMapFactory());
    }

    public static <K, V> CollectionValuedMap<Iterable<K>, V> collectionValuedTrieMap() {
        return new CollectionValuedMap(TrieMapUtils.trieMapFactory(), CollectionFactory.hashSetFactory(), false);
    }

    public static <K, V> CollectionValuedMap<Iterable<K>, V> collectionValuedTrieMap(CollectionFactory<V> collectionFactory) {
        return new CollectionValuedMap<Iterable<K>, V>(TrieMapUtils.trieMapFactory(), collectionFactory, false);
    }

    public static <K, V> MapFactory<Iterable<K>, V> trieMapFactory() {
        return TRIE_MAP_FACTORY;
    }

    private static class TrieMapFactory<K, V>
    extends MapFactory<Iterable<K>, V> {
        private static final long serialVersionUID = 1L;

        private TrieMapFactory() {
        }

        @Override
        public Map<Iterable<K>, V> newMap() {
            return new TrieMap();
        }

        @Override
        public Map<Iterable<K>, V> newMap(int initCapacity) {
            return new TrieMap(initCapacity);
        }

        @Override
        public Set<Iterable<K>> newSet() {
            return Collections.newSetFromMap(new TrieMap());
        }

        @Override
        public Set<Iterable<K>> newSet(Collection<Iterable<K>> init) {
            Set<Iterable<K>> set = Collections.newSetFromMap(new TrieMap());
            init.addAll(init);
            return set;
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K1, V1> Map<K1, V1> setMap(Map<K1, V1> map, int initCapacity) {
            throw new UnsupportedOperationException();
        }
    }
}

