/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.benchmarks;

import edu.stanford.nlp.loglinear.benchmarks.CoNLLFeaturizer;
import edu.stanford.nlp.loglinear.inference.CliqueTree;
import edu.stanford.nlp.loglinear.learning.BacktrackingAdaGradOptimizer;
import edu.stanford.nlp.loglinear.learning.LogLikelihoodDifferentiableFunction;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorNamespace;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CoNLLBenchmark {
    private static Redwood.RedwoodChannels log = Redwood.channels(CoNLLBenchmark.class);
    static final String DATA_PATH = "/u/nlp/data/ner/conll/";
    Map<String, double[]> embeddings = new HashMap<String, double[]>();

    public static void main(String[] args) throws Exception {
        new CoNLLBenchmark().benchmarkOptimizer();
    }

    public void benchmarkOptimizer() throws Exception {
        List<CoNLLSentence> train = this.getSentences("/u/nlp/data/ner/conll/conll.iob.4class.train");
        List<CoNLLSentence> testA = this.getSentences("/u/nlp/data/ner/conll/conll.iob.4class.testa");
        List<CoNLLSentence> testB = this.getSentences("/u/nlp/data/ner/conll/conll.iob.4class.testb");
        ArrayList<CoNLLSentence> allData = new ArrayList<CoNLLSentence>();
        allData.addAll(train);
        allData.addAll(testA);
        allData.addAll(testB);
        HashSet<String> tagsSet = new HashSet<String>();
        for (CoNLLSentence sentence : allData) {
            for (String nerTag : sentence.ner) {
                tagsSet.add(nerTag);
            }
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.addAll(tagsSet);
        this.embeddings = this.getEmbeddings("/u/nlp/data/ner/conll/google-300-trimmed.ser.gz", allData);
        log.info("Making the training set...");
        ConcatVectorNamespace namespace = new ConcatVectorNamespace();
        int trainSize = train.size();
        GraphicalModel[] trainingSet = new GraphicalModel[trainSize];
        for (int i = 0; i < trainSize; ++i) {
            if (i % 10 == 0) {
                log.info(i + "/" + trainSize);
            }
            trainingSet[i] = this.generateSentenceModel(namespace, train.get(i), tags);
        }
        log.info("Training system...");
        BacktrackingAdaGradOptimizer opt = new BacktrackingAdaGradOptimizer();
        ConcatVector weights = opt.optimize(trainingSet, new LogLikelihoodDifferentiableFunction(), namespace.newWeightsVector(), 0.01, 1.0E-5, false);
        log.info("Testing system...");
        HashMap<String, Double> correctChunk = new HashMap<String, Double>();
        HashMap<String, Double> foundCorrect = new HashMap<String, Double>();
        HashMap<String, Double> foundGuessed = new HashMap<String, Double>();
        double correct = 0.0;
        double total = 0.0;
        for (CoNLLSentence sentence : testA) {
            GraphicalModel model = this.generateSentenceModel(namespace, sentence, tags);
            int[] guesses = new CliqueTree(model, weights).calculateMAP();
            String[] nerGuesses = new String[guesses.length];
            for (int i = 0; i < guesses.length; ++i) {
                nerGuesses[i] = (String)tags.get(guesses[i]);
                if (nerGuesses[i].equals(sentence.ner.get(i))) {
                    correct += 1.0;
                    correctChunk.put(nerGuesses[i], correctChunk.getOrDefault(nerGuesses[i], 0.0) + 1.0);
                }
                total += 1.0;
                foundCorrect.put(sentence.ner.get(i), foundCorrect.getOrDefault(sentence.ner.get(i), 0.0) + 1.0);
                foundGuessed.put(nerGuesses[i], foundGuessed.getOrDefault(nerGuesses[i], 0.0) + 1.0);
            }
        }
        log.info("\nSystem results:\n");
        log.info("Accuracy: " + correct / total + "\n");
        for (String tag : tags) {
            double precision = foundGuessed.getOrDefault(tag, 0.0) == 0.0 ? 0.0 : correctChunk.getOrDefault(tag, 0.0) / (Double)foundGuessed.get(tag);
            double recall = foundCorrect.getOrDefault(tag, 0.0) == 0.0 ? 0.0 : correctChunk.getOrDefault(tag, 0.0) / (Double)foundCorrect.get(tag);
            double f1 = precision + recall == 0.0 ? 0.0 : precision * recall * 2.0 / (precision + recall);
            log.info(tag + " (" + foundCorrect.getOrDefault(tag, 0.0).intValue() + ")");
            log.info("\tP:" + precision + " (" + correctChunk.getOrDefault(tag, 0.0).intValue() + "/" + foundGuessed.getOrDefault(tag, 0.0).intValue() + ")");
            log.info("\tR:" + recall + " (" + correctChunk.getOrDefault(tag, 0.0).intValue() + "/" + foundCorrect.getOrDefault(tag, 0.0).intValue() + ")");
            log.info("\tF1:" + f1);
        }
    }

    private static String getWordShape(String string) {
        if (string.toUpperCase().equals(string) && string.toLowerCase().equals(string)) {
            return "no-case";
        }
        if (string.toUpperCase().equals(string)) {
            return "upper-case";
        }
        if (string.toLowerCase().equals(string)) {
            return "lower-case";
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(0)) && string.substring(1).toLowerCase().equals(string.substring(1))) {
            return "capitalized";
        }
        return "mixed-case";
    }

    public GraphicalModel generateSentenceModel(ConcatVectorNamespace namespace, CoNLLSentence sentence, List<String> tags) {
        GraphicalModel model = new GraphicalModel();
        for (int i = 0; i < sentence.token.size(); ++i) {
            Map<String, String> metadata = model.getVariableMetaDataByReference(i);
            metadata.put("learning.LogLikelihoodDifferentiableFunction.VARIABLE_TRAINING_VALUE", "" + tags.indexOf(sentence.ner.get(i)));
            metadata.put("TOKEN", "" + sentence.token.get(i));
            metadata.put("POS", "" + sentence.pos.get(i));
            metadata.put("CHUNK", "" + sentence.npchunk.get(i));
            metadata.put("TAG", "" + sentence.ner.get(i));
        }
        CoNLLFeaturizer.annotate(model, tags, namespace, this.embeddings);
        assert (model.factors != null);
        for (GraphicalModel.Factor f : model.factors) {
            assert (f != null);
        }
        return model;
    }

    public List<CoNLLSentence> getSentences(String filename) throws IOException {
        String line;
        ArrayList<CoNLLSentence> sentences = new ArrayList<CoNLLSentence>();
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> ner = new ArrayList<String>();
        ArrayList<String> pos = new ArrayList<String>();
        ArrayList<String> npchunk = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts.length != 4) continue;
            tokens.add(parts[0]);
            pos.add(parts[1]);
            npchunk.add(parts[2]);
            String tag = parts[3];
            if (tag.contains("-")) {
                ner.add(tag.split("-")[1]);
            } else {
                ner.add(tag);
            }
            if (!parts[0].equals(".")) continue;
            sentences.add(new CoNLLSentence(tokens, ner, pos, npchunk));
            tokens = new ArrayList();
            ner = new ArrayList();
            pos = new ArrayList();
            npchunk = new ArrayList();
        }
        return sentences;
    }

    public Map<String, double[]> getEmbeddings(String cacheFilename, List<CoNLLSentence> sentences) throws IOException, ClassNotFoundException {
        HashMap<String, double[]> trimmedSet;
        File f = new File(cacheFilename);
        if (!f.exists()) {
            trimmedSet = new HashMap();
            Map<String, double[]> massiveSet = this.loadEmbeddingsFromFile("../google-300.txt");
            log.info("Got massive embedding set size " + massiveSet.size());
            for (CoNLLSentence sentence : sentences) {
                for (String token : sentence.token) {
                    if (!massiveSet.containsKey(token)) continue;
                    trimmedSet.put(token, massiveSet.get(token));
                }
            }
            log.info("Got trimmed embedding set size " + trimmedSet.size());
            f.createNewFile();
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(cacheFilename)));
            oos.writeObject(trimmedSet);
            oos.close();
            log.info("Wrote trimmed set to file");
        } else {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(cacheFilename)));
            trimmedSet = (Map)ois.readObject();
        }
        return trimmedSet;
    }

    public Map<String, double[]> loadEmbeddingsFromFile(String filename) throws IOException {
        HashMap<String, double[]> embeddings = new HashMap<String, double[]>();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        int readLines = 0;
        String line = br.readLine();
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(" ");
            if (parts.length == 302) {
                String token = parts[0];
                double[] embedding = new double[300];
                for (int i = 1; i < parts.length - 1; ++i) {
                    embedding[i - 1] = Double.parseDouble(parts[i]);
                }
                embeddings.put(token, embedding);
            }
            if (++readLines % 10000 != 0) continue;
            log.info("Read " + readLines + " lines");
        }
        return embeddings;
    }

    public static class CoNLLSentence {
        public List<String> token = new ArrayList<String>();
        public List<String> ner = new ArrayList<String>();
        public List<String> pos = new ArrayList<String>();
        public List<String> npchunk = new ArrayList<String>();

        public CoNLLSentence(List<String> token, List<String> ner, List<String> pos, List<String> npchunk) {
            this.token = token;
            this.ner = ner;
            this.pos = pos;
            this.npchunk = npchunk;
        }
    }
}

