/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.inference;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.inference.CliqueTree;
import edu.stanford.nlp.loglinear.inference.TableFactor;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class CliqueTreeTest {
    public static final int CONCAT_VEC_COMPONENTS = 2;
    public static final int CONCAT_VEC_COMPONENT_LENGTH = 3;

    @Theory
    public void testCalculateMarginals(@ForAll(sampleSize=100) @From(value={GraphicalModelGenerator.class}) GraphicalModel model, @ForAll(sampleSize=2) @From(value={WeightsGenerator.class}) ConcatVector weights) throws Exception {
        CliqueTree inference = new CliqueTree(model, weights);
        this.checkMarginalsAgainstBruteForce(model, weights, inference);
        Random r = new Random();
        for (int i = 0; i < 10; ++i) {
            this.randomlyMutateGraphicalModel(model, r);
            this.checkMarginalsAgainstBruteForce(model, weights, inference);
        }
    }

    private void randomlyMutateGraphicalModel(GraphicalModel model, Random r) {
        if (r.nextBoolean() && model.factors.size() > 1) {
            model.factors.remove(model.factors.toArray(new GraphicalModel.Factor[model.factors.size()])[r.nextInt(model.factors.size())]);
        } else {
            int assignment2;
            int maxVar = 0;
            int attachVar = -1;
            int attachVarSize = 0;
            for (GraphicalModel.Factor f : model.factors) {
                for (int j = 0; j < f.neigborIndices.length; ++j) {
                    int k = f.neigborIndices[j];
                    if (k > maxVar) {
                        maxVar = k;
                    }
                    if (!(r.nextDouble() > 0.3) && attachVar != -1) continue;
                    attachVar = k;
                    attachVarSize = f.featuresTable.getDimensions()[j];
                }
            }
            int newVar = maxVar + 1;
            int newVarSize = 1 + r.nextInt(2);
            if (maxVar >= 8) {
                boolean[] seenVariables = new boolean[maxVar + 1];
                for (GraphicalModel.Factor f : model.factors) {
                    for (int n : f.neigborIndices) {
                        seenVariables[n] = true;
                    }
                }
                for (int j = 0; j < seenVariables.length; ++j) {
                    if (seenVariables[j]) continue;
                    newVar = j;
                    break;
                }
                if (newVar == maxVar + 1) {
                    return;
                }
            }
            if (model.getVariableMetaDataByReference(newVar).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE") && (assignment2 = Integer.parseInt(model.getVariableMetaDataByReference(newVar).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"))) >= newVarSize) {
                newVarSize = assignment2 + 1;
            }
            GraphicalModel.Factor binary = model.addFactor(new int[]{newVar, attachVar}, new int[]{newVarSize, attachVarSize}, assignment -> {
                ConcatVector v = new ConcatVector(2);
                for (int j = 0; j < v.getNumberOfComponents(); ++j) {
                    if (r.nextBoolean()) {
                        v.setSparseComponent(j, r.nextInt(3), r.nextDouble());
                        continue;
                    }
                    double[] d = new double[3];
                    for (int k = 0; k < d.length; ++k) {
                        d[k] = r.nextDouble();
                    }
                    v.setDenseComponent(j, d);
                }
                return v;
            });
            for (int[] assignment3 : binary.featuresTable) {
                ConcatVector randomlyGenerated = (ConcatVector)((Supplier)binary.featuresTable.getAssignmentValue(assignment3)).get();
                binary.featuresTable.setAssignmentValue(assignment3, () -> randomlyGenerated);
            }
        }
    }

    private void checkMarginalsAgainstBruteForce(GraphicalModel model, ConcatVector weights, CliqueTree inference) {
        CliqueTree.MarginalResult result = inference.calculateMarginals();
        double[][] marginals = result.marginals;
        Set tableFactors = model.factors.stream().map(factor -> new TableFactor(weights, (GraphicalModel.Factor)factor)).collect(Collectors.toSet());
        assert (tableFactors.size() == model.factors.size());
        TableFactor bruteForce = null;
        for (TableFactor factor2 : tableFactors) {
            if (bruteForce == null) {
                bruteForce = factor2;
                continue;
            }
            bruteForce = bruteForce.multiply(factor2);
        }
        if (bruteForce != null) {
            TableFactor observed = bruteForce;
            for (int i = 0; i < bruteForce.neighborIndices.length; ++i) {
                int n = bruteForce.neighborIndices[i];
                if (!model.getVariableMetaDataByReference(n).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE")) continue;
                int value = Integer.parseInt(model.getVariableMetaDataByReference(n).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
                for (int j = 0; j < marginals[n].length; ++j) {
                    Assert.assertEquals((double)(j == value ? 1.0 : 0.0), (double)marginals[n][j], (double)1.0E-9);
                }
                if (observed.neighborIndices.length > 1) {
                    observed = observed.observe(n, value);
                    continue;
                }
                return;
            }
            bruteForce = observed;
            double[][] bruteMarginals = bruteForce.getSummedMarginals();
            int index = 0;
            for (int i : bruteForce.neighborIndices) {
                boolean isEqual = true;
                double[] dArray = bruteMarginals[index];
                ++index;
                assert (dArray != null);
                assert (marginals[i] != null);
                for (int j = 0; j < dArray.length; ++j) {
                    if (Double.isNaN(dArray[j])) {
                        isEqual = false;
                        break;
                    }
                    if (!(Math.abs(dArray[j] - marginals[i][j]) > 0.03)) continue;
                    isEqual = false;
                    break;
                }
                if (!isEqual) {
                    System.err.println("Arrays not equal! Variable " + i);
                    System.err.println("\tGold: " + Arrays.toString(dArray));
                    System.err.println("\tResult: " + Arrays.toString(marginals[i]));
                }
                Assert.assertArrayEquals((double[])dArray, (double[])marginals[i], (double)0.03);
            }
            double goldPartitionFunction = bruteForce.valueSum();
            Assert.assertEquals((double)goldPartitionFunction, (double)result.partitionFunction, (double)(goldPartitionFunction * 0.03));
            block5: for (GraphicalModel.Factor f : model.factors) {
                Assert.assertTrue((boolean)result.jointMarginals.containsKey(f));
                TableFactor bruteForceJointMarginal = bruteForce;
                block6: for (int n : bruteForce.neighborIndices) {
                    for (int i : f.neigborIndices) {
                        if (i == n) continue block6;
                    }
                    if (bruteForceJointMarginal.neighborIndices.length > 1) {
                        bruteForceJointMarginal = bruteForceJointMarginal.sumOut(n);
                        continue;
                    }
                    int[] fixedAssignment = new int[f.neigborIndices.length];
                    for (int i = 0; i < fixedAssignment.length; ++i) {
                        fixedAssignment[i] = Integer.parseInt(model.getVariableMetaDataByReference(f.neigborIndices[i]).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
                    }
                    for (int[] assn : result.jointMarginals.get(f)) {
                        if (Arrays.equals(assn, fixedAssignment)) {
                            Assert.assertEquals((double)1.0, (double)result.jointMarginals.get(f).getAssignmentValue(assn), (double)1.0E-7);
                            continue;
                        }
                        if (result.jointMarginals.get(f).getAssignmentValue(assn) != 0.0) {
                            TableFactor j = result.jointMarginals.get(f);
                            for (int[] assignment : j) {
                                System.err.println(Arrays.toString(assignment) + ": " + j.getAssignmentValue(assignment));
                            }
                        }
                        Assert.assertEquals((double)0.0, (double)result.jointMarginals.get(f).getAssignmentValue(assn), (double)1.0E-7);
                    }
                    continue block5;
                }
                int[] nArray = new int[f.neigborIndices.length];
                int[] observedValue = new int[f.neigborIndices.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (model.getVariableMetaDataByReference(f.neigborIndices[i]).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE")) {
                        observedValue[i] = Integer.parseInt(model.getVariableMetaDataByReference(f.neigborIndices[i]).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
                        nArray[i] = -1;
                        continue;
                    }
                    observedValue[i] = -1;
                    nArray[i] = -1;
                    for (int j = 0; j < bruteForceJointMarginal.neighborIndices.length; ++j) {
                        if (bruteForceJointMarginal.neighborIndices[j] != f.neigborIndices[i]) continue;
                        nArray[i] = j;
                    }
                    assert (nArray[i] != -1);
                }
                double sum = bruteForceJointMarginal.valueSum();
                if (sum == 0.0) {
                    sum = 1.0;
                }
                Object object = result.jointMarginals.get(f).iterator();
                block13: while (object.hasNext()) {
                    int[] assignment = (int[])object.next();
                    int[] bruteForceMarginalAssignment = new int[bruteForceJointMarginal.neighborIndices.length];
                    for (int i = 0; i < assignment.length; ++i) {
                        if (nArray[i] != -1) {
                            bruteForceMarginalAssignment[nArray[i]] = assignment[i];
                            continue;
                        }
                        assert (observedValue[i] != -1);
                        if (assignment[i] == observedValue[i]) continue;
                        if (result.jointMarginals.get(f).getAssignmentValue(assignment) != 0.0) {
                            System.err.println("Joint marginals: " + Arrays.toString(result.jointMarginals.get((Object)f).neighborIndices));
                            System.err.println("Assignment: " + Arrays.toString(assignment));
                            System.err.println("Observed Value: " + Arrays.toString(observedValue));
                            for (int[] assn : result.jointMarginals.get(f)) {
                                System.err.println("\t" + Arrays.toString(assn) + ":" + result.jointMarginals.get(f).getAssignmentValue(assn));
                            }
                        }
                        Assert.assertEquals((double)0.0, (double)result.jointMarginals.get(f).getAssignmentValue(assignment), (double)1.0E-7);
                        continue block13;
                    }
                    Assert.assertEquals((double)(bruteForceJointMarginal.getAssignmentValue(bruteForceMarginalAssignment) / sum), (double)result.jointMarginals.get(f).getAssignmentValue(assignment), (double)0.001);
                }
            }
        } else {
            Object object = marginals;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object marginal;
                for (Object d : marginal = object[i]) {
                    Assert.assertEquals((double)(1.0 / (double)((Object)marginal).length), (double)d, (double)0.03);
                }
            }
        }
    }

    @Theory
    public void testCalculateMap(@ForAll(sampleSize=100) @From(value={GraphicalModelGenerator.class}) GraphicalModel model, @ForAll(sampleSize=2) @From(value={WeightsGenerator.class}) ConcatVector weights) throws Exception {
        if (model.factors.size() == 0) {
            return;
        }
        CliqueTree inference = new CliqueTree(model, weights);
        this.checkMAPAgainstBruteForce(model, weights, inference);
        Random r = new Random();
        for (int i = 0; i < 10; ++i) {
            this.randomlyMutateGraphicalModel(model, r);
            this.checkMAPAgainstBruteForce(model, weights, inference);
        }
    }

    public void checkMAPAgainstBruteForce(GraphicalModel model, ConcatVector weights, CliqueTree inference) {
        int[] map = inference.calculateMAP();
        Set tableFactors = model.factors.stream().map(factor -> new TableFactor(weights, (GraphicalModel.Factor)factor)).collect(Collectors.toSet());
        TableFactor bruteForce = null;
        for (Object factor2 : tableFactors) {
            if (bruteForce == null) {
                bruteForce = factor2;
                continue;
            }
            bruteForce = bruteForce.multiply((TableFactor)factor2);
        }
        assert (bruteForce != null);
        TableFactor observed = bruteForce;
        for (Object n : (Object)bruteForce.neighborIndices) {
            if (!model.getVariableMetaDataByReference((int)n).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE")) continue;
            int value = Integer.parseInt(model.getVariableMetaDataByReference((int)n).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
            if (observed.neighborIndices.length > 1) {
                observed = observed.observe((int)n, value);
                continue;
            }
            return;
        }
        bruteForce = observed;
        int largestVariableNum = 0;
        for (GraphicalModel.Factor f : model.factors) {
            for (int i : f.neigborIndices) {
                if (i <= largestVariableNum) continue;
                largestVariableNum = i;
            }
        }
        int[] mapValueAssignment = new int[largestVariableNum + 1];
        int[] highestValueAssignment = new int[bruteForce.neighborIndices.length];
        for (int[] assignment : bruteForce) {
            if (!(bruteForce.getAssignmentValue(assignment) > bruteForce.getAssignmentValue(highestValueAssignment))) continue;
            highestValueAssignment = assignment;
            for (int i = 0; i < assignment.length; ++i) {
                mapValueAssignment[bruteForce.neighborIndices[i]] = assignment[i];
            }
        }
        int[] forcedAssignments = new int[largestVariableNum + 1];
        for (int i = 0; i < mapValueAssignment.length; ++i) {
            if (!model.getVariableMetaDataByReference(i).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE")) continue;
            mapValueAssignment[i] = Integer.parseInt(model.getVariableMetaDataByReference(i).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
            forcedAssignments[i] = mapValueAssignment[i];
        }
        if (!Arrays.equals(mapValueAssignment, map)) {
            System.err.println("---");
            System.err.println("Relevant variables: " + Arrays.toString(bruteForce.neighborIndices));
            System.err.println("Var Sizes: " + Arrays.toString(bruteForce.getDimensions()));
            System.err.println("MAP: " + Arrays.toString(map));
            System.err.println("Brute force map: " + Arrays.toString(mapValueAssignment));
            System.err.println("Forced assignments: " + Arrays.toString(forcedAssignments));
        }
        for (int i : bruteForce.neighborIndices) {
            Assert.assertEquals((long)mapValueAssignment[i], (long)map[i]);
        }
    }

    public static class GraphicalModelGenerator
    extends Generator<GraphicalModel> {
        public GraphicalModelGenerator(Class<GraphicalModel> type) {
            super(type);
        }

        private Map<String, String> generateMetaData(SourceOfRandomness sourceOfRandomness, Map<String, String> metaData) {
            int numPairs = sourceOfRandomness.nextInt(9);
            for (int i = 0; i < numPairs; ++i) {
                int key = sourceOfRandomness.nextInt();
                int value = sourceOfRandomness.nextInt();
                metaData.put("key:" + key, "value:" + value);
            }
            return metaData;
        }

        public GraphicalModel generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int i;
            GraphicalModel model = new GraphicalModel();
            int[] variableSizes = new int[8];
            for (i = 0; i < variableSizes.length; ++i) {
                variableSizes[i] = sourceOfRandomness.nextInt(1, 3);
            }
            if (sourceOfRandomness.nextBoolean()) {
                this.generateCliques(variableSizes, new ArrayList<Integer>(), new HashSet<Integer>(), model, sourceOfRandomness);
            } else {
                for (i = 0; i < variableSizes.length; ++i) {
                    Object assignment22;
                    GraphicalModel.Factor unary = model.addFactor(new int[]{i}, new int[]{variableSizes[i]}, assignment -> {
                        ConcatVector features = new ConcatVector(2);
                        for (int j = 0; j < 2; ++j) {
                            if (sourceOfRandomness.nextBoolean()) {
                                features.setSparseComponent(j, sourceOfRandomness.nextInt(3), sourceOfRandomness.nextDouble());
                                continue;
                            }
                            double[] dense = new double[sourceOfRandomness.nextInt(3)];
                            for (int k = 0; k < dense.length; ++k) {
                                dense[k] = sourceOfRandomness.nextDouble();
                            }
                            features.setDenseComponent(j, dense);
                        }
                        return features;
                    });
                    for (Object assignment22 : unary.featuresTable) {
                        ConcatVector randomlyGenerated = (ConcatVector)((Supplier)unary.featuresTable.getAssignmentValue((int[])assignment22)).get();
                        unary.featuresTable.setAssignmentValue((int[])assignment22, () -> randomlyGenerated);
                    }
                    if (i >= variableSizes.length - 1) continue;
                    GraphicalModel.Factor binary = model.addFactor(new int[]{i, i + 1}, new int[]{variableSizes[i], variableSizes[i + 1]}, assignment -> {
                        ConcatVector features = new ConcatVector(2);
                        for (int j = 0; j < 2; ++j) {
                            if (sourceOfRandomness.nextBoolean()) {
                                features.setSparseComponent(j, sourceOfRandomness.nextInt(3), sourceOfRandomness.nextDouble());
                                continue;
                            }
                            double[] dense = new double[sourceOfRandomness.nextInt(3)];
                            for (int k = 0; k < dense.length; ++k) {
                                dense[k] = sourceOfRandomness.nextDouble();
                            }
                            features.setDenseComponent(j, dense);
                        }
                        return features;
                    });
                    assignment22 = binary.featuresTable.iterator();
                    while (assignment22.hasNext()) {
                        int[] assignment3 = (int[])assignment22.next();
                        ConcatVector randomlyGenerated = (ConcatVector)((Supplier)binary.featuresTable.getAssignmentValue(assignment3)).get();
                        binary.featuresTable.setAssignmentValue(assignment3, () -> randomlyGenerated);
                    }
                }
            }
            this.generateMetaData(sourceOfRandomness, model.getModelMetaDataByReference());
            for (i = 0; i < 20; ++i) {
                this.generateMetaData(sourceOfRandomness, model.getVariableMetaDataByReference(i));
            }
            for (GraphicalModel.Factor factor : model.factors) {
                this.generateMetaData(sourceOfRandomness, factor.getMetaDataByReference());
            }
            for (GraphicalModel.Factor f : model.factors) {
                for (int i2 = 0; i2 < f.neigborIndices.length; ++i2) {
                    if (!(sourceOfRandomness.nextDouble() > 0.8)) continue;
                    int obs = sourceOfRandomness.nextInt(f.featuresTable.getDimensions()[i2]);
                    model.getVariableMetaDataByReference(f.neigborIndices[i2]).put("inference.CliqueTree.VARIABLE_OBSERVED_VALUE", "" + obs);
                }
            }
            return model;
        }

        private void generateCliques(int[] variableSizes, List<Integer> startSet, Set<Integer> alreadyRepresented, GraphicalModel model, SourceOfRandomness randomness) {
            if (alreadyRepresented.size() == variableSizes.length) {
                return;
            }
            ArrayList<Integer> cliqueContents = new ArrayList<Integer>();
            cliqueContents.addAll(startSet);
            alreadyRepresented.addAll(startSet);
            while (alreadyRepresented.size() != variableSizes.length && (cliqueContents.size() == 0 || randomness.nextDouble(0.0, 1.0) < 0.7)) {
                int gen;
                while (alreadyRepresented.contains(gen = randomness.nextInt(variableSizes.length))) {
                }
                alreadyRepresented.add(gen);
                cliqueContents.add(gen);
            }
            int[] neighbors = new int[cliqueContents.size()];
            int[] neighborSizes = new int[neighbors.length];
            for (int j = 0; j < neighbors.length; ++j) {
                neighbors[j] = (Integer)cliqueContents.get(j);
                neighborSizes[j] = variableSizes[neighbors[j]];
            }
            ConcatVectorTable table = new ConcatVectorTable(neighborSizes);
            for (int[] assignment : table) {
                ConcatVector v = new ConcatVector(2);
                for (int x = 0; x < 2; ++x) {
                    if (randomness.nextBoolean()) {
                        v.setSparseComponent(x, randomness.nextInt(32), randomness.nextDouble());
                        continue;
                    }
                    double[] val = new double[randomness.nextInt(12)];
                    for (int i = 0; i < val.length; ++i) {
                        val[i] = randomness.nextDouble();
                    }
                    v.setDenseComponent(x, val);
                }
                table.setAssignmentValue(assignment, () -> v);
            }
            model.addFactor(table, neighbors);
            ArrayList<Integer> availableVariables = new ArrayList<Integer>();
            availableVariables.addAll(cliqueContents);
            availableVariables.removeAll(startSet);
            int numChildren = randomness.nextInt(0, availableVariables.size());
            if (numChildren == 0) {
                return;
            }
            ArrayList children = new ArrayList();
            for (int i = 0; i < numChildren; ++i) {
                children.add(new ArrayList());
            }
            int cursor = 0;
            while (availableVariables.size() != 0 && (((List)children.get(cursor)).size() == 0 || randomness.nextBoolean())) {
                int gen = randomness.nextInt(availableVariables.size());
                ((List)children.get(cursor)).add(availableVariables.get(gen));
                availableVariables.remove(availableVariables.get(gen));
                cursor = (cursor + 1) % numChildren;
            }
            for (List list : children) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (List list2 : children) {
                        assert (list == list2 || !list2.contains(i));
                    }
                }
            }
            for (List list : children) {
                if (list.size() <= 0) continue;
                this.generateCliques(variableSizes, list, alreadyRepresented, model, randomness);
            }
        }
    }

    public static class WeightsGenerator
    extends Generator<ConcatVector> {
        public WeightsGenerator(Class<ConcatVector> type) {
            super(type);
        }

        public ConcatVector generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            ConcatVector v = new ConcatVector(2);
            for (int x = 0; x < 2; ++x) {
                if (sourceOfRandomness.nextBoolean()) {
                    v.setSparseComponent(x, sourceOfRandomness.nextInt(3), sourceOfRandomness.nextDouble());
                    continue;
                }
                double[] val = new double[sourceOfRandomness.nextInt(3)];
                for (int y = 0; y < val.length; ++y) {
                    val[y] = sourceOfRandomness.nextDouble();
                }
                v.setDenseComponent(x, val);
            }
            return v;
        }
    }
}

