/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.inference;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.inference.TableFactor;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class TableFactorTest {
    public static int[] variableSizes = new int[]{2, 4, 2, 3};

    @Theory
    public void testConstructWithObservations(@ForAll(sampleSize=50) @From(value={PartiallyObservedConstructorDataGenerator.class}) PartiallyObservedConstructorData data, @ForAll(sampleSize=2) @From(value={ConcatVectorGenerator.class}) ConcatVector weights) throws Exception {
        int i;
        int[] obsArray = new int[9];
        for (i = 0; i < obsArray.length; ++i) {
            obsArray[i] = -1;
        }
        for (i = 0; i < data.observations.length; ++i) {
            obsArray[data.factor.neigborIndices[i]] = data.observations[i];
        }
        TableFactor normalObservations = new TableFactor(weights, data.factor);
        for (int i2 = 0; i2 < obsArray.length; ++i2) {
            if (obsArray[i2] == -1) continue;
            normalObservations = normalObservations.observe(i2, obsArray[i2]);
        }
        TableFactor constructedObservations = new TableFactor(weights, data.factor, data.observations);
        Assert.assertArrayEquals((int[])normalObservations.neighborIndices, (int[])constructedObservations.neighborIndices);
        for (int[] assn : normalObservations) {
            Assert.assertEquals((double)normalObservations.getAssignmentValue(assn), (double)constructedObservations.getAssignmentValue(assn), (double)1.0E-9);
        }
    }

    @Theory
    public void testObserve(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor, @ForAll(sampleSize=2) @InRange(minInt=0, maxInt=3) int observe, @ForAll(sampleSize=2) @InRange(minInt=0, maxInt=1) int value) throws Exception {
        if (!Arrays.stream(factor.neighborIndices).boxed().collect(Collectors.toSet()).contains(observe)) {
            return;
        }
        if (factor.neighborIndices.length == 1) {
            return;
        }
        TableFactor observedOut = factor.observe(observe, value);
        int observeIndex = -1;
        for (int i = 0; i < factor.neighborIndices.length; ++i) {
            if (factor.neighborIndices[i] != observe) continue;
            observeIndex = i;
        }
        for (int[] assignment : factor) {
            if (assignment[observeIndex] != value) continue;
            Assert.assertEquals((double)factor.getAssignmentValue(assignment), (double)observedOut.getAssignmentValue(this.subsetAssignment(assignment, factor, observedOut)), (double)1.0E-7);
        }
    }

    @Theory
    public void testGetMaxedMarginals(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor, @ForAll(sampleSize=10) @InRange(minInt=0, maxInt=3) int marginalizeTo) throws Exception {
        if (!Arrays.stream(factor.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalizeTo)) {
            return;
        }
        int indexOfVariable = -1;
        for (int i = 0; i < factor.neighborIndices.length; ++i) {
            if (factor.neighborIndices[i] != marginalizeTo) continue;
            indexOfVariable = i;
            break;
        }
        Assume.assumeTrue((indexOfVariable > -1 ? 1 : 0) != 0);
        double[] gold = new double[factor.getDimensions()[indexOfVariable]];
        for (int i = 0; i < gold.length; ++i) {
            gold[i] = Double.NEGATIVE_INFINITY;
        }
        for (int[] assignment : factor) {
            gold[assignment[indexOfVariable]] = Math.max(gold[assignment[indexOfVariable]], factor.getAssignmentValue(assignment));
        }
        this.normalize(gold);
        Assert.assertArrayEquals((double[])gold, (double[])factor.getMaxedMarginals()[indexOfVariable], (double)1.0E-5);
    }

    @Theory
    public void testGetSummedMarginals(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor, @ForAll(sampleSize=10) @InRange(minInt=0, maxInt=3) int marginalizeTo) throws Exception {
        if (!Arrays.stream(factor.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalizeTo)) {
            return;
        }
        int indexOfVariable = -1;
        for (int i = 0; i < factor.neighborIndices.length; ++i) {
            if (factor.neighborIndices[i] != marginalizeTo) continue;
            indexOfVariable = i;
            break;
        }
        Assume.assumeTrue((indexOfVariable > -1 ? 1 : 0) != 0);
        double[] gold = new double[factor.getDimensions()[indexOfVariable]];
        for (int[] assignment : factor) {
            gold[assignment[indexOfVariable]] = gold[assignment[indexOfVariable]] + factor.getAssignmentValue(assignment);
        }
        this.normalize(gold);
        Assert.assertArrayEquals((double[])gold, (double[])factor.getSummedMarginals()[indexOfVariable], (double)1.0E-5);
    }

    private void normalize(double[] arr) {
        double sum = 0.0;
        for (double d : arr) {
            sum += d;
        }
        if (sum == 0.0) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = 1.0 / (double)arr.length;
            }
        } else {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i] / sum;
            }
        }
    }

    @Theory
    public void testValueSum(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor) throws Exception {
        double sum = 0.0;
        for (int[] assignment : factor) {
            sum += factor.getAssignmentValue(assignment);
        }
        Assert.assertEquals((double)sum, (double)factor.valueSum(), (double)1.0E-5);
    }

    @Theory
    public void testMaxOut(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor, @ForAll(sampleSize=10) @InRange(minInt=0, maxInt=3) int marginalize) throws Exception {
        if (!Arrays.stream(factor.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalize)) {
            return;
        }
        if (factor.neighborIndices.length <= 1) {
            return;
        }
        TableFactor maxedOut = factor.maxOut(marginalize);
        Assert.assertEquals((long)(factor.neighborIndices.length - 1), (long)maxedOut.neighborIndices.length);
        Assert.assertTrue((!Arrays.stream(maxedOut.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalize) ? 1 : 0) != 0);
        for (int[] assignment : factor) {
            Assert.assertTrue((factor.getAssignmentValue(assignment) >= Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
            Assert.assertTrue((factor.getAssignmentValue(assignment) <= maxedOut.getAssignmentValue(this.subsetAssignment(assignment, factor, maxedOut)) ? 1 : 0) != 0);
        }
        Map<List<Integer>, List<int[]>> subsetToSuperset = this.subsetToSupersetAssignments(factor, maxedOut);
        for (List<Integer> subsetAssignmentList : subsetToSuperset.keySet()) {
            double max = Double.NEGATIVE_INFINITY;
            for (int[] supersetAssignment : subsetToSuperset.get(subsetAssignmentList)) {
                max = Math.max(max, factor.getAssignmentValue(supersetAssignment));
            }
            int[] subsetAssignment = new int[subsetAssignmentList.size()];
            for (int i = 0; i < subsetAssignment.length; ++i) {
                subsetAssignment[i] = subsetAssignmentList.get(i);
            }
            Assert.assertEquals((double)max, (double)maxedOut.getAssignmentValue(subsetAssignment), (double)1.0E-5);
        }
    }

    @Theory
    public void testSumOut(@ForAll(sampleSize=50) @From(value={TableFactorGenerator.class}) TableFactor factor, @ForAll(sampleSize=10) @InRange(minInt=0, maxInt=3) int marginalize) throws Exception {
        if (!Arrays.stream(factor.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalize)) {
            return;
        }
        if (factor.neighborIndices.length <= 1) {
            return;
        }
        TableFactor summedOut = factor.sumOut(marginalize);
        Assert.assertEquals((long)(factor.neighborIndices.length - 1), (long)summedOut.neighborIndices.length);
        Assert.assertTrue((!Arrays.stream(summedOut.neighborIndices).boxed().collect(Collectors.toSet()).contains(marginalize) ? 1 : 0) != 0);
        Map<List<Integer>, List<int[]>> subsetToSuperset = this.subsetToSupersetAssignments(factor, summedOut);
        for (List<Integer> subsetAssignmentList : subsetToSuperset.keySet()) {
            double sum = 0.0;
            for (int[] supersetAssignment : subsetToSuperset.get(subsetAssignmentList)) {
                sum += factor.getAssignmentValue(supersetAssignment);
            }
            int[] subsetAssignment = new int[subsetAssignmentList.size()];
            for (int i = 0; i < subsetAssignment.length; ++i) {
                subsetAssignment[i] = subsetAssignmentList.get(i);
            }
            Assert.assertEquals((double)sum, (double)summedOut.getAssignmentValue(subsetAssignment), (double)1.0E-5);
        }
    }

    @Theory
    public void testMultiply(@ForAll(sampleSize=10) @From(value={TableFactorGenerator.class}) TableFactor factor1, @ForAll(sampleSize=10) @From(value={TableFactorGenerator.class}) TableFactor factor2) throws Exception {
        TableFactor result = factor1.multiply(factor2);
        for (int[] assignment : result) {
            double factor1Value = factor1.getAssignmentValue(this.subsetAssignment(assignment, result, factor1));
            double factor2Value = factor2.getAssignmentValue(this.subsetAssignment(assignment, result, factor2));
            Assert.assertEquals((double)(factor1Value * factor2Value), (double)result.getAssignmentValue(assignment), (double)1.0E-5);
        }
        for (int i = 0; i < result.neighborIndices.length; ++i) {
            for (int j = 0; j < result.neighborIndices.length; ++j) {
                if (i == j) continue;
                Assert.assertNotEquals((long)result.neighborIndices[i], (long)result.neighborIndices[j]);
            }
        }
    }

    private int[] subsetAssignment(int[] supersetAssignment, TableFactor superset, TableFactor subset) {
        int[] subsetAssignment = new int[subset.neighborIndices.length];
        for (int i = 0; i < subset.neighborIndices.length; ++i) {
            int var = subset.neighborIndices[i];
            subsetAssignment[i] = -1;
            for (int j = 0; j < superset.neighborIndices.length; ++j) {
                if (superset.neighborIndices[j] != var) continue;
                subsetAssignment[i] = supersetAssignment[j];
                break;
            }
            assert (subsetAssignment[i] != -1);
        }
        return subsetAssignment;
    }

    private Map<List<Integer>, List<int[]>> subsetToSupersetAssignments(TableFactor superset, TableFactor subset) {
        HashMap<List<Integer>, List<int[]>> subsetToSupersets = new HashMap<List<Integer>, List<int[]>>();
        for (int[] assignment : subset) {
            List subsetAssignmentList = Arrays.stream(assignment).boxed().collect(Collectors.toList());
            ArrayList<int[]> supersetAssignments = new ArrayList<int[]>();
            for (int[] supersetAssignment : superset) {
                if (!Arrays.equals(assignment, this.subsetAssignment(supersetAssignment, superset, subset))) continue;
                supersetAssignments.add(supersetAssignment);
            }
            subsetToSupersets.put(subsetAssignmentList, supersetAssignments);
        }
        return subsetToSupersets;
    }

    public static class PartiallyObservedConstructorDataGenerator
    extends Generator<PartiallyObservedConstructorData> {
        public PartiallyObservedConstructorDataGenerator(Class<PartiallyObservedConstructorData> type) {
            super(type);
        }

        public PartiallyObservedConstructorData generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int len = sourceOfRandomness.nextInt(1, 4);
            HashSet<Integer> taken = new HashSet<Integer>();
            int[] neighborIndices = new int[len];
            int[] dimensions = new int[len];
            int[] observations = new int[len];
            int numObserved = 0;
            for (int i = 0; i < len; ++i) {
                int j = sourceOfRandomness.nextInt(8);
                while (taken.contains(j)) {
                    j = sourceOfRandomness.nextInt(8);
                }
                taken.add(j);
                neighborIndices[i] = j;
                dimensions[i] = sourceOfRandomness.nextInt(1, 3);
                if (sourceOfRandomness.nextBoolean() && numObserved + 1 < dimensions.length) {
                    observations[i] = sourceOfRandomness.nextInt(dimensions[i]);
                    ++numObserved;
                    continue;
                }
                observations[i] = -1;
            }
            ConcatVectorTable t = new ConcatVectorTable(dimensions);
            ConcatVectorGenerator gen = new ConcatVectorGenerator(ConcatVector.class);
            for (int[] assn : t) {
                ConcatVector vec = gen.generate(sourceOfRandomness, generationStatus);
                t.setAssignmentValue(assn, () -> vec);
            }
            PartiallyObservedConstructorData data = new PartiallyObservedConstructorData();
            data.factor = new GraphicalModel.Factor(t, neighborIndices);
            data.observations = observations;
            return data;
        }
    }

    private static class PartiallyObservedConstructorData {
        public GraphicalModel.Factor factor;
        public int[] observations;

        private PartiallyObservedConstructorData() {
        }
    }

    public static class ConcatVectorGenerator
    extends Generator<ConcatVector> {
        public ConcatVectorGenerator(Class<ConcatVector> type) {
            super(type);
        }

        public ConcatVector generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            ConcatVector vec = new ConcatVector(1);
            double[] d = new double[20];
            for (int i = 0; i < d.length; ++i) {
                d[i] = sourceOfRandomness.nextDouble();
            }
            vec.setDenseComponent(0, d);
            return vec;
        }
    }

    public static class TableFactorGenerator
    extends Generator<TableFactor> {
        public TableFactorGenerator(Class<TableFactor> type) {
            super(type);
        }

        public TableFactor generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int numNeighbors = sourceOfRandomness.nextInt(1, 3);
            int[] neighbors = new int[numNeighbors];
            int[] dimensions = new int[numNeighbors];
            HashSet<Integer> usedNeighbors = new HashSet<Integer>();
            for (int i = 0; i < neighbors.length; ++i) {
                int neighbor;
                while (usedNeighbors.contains(neighbor = sourceOfRandomness.nextInt(0, 3))) {
                }
                usedNeighbors.add(neighbor);
                neighbors[i] = neighbor;
                dimensions[i] = variableSizes[neighbor];
            }
            double multiple = sourceOfRandomness.nextDouble();
            TableFactor factor = new TableFactor(neighbors, dimensions);
            for (int[] assignment : factor) {
                factor.setAssignmentValue(assignment, multiple * sourceOfRandomness.nextDouble());
            }
            return factor;
        }
    }
}

