/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.learning;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.inference.TableFactor;
import edu.stanford.nlp.loglinear.learning.LogLikelihoodDifferentiableFunction;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import edu.stanford.nlp.loglinear.model.GraphicalModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class LogLikelihoodFunctionTest {
    public static final int CONCAT_VEC_COMPONENTS = 2;
    public static final int CONCAT_VEC_COMPONENT_LENGTH = 3;

    @Theory
    public void testGetSummaryForInstance(@ForAll(sampleSize=50) @From(value={GraphicalModelDatasetGenerator.class}) GraphicalModel[] dataset, @ForAll(sampleSize=2) @From(value={WeightsGenerator.class}) ConcatVector weights) throws Exception {
        LogLikelihoodDifferentiableFunction fn = new LogLikelihoodDifferentiableFunction();
        for (GraphicalModel model : dataset) {
            double goldLogLikelihood = this.logLikelihood(model, weights);
            ConcatVector goldGradient = this.definitionOfDerivative(model, weights);
            ConcatVector gradient = new ConcatVector(0);
            double logLikelihood = fn.getSummaryForInstance(model, weights, gradient);
            Assert.assertEquals((double)goldLogLikelihood, (double)logLikelihood, (double)Math.max(0.001, goldLogLikelihood * 0.01));
            ConcatVector difference = goldGradient.deepClone();
            difference.addVectorInPlace(gradient, -1.0);
            double distance = Math.sqrt(difference.dotProduct(difference));
            if (distance > 0.05) {
                System.err.println("Definitional and calculated gradient differ!");
                System.err.println("Definition approx: " + goldGradient);
                System.err.println("Calculated: " + gradient);
            }
            Assert.assertEquals((double)0.0, (double)distance, (double)0.05);
        }
    }

    private double logLikelihood(GraphicalModel model, ConcatVector weights) {
        Set tableFactors = model.factors.stream().map(factor -> new TableFactor(weights, (GraphicalModel.Factor)factor)).collect(Collectors.toSet());
        assert (tableFactors.size() == model.factors.size());
        TableFactor bruteForce = null;
        for (Object factor2 : tableFactors) {
            if (bruteForce == null) {
                bruteForce = factor2;
                continue;
            }
            bruteForce = bruteForce.multiply((TableFactor)factor2);
        }
        assert (bruteForce != null);
        TableFactor observed = bruteForce;
        for (Object n : (Object)bruteForce.neighborIndices) {
            if (!model.getVariableMetaDataByReference((int)n).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE")) continue;
            int value = Integer.parseInt(model.getVariableMetaDataByReference((int)n).get("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
            if (observed.neighborIndices.length > 1) {
                observed = observed.observe((int)n, value);
                continue;
            }
            return 0.0;
        }
        bruteForce = observed;
        double partitionFunction = bruteForce.valueSum();
        int[] assignment = new int[bruteForce.neighborIndices.length];
        for (int i = 0; i < assignment.length; ++i) {
            assert (!model.getVariableMetaDataByReference(bruteForce.neighborIndices[i]).containsKey("inference.CliqueTree.VARIABLE_OBSERVED_VALUE"));
            assignment[i] = Integer.parseInt(model.getVariableMetaDataByReference(bruteForce.neighborIndices[i]).get("learning.LogLikelihoodDifferentiableFunction.VARIABLE_TRAINING_VALUE"));
        }
        if (bruteForce.getAssignmentValue(assignment) == 0.0 || partitionFunction == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(bruteForce.getAssignmentValue(assignment)) - Math.log(partitionFunction);
    }

    private ConcatVector definitionOfDerivative(GraphicalModel model, ConcatVector weights) {
        double epsilon = 1.0E-7;
        ConcatVector goldGradient = new ConcatVector(2);
        for (int i = 0; i < 2; ++i) {
            double[] component = new double[3];
            for (int j = 0; j < 3; ++j) {
                ConcatVector unitVectorIJ = new ConcatVector(2);
                unitVectorIJ.setSparseComponent(i, j, 1.0);
                ConcatVector weightsPlusEpsilon = weights.deepClone();
                weightsPlusEpsilon.addVectorInPlace(unitVectorIJ, epsilon);
                ConcatVector weightsMinusEpsilon = weights.deepClone();
                weightsMinusEpsilon.addVectorInPlace(unitVectorIJ, -epsilon);
                component[j] = (this.logLikelihood(model, weightsPlusEpsilon) - this.logLikelihood(model, weightsMinusEpsilon)) / (2.0 * epsilon);
                if (!Double.isNaN(component[j])) continue;
                component[j] = 0.0;
            }
            goldGradient.setDenseComponent(i, component);
        }
        return goldGradient;
    }

    public static class GraphicalModelGenerator
    extends Generator<GraphicalModel> {
        public GraphicalModelGenerator(Class<GraphicalModel> type) {
            super(type);
        }

        private Map<String, String> generateMetaData(SourceOfRandomness sourceOfRandomness, Map<String, String> metaData) {
            int numPairs = sourceOfRandomness.nextInt(9);
            for (int i = 0; i < numPairs; ++i) {
                int key = sourceOfRandomness.nextInt();
                int value = sourceOfRandomness.nextInt();
                metaData.put("key:" + key, "value:" + value);
            }
            return metaData;
        }

        public GraphicalModel generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int i;
            GraphicalModel model = new GraphicalModel();
            int[] variableSizes = new int[8];
            for (i = 0; i < variableSizes.length; ++i) {
                variableSizes[i] = sourceOfRandomness.nextInt(1, 3);
            }
            this.generateCliques(variableSizes, new ArrayList<Integer>(), new HashSet<Integer>(), model, sourceOfRandomness);
            this.generateMetaData(sourceOfRandomness, model.getModelMetaDataByReference());
            for (i = 0; i < 20; ++i) {
                this.generateMetaData(sourceOfRandomness, model.getVariableMetaDataByReference(i));
            }
            for (GraphicalModel.Factor factor : model.factors) {
                this.generateMetaData(sourceOfRandomness, factor.getMetaDataByReference());
            }
            for (GraphicalModel.Factor f : model.factors) {
                for (int i2 = 0; i2 < f.neigborIndices.length; ++i2) {
                    if (!(sourceOfRandomness.nextDouble() > 0.8)) continue;
                    int obs = sourceOfRandomness.nextInt(f.featuresTable.getDimensions()[i2]);
                    model.getVariableMetaDataByReference(f.neigborIndices[i2]).put("inference.CliqueTree.VARIABLE_OBSERVED_VALUE", "" + obs);
                }
            }
            return model;
        }

        private void generateCliques(int[] variableSizes, List<Integer> startSet, Set<Integer> alreadyRepresented, GraphicalModel model, SourceOfRandomness randomness) {
            if (alreadyRepresented.size() == variableSizes.length) {
                return;
            }
            ArrayList<Integer> cliqueContents = new ArrayList<Integer>();
            cliqueContents.addAll(startSet);
            while (alreadyRepresented.size() != variableSizes.length && (cliqueContents.size() == 0 || randomness.nextDouble(0.0, 1.0) < 0.7)) {
                int gen;
                while (alreadyRepresented.contains(gen = randomness.nextInt(variableSizes.length))) {
                }
                alreadyRepresented.add(gen);
                cliqueContents.add(gen);
            }
            int[] neighbors = new int[cliqueContents.size()];
            int[] neighborSizes = new int[neighbors.length];
            for (int j = 0; j < neighbors.length; ++j) {
                neighbors[j] = (Integer)cliqueContents.get(j);
                neighborSizes[j] = variableSizes[neighbors[j]];
            }
            ConcatVectorTable table = new ConcatVectorTable(neighborSizes);
            for (int[] assignment : table) {
                ConcatVector v = new ConcatVector(2);
                for (int x = 0; x < 2; ++x) {
                    if (randomness.nextBoolean()) {
                        v.setSparseComponent(x, randomness.nextInt(3), randomness.nextDouble());
                        continue;
                    }
                    double[] val = new double[randomness.nextInt(3)];
                    for (int i = 0; i < val.length; ++i) {
                        val[i] = randomness.nextDouble();
                    }
                    v.setDenseComponent(x, val);
                }
                table.setAssignmentValue(assignment, () -> v);
            }
            model.addFactor(table, neighbors);
            ArrayList<Integer> availableVariables = new ArrayList<Integer>();
            availableVariables.addAll(cliqueContents);
            availableVariables.removeAll(startSet);
            int numChildren = randomness.nextInt(0, availableVariables.size());
            if (numChildren == 0) {
                return;
            }
            ArrayList children = new ArrayList();
            for (int i = 0; i < numChildren; ++i) {
                children.add(new ArrayList());
            }
            int cursor = 0;
            while (availableVariables.size() != 0 && (((List)children.get(cursor)).size() == 0 || randomness.nextBoolean())) {
                int gen = randomness.nextInt(availableVariables.size());
                ((List)children.get(cursor)).add(availableVariables.get(gen));
                availableVariables.remove(availableVariables.get(gen));
                cursor = (cursor + 1) % numChildren;
            }
            for (List list : children) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    for (List list2 : children) {
                        assert (list == list2 || !list2.contains(i));
                    }
                }
            }
            for (List list : children) {
                if (list.size() <= 0) continue;
                this.generateCliques(variableSizes, list, alreadyRepresented, model, randomness);
            }
        }
    }

    public static class WeightsGenerator
    extends Generator<ConcatVector> {
        public WeightsGenerator(Class<ConcatVector> type) {
            super(type);
        }

        public ConcatVector generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            ConcatVector v = new ConcatVector(2);
            for (int x = 0; x < 2; ++x) {
                if (sourceOfRandomness.nextBoolean()) {
                    v.setSparseComponent(x, sourceOfRandomness.nextInt(3), sourceOfRandomness.nextDouble());
                    continue;
                }
                double[] val = new double[sourceOfRandomness.nextInt(3)];
                for (int y = 0; y < val.length; ++y) {
                    val[y] = sourceOfRandomness.nextDouble();
                }
                v.setDenseComponent(x, val);
            }
            return v;
        }
    }

    public static class GraphicalModelDatasetGenerator
    extends Generator<GraphicalModel[]> {
        GraphicalModelGenerator modelGenerator = new GraphicalModelGenerator(GraphicalModel.class);

        public GraphicalModelDatasetGenerator(Class<GraphicalModel[]> type) {
            super(type);
        }

        public GraphicalModel[] generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            GraphicalModel[] dataset = new GraphicalModel[sourceOfRandomness.nextInt(1, 10)];
            for (int i = 0; i < dataset.length; ++i) {
                dataset[i] = this.modelGenerator.generate(sourceOfRandomness, generationStatus);
                for (GraphicalModel.Factor f : dataset[i].factors) {
                    for (int j = 0; j < f.neigborIndices.length; ++j) {
                        int n = f.neigborIndices[j];
                        int dim = f.featuresTable.getDimensions()[j];
                        dataset[i].getVariableMetaDataByReference(n).put("learning.LogLikelihoodDifferentiableFunction.VARIABLE_TRAINING_VALUE", "" + sourceOfRandomness.nextInt(dim));
                    }
                }
            }
            return dataset;
        }
    }
}

