/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.loglinear.model;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.stanford.nlp.loglinear.model.ConcatVector;
import edu.stanford.nlp.loglinear.model.ConcatVectorTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.contrib.theories.Theories;
import org.junit.contrib.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class ConcatVectorTableTest {
    public static ConcatVectorTable convertArrayToVectorTable(ConcatVector[][][] factor3) {
        int[] neighborSizes = new int[]{factor3.length, factor3[0].length, factor3[0][0].length};
        ConcatVectorTable concatVectorTable = new ConcatVectorTable(neighborSizes);
        for (int i = 0; i < factor3.length; ++i) {
            for (int j = 0; j < factor3[0].length; ++j) {
                int k = 0;
                while (k < factor3[0][0].length) {
                    int iF = i;
                    int jF = j;
                    int kF = k;
                    concatVectorTable.setAssignmentValue(new int[]{i, j, k++}, () -> factor3[iF][jF][kF]);
                }
            }
        }
        return concatVectorTable;
    }

    @Theory
    public void testCache(@ForAll(sampleSize=50) @From(value={FeatureFactorGenerator.class}) ConcatVector[][][] factor3, @ForAll(sampleSize=10) @InRange(minInt=1, maxInt=30) int numUses) throws IOException {
        int[] assignment;
        int j;
        int i;
        int n;
        int k;
        int j2;
        int i2;
        int[] dimensions = new int[]{factor3.length, factor3[0].length, factor3[0][0].length};
        int[][][] thunkHits = new int[dimensions[0]][dimensions[1]][dimensions[2]];
        ConcatVectorTable table = new ConcatVectorTable(dimensions);
        for (i2 = 0; i2 < factor3.length; ++i2) {
            for (j2 = 0; j2 < factor3[0].length; ++j2) {
                k = 0;
                while (k < factor3[0][0].length) {
                    int[] assignment2 = new int[]{i2, j2, k++};
                    table.setAssignmentValue(assignment2, () -> {
                        int[] nArray = thunkHits[assignment2[0]][assignment2[1]];
                        int n = assignment2[2];
                        nArray[n] = nArray[n] + 1;
                        return factor3[assignment2[0]][assignment2[1]][assignment2[2]];
                    });
                }
            }
        }
        for (n = 0; n < numUses; ++n) {
            for (i = 0; i < factor3.length; ++i) {
                for (j = 0; j < factor3[0].length; ++j) {
                    int k2 = 0;
                    while (k2 < factor3[0][0].length) {
                        assignment = new int[]{i, j, k2++};
                        ((Supplier)table.getAssignmentValue(assignment)).get();
                    }
                }
            }
        }
        for (i2 = 0; i2 < factor3.length; ++i2) {
            for (j2 = 0; j2 < factor3[0].length; ++j2) {
                for (k = 0; k < factor3[0][0].length; ++k) {
                    Assert.assertEquals((long)numUses, (long)thunkHits[i2][j2][k]);
                }
            }
        }
        table.cacheVectors();
        for (n = 0; n < numUses; ++n) {
            for (i = 0; i < factor3.length; ++i) {
                for (j = 0; j < factor3[0].length; ++j) {
                    int k3 = 0;
                    while (k3 < factor3[0][0].length) {
                        assignment = new int[]{i, j, k3++};
                        ((Supplier)table.getAssignmentValue(assignment)).get();
                    }
                }
            }
        }
        for (i2 = 0; i2 < factor3.length; ++i2) {
            for (j2 = 0; j2 < factor3[0].length; ++j2) {
                for (k = 0; k < factor3[0][0].length; ++k) {
                    Assert.assertEquals((long)(numUses + 1), (long)thunkHits[i2][j2][k]);
                }
            }
        }
        table.releaseCache();
        for (n = 0; n < numUses; ++n) {
            for (i = 0; i < factor3.length; ++i) {
                for (j = 0; j < factor3[0].length; ++j) {
                    int k4 = 0;
                    while (k4 < factor3[0][0].length) {
                        assignment = new int[]{i, j, k4++};
                        ((Supplier)table.getAssignmentValue(assignment)).get();
                    }
                }
            }
        }
        for (i2 = 0; i2 < factor3.length; ++i2) {
            for (j2 = 0; j2 < factor3[0].length; ++j2) {
                for (k = 0; k < factor3[0][0].length; ++k) {
                    Assert.assertEquals((long)(2 * numUses + 1), (long)thunkHits[i2][j2][k]);
                }
            }
        }
    }

    @Theory
    public void testProtoTable(@ForAll(sampleSize=50) @From(value={FeatureFactorGenerator.class}) ConcatVector[][][] factor3) throws IOException {
        ConcatVectorTable concatVectorTable = ConcatVectorTableTest.convertArrayToVectorTable(factor3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        concatVectorTable.writeToStream(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ConcatVectorTable recovered = ConcatVectorTable.readFromStream(byteArrayInputStream);
        for (int i = 0; i < factor3.length; ++i) {
            for (int j = 0; j < factor3[0].length; ++j) {
                for (int k = 0; k < factor3[0][0].length; ++k) {
                    Assert.assertTrue((boolean)factor3[i][j][k].valueEquals((ConcatVector)((Supplier)recovered.getAssignmentValue(new int[]{i, j, k})).get(), 1.0E-5));
                }
            }
        }
        Assert.assertTrue((boolean)concatVectorTable.valueEquals(recovered, 1.0E-5));
    }

    @Theory
    public void testCloneTable(@ForAll(sampleSize=50) @From(value={FeatureFactorGenerator.class}) ConcatVector[][][] factor3) throws IOException {
        ConcatVectorTable concatVectorTable = ConcatVectorTableTest.convertArrayToVectorTable(factor3);
        ConcatVectorTable cloned = concatVectorTable.cloneTable();
        for (int i = 0; i < factor3.length; ++i) {
            for (int j = 0; j < factor3[0].length; ++j) {
                for (int k = 0; k < factor3[0][0].length; ++k) {
                    Assert.assertTrue((boolean)factor3[i][j][k].valueEquals((ConcatVector)((Supplier)cloned.getAssignmentValue(new int[]{i, j, k})).get(), 1.0E-5));
                }
            }
        }
        Assert.assertTrue((boolean)concatVectorTable.valueEquals(cloned, 1.0E-5));
    }

    public static class FeatureFactorGenerator
    extends Generator<ConcatVector[][][]> {
        public FeatureFactorGenerator(Class<ConcatVector[][][]> type) {
            super(type);
        }

        public ConcatVector[][][] generate(SourceOfRandomness sourceOfRandomness, GenerationStatus generationStatus) {
            int l = sourceOfRandomness.nextInt(10) + 1;
            int m = sourceOfRandomness.nextInt(10) + 1;
            int n = sourceOfRandomness.nextInt(10) + 1;
            ConcatVector[][][] factor3 = new ConcatVector[l][m][n];
            for (int i = 0; i < factor3.length; ++i) {
                for (int j = 0; j < factor3[0].length; ++j) {
                    for (int k = 0; k < factor3[0][0].length; ++k) {
                        int numComponents = sourceOfRandomness.nextInt(7);
                        ConcatVector v = new ConcatVector(numComponents);
                        for (int x = 0; x < numComponents; ++x) {
                            if (sourceOfRandomness.nextBoolean()) {
                                v.setSparseComponent(x, sourceOfRandomness.nextInt(32), sourceOfRandomness.nextDouble());
                                continue;
                            }
                            double[] val = new double[sourceOfRandomness.nextInt(12)];
                            for (int y = 0; y < val.length; ++y) {
                                val[y] = sourceOfRandomness.nextDouble();
                            }
                            v.setDenseComponent(x, val);
                        }
                        factor3[i][j][k] = v;
                    }
                }
            }
            return factor3;
        }
    }
}

