/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

import edu.stanford.nlp.math.ArrayMath;
import junit.framework.TestCase;

public class ArrayMathTest
extends TestCase {
    private double[] d1 = new double[3];
    private double[] d2 = new double[3];
    private double[] d3 = new double[3];
    private double[] d4 = new double[3];
    private double[] d5 = new double[4];

    public void setUp() {
        this.d1[0] = 1.0;
        this.d1[1] = 343.33;
        this.d1[2] = -13.1;
        this.d2[0] = 1.0;
        this.d2[1] = 343.33;
        this.d2[2] = -13.1;
        this.d3[0] = Double.NaN;
        this.d3[1] = Double.POSITIVE_INFINITY;
        this.d3[2] = 2.0;
        this.d4[0] = 0.1;
        this.d4[1] = 0.2;
        this.d4[2] = 0.3;
        this.d5[0] = 0.1;
        this.d5[1] = 0.2;
        this.d5[2] = 0.3;
        this.d5[3] = 0.8;
    }

    public void testInnerProduct() {
        double inner = ArrayMath.innerProduct(this.d4, this.d4);
        ArrayMathTest.assertEquals((String)"Wrong inner product", (double)0.14, (double)inner, (double)1.0E-6);
        inner = ArrayMath.innerProduct(this.d5, this.d5);
        ArrayMathTest.assertEquals((String)"Wrong inner product", (double)0.78, (double)inner, (double)1.0E-6);
    }

    public void testNumRows() {
        int nRows = ArrayMath.numRows(this.d1);
        ArrayMathTest.assertEquals((int)nRows, (int)3);
    }

    public void testExpLog() {
        double[] d1prime = ArrayMath.log(ArrayMath.exp(this.d1));
        double[] diff = ArrayMath.pairwiseSubtract(this.d1, d1prime);
        double norm2 = ArrayMath.norm(diff);
        ArrayMathTest.assertTrue((norm2 < 1.0E-4 ? 1 : 0) != 0);
    }

    public void testExpLogInplace() {
        ArrayMath.expInPlace(this.d1);
        ArrayMath.logInPlace(this.d1);
        ArrayMath.pairwiseSubtractInPlace(this.d1, this.d2);
        double norm2 = ArrayMath.norm(this.d1);
        ArrayMathTest.assertTrue((norm2 < 1.0E-4 ? 1 : 0) != 0);
    }

    public void testAddInPlace() {
        ArrayMath.addInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((this.d1[i] == this.d2[i] + 3.0 ? 1 : 0) != 0);
        }
    }

    public void testMultiplyInPlace() {
        ArrayMath.multiplyInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((this.d1[i] == this.d2[i] * 3.0 ? 1 : 0) != 0);
        }
    }

    public void testPowInPlace() {
        ArrayMath.powInPlace(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((this.d1[i] == Math.pow(this.d2[i], 3.0) ? 1 : 0) != 0);
        }
    }

    public void testAdd() {
        double[] d1prime = ArrayMath.add(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            ArrayMathTest.assertTrue((d1prime[i] == this.d1[i] + 3.0 ? 1 : 0) != 0);
        }
    }

    public void testMultiply() {
        double[] d1prime = ArrayMath.multiply(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            ArrayMathTest.assertTrue((d1prime[i] == this.d1[i] * 3.0 ? 1 : 0) != 0);
        }
    }

    public void testPow() {
        double[] d1prime = ArrayMath.pow(this.d1, 3.0);
        for (int i = 0; i < ArrayMath.numRows(d1prime); ++i) {
            ArrayMathTest.assertTrue((d1prime[i] == Math.pow(this.d1[i], 3.0) ? 1 : 0) != 0);
        }
    }

    public void testPairwiseAdd() {
        double[] sum = ArrayMath.pairwiseAdd(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((sum[i] == this.d1[i] + this.d2[i] ? 1 : 0) != 0);
        }
    }

    public void testPairwiseSubtract() {
        double[] diff = ArrayMath.pairwiseSubtract(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((diff[i] == this.d1[i] - this.d2[i] ? 1 : 0) != 0);
        }
    }

    public void testPairwiseMultiply() {
        double[] product = ArrayMath.pairwiseMultiply(this.d1, this.d2);
        for (int i = 0; i < ArrayMath.numRows(this.d1); ++i) {
            ArrayMathTest.assertTrue((product[i] == this.d1[i] * this.d2[i] ? 1 : 0) != 0);
        }
    }

    public void testHasNaN() {
        ArrayMathTest.assertFalse((boolean)ArrayMath.hasNaN(this.d1));
        ArrayMathTest.assertFalse((boolean)ArrayMath.hasNaN(this.d2));
        ArrayMathTest.assertTrue((boolean)ArrayMath.hasNaN(this.d3));
    }

    public void testHasInfinite() {
        ArrayMathTest.assertFalse((boolean)ArrayMath.hasInfinite(this.d1));
        ArrayMathTest.assertFalse((boolean)ArrayMath.hasInfinite(this.d2));
        ArrayMathTest.assertTrue((boolean)ArrayMath.hasInfinite(this.d3));
    }

    public void testCountNaN() {
        ArrayMathTest.assertTrue((ArrayMath.countNaN(this.d1) == 0 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countNaN(this.d2) == 0 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countNaN(this.d3) == 1 ? 1 : 0) != 0);
    }

    public void testFliterNaN() {
        double[] f_d3 = ArrayMath.filterNaN(this.d3);
        ArrayMathTest.assertTrue((ArrayMath.numRows(f_d3) == 2 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countNaN(f_d3) == 0 ? 1 : 0) != 0);
    }

    public void testCountInfinite() {
        ArrayMathTest.assertTrue((ArrayMath.countInfinite(this.d1) == 0 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countInfinite(this.d2) == 0 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countInfinite(this.d3) == 1 ? 1 : 0) != 0);
    }

    public void testFliterInfinite() {
        double[] f_d3 = ArrayMath.filterInfinite(this.d3);
        ArrayMathTest.assertTrue((ArrayMath.numRows(f_d3) == 2 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countInfinite(f_d3) == 0 ? 1 : 0) != 0);
    }

    public void testFliterNaNAndInfinite() {
        double[] f_d3 = ArrayMath.filterNaNAndInfinite(this.d3);
        ArrayMathTest.assertTrue((ArrayMath.numRows(f_d3) == 1 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countInfinite(f_d3) == 0 ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.countNaN(f_d3) == 0 ? 1 : 0) != 0);
    }

    public void testSum() {
        double sum = ArrayMath.sum(this.d1);
        double mySum = 0.0;
        for (double d : this.d1) {
            mySum += d;
        }
        ArrayMathTest.assertTrue((sum == mySum ? 1 : 0) != 0);
    }

    public void testNorm_inf() {
        double max;
        double ninf = ArrayMath.norm_inf(this.d1);
        ArrayMathTest.assertTrue((ninf == (max = ArrayMath.max(this.d1)) ? 1 : 0) != 0);
        ninf = ArrayMath.norm_inf(this.d2);
        max = ArrayMath.max(this.d2);
        ArrayMathTest.assertTrue((ninf == max ? 1 : 0) != 0);
        ninf = ArrayMath.norm_inf(this.d3);
        max = ArrayMath.max(this.d3);
        ArrayMathTest.assertTrue((ninf == max ? 1 : 0) != 0);
    }

    public void testArgmax() {
        ArrayMathTest.assertTrue((ArrayMath.max(this.d1) == this.d1[ArrayMath.argmax(this.d1)] ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.max(this.d2) == this.d2[ArrayMath.argmax(this.d2)] ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.max(this.d3) == this.d3[ArrayMath.argmax(this.d3)] ? 1 : 0) != 0);
    }

    public void testArgmin() {
        ArrayMathTest.assertTrue((ArrayMath.min(this.d1) == this.d1[ArrayMath.argmin(this.d1)] ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.min(this.d2) == this.d2[ArrayMath.argmin(this.d2)] ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.min(this.d3) == this.d3[ArrayMath.argmin(this.d3)] ? 1 : 0) != 0);
    }

    public void testLogSum() {
        double lsum = ArrayMath.logSum(this.d4);
        double myLsum = 0.0;
        for (double d : this.d4) {
            myLsum += Math.exp(d);
        }
        ArrayMathTest.assertTrue(((myLsum = Math.log(myLsum)) == lsum ? 1 : 0) != 0);
    }

    public void testNormalize() {
        double tol = 1.0E-4;
        ArrayMath.normalize(this.d1);
        ArrayMath.normalize(this.d2);
        ArrayMath.normalize(this.d4);
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d1) - 1.0 < tol ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d2) - 1.0 < tol ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d4) - 1.0 < tol ? 1 : 0) != 0);
    }

    public void testKLDivergence() {
        double kld = ArrayMath.klDivergence(this.d1, this.d2);
        ArrayMathTest.assertTrue((kld == 0.0 ? 1 : 0) != 0);
    }

    public void testSumAndMean() {
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d1) == ArrayMath.mean(this.d1) * (double)this.d1.length ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d2) == ArrayMath.mean(this.d2) * (double)this.d2.length ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((ArrayMath.sum(this.d4) == ArrayMath.mean(this.d4) * (double)this.d4.length ? 1 : 0) != 0);
    }

    public static void helpTestSafeSumAndMean(double[] d) {
        double[] dprime = ArrayMath.filterNaNAndInfinite(d);
        ArrayMathTest.assertTrue((ArrayMath.safeMean(d) * (double)ArrayMath.numRows(dprime) == ArrayMath.sum(dprime) ? 1 : 0) != 0);
    }

    public void testSafeSumAndMean() {
        ArrayMathTest.helpTestSafeSumAndMean(this.d1);
        ArrayMathTest.helpTestSafeSumAndMean(this.d2);
        ArrayMathTest.helpTestSafeSumAndMean(this.d3);
        ArrayMathTest.helpTestSafeSumAndMean(this.d4);
    }

    public void testJensenShannon() {
        double[] a = new double[]{0.1, 0.1, 0.7, 0.1, 0.0, 0.0};
        double[] b = new double[]{0.0, 0.1, 0.1, 0.7, 0.1, 0.0};
        ArrayMathTest.assertEquals((double)0.46514844544032313, (double)ArrayMath.jensenShannonDivergence(a, b), (double)1.0E-5);
        double[] c = new double[]{1.0, 0.0, 0.0};
        double[] d = new double[]{0.0, 0.5, 0.5};
        ArrayMathTest.assertEquals((double)1.0, (double)ArrayMath.jensenShannonDivergence(c, d), (double)1.0E-5);
    }
}

