/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OpenIE;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class OpenIEDemo {
    private OpenIEDemo() {
    }

    public static void main(String[] args) throws Exception {
        Properties props = PropertiesUtils.asProperties("annotators", "tokenize,ssplit,pos,lemma,depparse,natlog,openie");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String text = args.length > 0 ? IOUtils.slurpFile(args[0]) : "Obama was born in Hawaii. He is our president.";
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        int sentNo = 0;
        for (CoreMap sentence : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            System.out.println("Sentence #" + ++sentNo + ": " + (String)sentence.get(CoreAnnotations.TextAnnotation.class));
            System.out.println(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class)).toString(SemanticGraph.OutputFormat.LIST));
            Collection triples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
            for (RelationTriple triple : triples) {
                System.out.println(triple.confidence + "\t" + triple.subjectLemmaGloss() + "\t" + triple.relationLemmaGloss() + "\t" + triple.objectLemmaGloss());
            }
            List<SentenceFragment> clauses = new OpenIE(props).clausesInSentence(sentence);
            for (SentenceFragment clause : clauses) {
                System.out.println(clause.parseTree.toString(SemanticGraph.OutputFormat.LIST));
            }
            System.out.println();
        }
    }
}

