/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class PolarityITest {
    private static final StanfordCoreNLP pipeline = new StanfordCoreNLP(new Properties(){
        {
            this.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,natlog");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
            this.setProperty("enforceRequirements", "false");
            this.setProperty("natlog.neQuantifiers", "true");
        }
    });

    private Polarity[] annotate(String text) {
        Annotation ann = new Annotation(text);
        pipeline.annotate(ann);
        List tokens = (List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph tree = (SemanticGraph)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        Polarity[] polarities = new Polarity[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            polarities[i] = (Polarity)((CoreLabel)tokens.get(i)).get(NaturalLogicAnnotations.PolarityAnnotation.class);
        }
        return polarities;
    }

    @Test
    public void allCatsHaveTails() {
        Polarity[] p = this.annotate("all cats have tails");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isDownwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isUpwards());
    }

    @Test
    public void thereIsNoDoubtThatCatsHaveTails() {
        Polarity[] p = this.annotate("There is no doubt that cats have tails.");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isUpwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isDownwards());
        Assert.assertTrue((boolean)p[4].isUpwards());
        Assert.assertTrue((boolean)p[5].isUpwards());
    }

    @Test
    public void someCatsDontHaveTails() {
        Polarity[] p = this.annotate("some cats don't have tails");
        Assert.assertTrue((boolean)p[0].isUpwards());
        Assert.assertTrue((boolean)p[1].isUpwards());
        Assert.assertTrue((boolean)p[2].isUpwards());
        Assert.assertTrue((boolean)p[3].isUpwards());
        Assert.assertTrue((boolean)p[4].isDownwards());
        Assert.assertTrue((boolean)p[5].isDownwards());
    }

    @Test
    public void complexProperNouns() {
        Polarity[] p = this.annotate("Kip , his brothers , and Fletcher also played the Denver area bar scene while calling themselves Colorado .");
        Assert.assertTrue((boolean)p[0].isDownwards());
        for (int i = 1; i < p.length; ++i) {
            Assert.assertTrue((boolean)p[i].isUpwards());
        }
    }
}

