/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.TokenSequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QuestionToStatementTranslator {
    private final CoreLabel WORD_MISSING = new CoreLabel(){
        {
            this.setWord("thing");
            this.setValue("thing");
            this.setLemma("thing");
            this.setTag("NN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_LOCATION = new CoreLabel(){
        {
            this.setWord("location");
            this.setValue("location");
            this.setLemma("location");
            this.setTag("NNP");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_PERSON = new CoreLabel(){
        {
            this.setWord("person");
            this.setValue("person");
            this.setLemma("person");
            this.setTag("NNP");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_MISSING_TIME = new CoreLabel(){
        {
            this.setWord("time");
            this.setValue("time");
            this.setLemma("time");
            this.setTag("NN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
            this.set(UnknownTokenMarker.class, true);
        }
    };
    private final CoreLabel WORD_COMMA = new CoreLabel(){
        {
            this.setWord(",");
            this.setValue(",");
            this.setLemma(",");
            this.setTag(",");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
        }
    };
    private final CoreLabel WORD_FROM = new CoreLabel(){
        {
            this.setWord("from");
            this.setValue("from");
            this.setLemma("from");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
        }
    };
    private final CoreLabel WORD_AT = new CoreLabel(){
        {
            this.setWord("at");
            this.setValue("at");
            this.setLemma("at");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
        }
    };
    private final CoreLabel WORD_IN = new CoreLabel(){
        {
            this.setWord("in");
            this.setValue("in");
            this.setLemma("in");
            this.setTag("IN");
            this.setNER("O");
            this.setIndex(-1);
            this.setBeginPosition(-1);
            this.setEndPosition(-1);
        }
    };
    private final Set<String> fromNotAtDict = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("funding");
            this.add("oil");
        }
    });
    private final TokenSequencePattern triggerWhatIs = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+)? (?$be [{lemma:be}] )(?: /the/ (?$answer_type [word:/name/]) [tag:/[PW].*/])? (?$statement_body []+?) (?$prep_num [!{tag:IN}] [tag:CD] )? (?$suffix [tag:/[RI].*/] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNIs = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [!{lemma:be}]+) (?$be [{lemma:be}] [{tag:/[VRIJ].*/}] ) (?$statement_body []+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNHave = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [!{tag:/V.*/}]+) (?$have [{lemma:have} | {lemma:do}] ) (?$pre_verb [!{tag:/V.*/}]+ ) (?$verb [{tag:/V.*/}] [{tag:IN}]? ) (?$post_verb []+ )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhNNHaveNN = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+) (?$have [{lemma:have}] ) (?$statement_body [!{tag:/V.*/}]+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatIsThere = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$answer_type [tag:/N.*/]+)? (?$be [{lemma:be}] )(?$there [{lemma:there; tag:RB}] ) (?$adjmod [{tag:/[JN].*/}] )? (?$to_verb [{tag:TO}] [{tag:/V.*/}] )? (?$statement_body [{tag:IN}] []+?) (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhereDo = TokenSequencePattern.compile("[{lemma:where; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$statement_body []+?) (?$at [tag:/[IT].*/] )? (?$loc [tag:/N.*/] )*? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhereIs = TokenSequencePattern.compile("[{lemma:where; tag:/W.*/}] (?$be [ {lemma:/be/} ]) (?$initial_verb [tag:/[VJ].*/] )? (?$statement_body []+?) (?$ignored [lemma:locate] [tag:IN] [word:a]? [word:map]? )? (?$final_verb [tag:/[VJ].*/] )? (?$at [tag:IN] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhoIs = TokenSequencePattern.compile("[{lemma:who; tag:/W.*/}] (?$be [ {lemma:/be/} ] ) (?$prep [ {tag:/IN|V.*/} ] )? (?$statement_body []+?) (?$final_verb [tag:/V.*/] [tag:/[IRT].*/] )? (?$final_verb [tag:VBG] )? (?$now [tag:RB] )? (?$prep_num [!{tag:IN}] [tag:CD] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhoDid = TokenSequencePattern.compile("[{lemma:who; tag:/W.*/}] (?$do [ {lemma:/do/} ] ) (?$statement_body []+?) (?$now [tag:RB] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatDo = TokenSequencePattern.compile("[{lemma:/what|which/; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$pre_do [ !{lemma:do} & !{tag:IN} ]+) (?$mid_do [ {lemma:do} ] )? (?$in [ {tag:IN} ] )? (?$post_do []+ )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhenDo = TokenSequencePattern.compile("[{lemma:when; tag:/W.*/}] (?$do [ {lemma:/do/} ]) (?$statement_body []+?) (?$in [tag:/[IT].*/] )? (?$punct [word:/[?\\.!]/])");
    private final TokenSequencePattern triggerWhatHave = TokenSequencePattern.compile("[{lemma:what; tag:/W.*/}] (?$have [ {lemma:/have/} ]) (?$pre_verb [!{tag:/V.*/}]+ )? (?$verb [tag:/V.*/] [tag:IN]? ) (?$post_verb []+ )? (?$punct [word:/[?\\.!]/])");

    private List<CoreLabel> processWhatIs(TokenSequenceMatcher matcher) {
        int i;
        List prepNum;
        List<CoreLabel> body = matcher.groupNodes("$statement_body");
        List be = matcher.groupNodes("$be");
        List suffix = matcher.groupNodes("$suffix");
        boolean addedBe = false;
        boolean addedSuffix = false;
        for (int i2 = 1; i2 < body.size(); ++i2) {
            CoreLabel tokI = (CoreLabel)body.get(i2);
            if (tokI.tag() == null || !(tokI.tag().startsWith("V") || tokI.tag().startsWith("J") && suffix != null || tokI.tag().startsWith("D") && suffix != null) && (!tokI.tag().startsWith("R") || suffix == null)) continue;
            body.add(i2, (CoreLabel)be.get(0));
            ++i2;
            if (suffix != null) {
                while (i2 < body.size() && ((CoreLabel)body.get(i2)).tag() != null && (((CoreLabel)body.get(i2)).tag().startsWith("J") || body.get(i2).tag().startsWith("V") || body.get(i2).tag().startsWith("R") || body.get(i2).tag().startsWith("N") || body.get(i2).tag().startsWith("D")) && !body.get(i2).tag().equals("VBG")) {
                    ++i2;
                }
                body.add(i2, (CoreLabel)suffix.get(0));
                addedSuffix = true;
            }
            addedBe = true;
            break;
        }
        if ((prepNum = matcher.groupNodes("$prep_num")) != null) {
            body.add((CoreLabel)prepNum.get(0));
            body.add(this.WORD_IN);
            body.add((CoreLabel)prepNum.get(1));
        }
        if (!addedBe) {
            body.addAll(be);
        }
        if (!addedSuffix && suffix != null) {
            body.addAll(suffix);
        }
        List objType = matcher.groupNodes("$answer_type");
        for (i = body.size() - 1; i >= 1 && ((CoreLabel)body.get(i)).tag() != null && (((CoreLabel)body.get(i)).tag().startsWith("N") || body.get(i).tag().startsWith("J")); --i) {
        }
        if (objType == null || objType.isEmpty() || objType.size() == 1 && ((CoreLabel)objType.get(0)).word().equals("name")) {
            if (i < body.size() - 1 && ((CoreLabel)body.get(i)).tag() != null && body.get(i).tag().startsWith("IN")) {
                body.add(i, this.WORD_MISSING);
            } else {
                body.add(this.WORD_MISSING);
            }
        } else {
            for (CoreLabel obj : objType) {
                obj.set(UnknownTokenMarker.class, true);
            }
            body.addAll(objType);
        }
        return body;
    }

    private List<CoreLabel> processWhNNIs(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$answer_type");
        for (CoreLabel lbl : sentence) {
            lbl.set(UnknownTokenMarker.class, true);
        }
        sentence.addAll(matcher.groupNodes("$be"));
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhNNHave(TokenSequenceMatcher matcher) {
        List answer;
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        sentence.addAll(matcher.groupNodes("$pre_verb"));
        List have = matcher.groupNodes("$have");
        if (have != null && have.size() > 0 && ((CoreLabel)have.get(0)).lemma() != null && ((CoreLabel)have.get(0)).lemma().equals("have")) {
            sentence.addAll(matcher.groupNodes("$have"));
        }
        if ((answer = matcher.groupNodes("$answer_type")) != null) {
            for (CoreLabel lbl : answer) {
                lbl.set(UnknownTokenMarker.class, true);
            }
        }
        List verb = matcher.groupNodes("$verb");
        List post = matcher.groupNodes("$post_verb");
        if (verb.size() < 2 || post == null || post.size() == 0 || ((CoreLabel)post.get(0)).tag() == null || ((CoreLabel)post.get(0)).tag().equals("CD")) {
            sentence.addAll(verb);
            if (answer == null) {
                sentence.add(this.WORD_MISSING);
            } else {
                sentence.addAll(answer);
            }
        } else {
            sentence.add((CoreLabel)verb.get(0));
            if (answer == null) {
                sentence.add(this.WORD_MISSING);
            } else {
                sentence.addAll(answer);
            }
            sentence.addAll(verb.subList(1, verb.size()));
        }
        if (post != null) {
            if (post.size() == 1 && ((CoreLabel)post.get(0)).tag() != null && ((CoreLabel)post.get(0)).tag().equals("CD")) {
                sentence.add(this.WORD_IN);
            }
            sentence.addAll(post);
        }
        return sentence;
    }

    private List<CoreLabel> processWhNNHaveNN(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$answer_type");
        for (CoreLabel lbl : sentence) {
            lbl.set(UnknownTokenMarker.class, true);
        }
        sentence.addAll(matcher.groupNodes("$have"));
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhatIsThere(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$there");
        sentence.addAll(matcher.groupNodes("$be"));
        List optSpan = matcher.groupNodes("$adjmod");
        if (optSpan != null) {
            sentence.addAll(optSpan);
        }
        sentence.add(this.WORD_MISSING);
        optSpan = matcher.groupNodes("$to_verb");
        if (optSpan != null) {
            sentence.addAll(optSpan);
        }
        sentence.addAll(matcher.groupNodes("$statement_body"));
        return sentence;
    }

    private List<CoreLabel> processWhereDo(TokenSequenceMatcher matcher) {
        List specloc = matcher.groupNodes("$loc");
        CoreLabel wordAt = this.WORD_AT;
        CoreLabel missing = this.WORD_MISSING_LOCATION;
        if (specloc != null && this.fromNotAtDict.contains(((CoreLabel)specloc.get(0)).word())) {
            wordAt = this.WORD_FROM;
            missing = this.WORD_MISSING;
        }
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        for (CoreLabel lbl : sentence) {
            if (!"name".equals(lbl.word())) continue;
            missing = this.WORD_MISSING;
        }
        List at = matcher.groupNodes("$at");
        if (at != null && at.size() > 0) {
            sentence.addAll(at);
        } else {
            if (specloc != null) {
                sentence.addAll(specloc);
            }
            sentence.add(wordAt);
        }
        sentence.add(missing);
        if (specloc != null && at != null) {
            sentence.add(this.WORD_COMMA);
            sentence.addAll(specloc);
        }
        return sentence;
    }

    private List<CoreLabel> processWhereIs(TokenSequenceMatcher matcher) {
        List at;
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        List be = matcher.groupNodes("$be");
        sentence.addAll(be);
        List verb = matcher.groupNodes("$final_verb");
        if (verb != null) {
            sentence.addAll(verb);
        }
        if ((verb = matcher.groupNodes("$initial_verb")) != null) {
            sentence.addAll(verb);
        }
        if ((at = matcher.groupNodes("$at")) != null && at.size() > 0) {
            sentence.addAll(at);
        } else {
            sentence.add(this.WORD_AT);
        }
        sentence.add(this.WORD_MISSING_LOCATION);
        return sentence;
    }

    private List<CoreLabel> processWhoIs(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List prep = matcher.groupNodes("$prep");
        boolean addedBe = false;
        if (prep != null && !prep.isEmpty()) {
            sentence.add(this.WORD_MISSING_PERSON);
            List be = matcher.groupNodes("$be");
            sentence.addAll(be);
            addedBe = true;
            sentence.addAll(prep);
            sentence.addAll(matcher.groupNodes("$statement_body"));
        } else {
            List verb;
            sentence.addAll(matcher.groupNodes("$statement_body"));
            List prepNum = matcher.groupNodes("$prep_num");
            if (prepNum != null) {
                sentence.add((CoreLabel)prepNum.get(0));
                sentence.add(this.WORD_IN);
                sentence.add((CoreLabel)prepNum.get(1));
            }
            List be = matcher.groupNodes("$be");
            if (sentence.size() > 1 && !((CoreLabel)sentence.get(sentence.size() - 1)).word().equals("be")) {
                sentence.addAll(be);
                addedBe = true;
            }
            if ((verb = matcher.groupNodes("$final_verb")) != null) {
                if (verb.size() > 1 && ((CoreLabel)verb.get(verb.size() - 1)).word().equals("too")) {
                    ((CoreLabel)verb.get(verb.size() - 1)).setWord("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setValue("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setLemma("to");
                    ((CoreLabel)verb.get(verb.size() - 1)).setTag("IN");
                }
                sentence.addAll(verb);
            }
            sentence.add(this.WORD_MISSING_PERSON);
        }
        List now = matcher.groupNodes("$now");
        if (now != null) {
            sentence.addAll(now);
        }
        if (!addedBe) {
            for (int i = 0; i < sentence.size(); ++i) {
                if (((CoreLabel)sentence.get(i)).tag() == null || !((CoreLabel)sentence.get(i)).tag().startsWith("V")) continue;
                sentence.add(i, (CoreLabel)matcher.groupNodes("$be").get(0));
                break;
            }
        }
        return sentence;
    }

    private List<CoreLabel> processWhoDid(TokenSequenceMatcher matcher) {
        List now;
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        boolean hasVerb = false;
        for (CoreLabel w : sentence) {
            if (w.tag() == null || !w.tag().startsWith("V")) continue;
            hasVerb = true;
        }
        if (!hasVerb) {
            sentence.add(0, this.WORD_MISSING_PERSON);
            sentence.add(1, (CoreLabel)matcher.groupNodes("$do").get(0));
            return sentence;
        }
        boolean addedPerson = false;
        if (sentence.size() > 0 && ((CoreLabel)sentence.get(sentence.size() - 1)).tag() != null && !sentence.get(sentence.size() - 1).tag().startsWith("I")) {
            for (int i = 0; i < sentence.size() - 1; ++i) {
                if (sentence.get(i).tag() == null || !sentence.get(i).tag().equals("IN") && !sentence.get(i).word().equals("last") && !sentence.get(i).word().equals("next") && !sentence.get(i).word().equals("this")) continue;
                sentence.add(i, this.WORD_MISSING_PERSON);
                addedPerson = true;
                break;
            }
        }
        if (!addedPerson) {
            sentence.add(this.WORD_MISSING_PERSON);
        }
        if ((now = matcher.groupNodes("$now")) != null) {
            sentence.addAll(now);
        }
        return sentence;
    }

    private List<CoreLabel> processWhatDo(TokenSequenceMatcher matcher) {
        List postDo;
        List midIN;
        List<CoreLabel> sentence = matcher.groupNodes("$pre_do");
        List midDo = matcher.groupNodes("$mid_do");
        if (midDo != null) {
            sentence.addAll(matcher.groupNodes("$do"));
        }
        if (matcher.groupNodes("$post_do") != null) {
            sentence.add(this.WORD_MISSING);
        }
        if ((midIN = matcher.groupNodes("$in")) != null) {
            sentence.addAll(midIN);
        }
        if (matcher.groupNodes("$post_do") == null) {
            if (sentence.size() > 1 && "off".equals(((CoreLabel)sentence.get(sentence.size() - 1)).word())) {
                sentence.get(sentence.size() - 1).setWord("of");
                sentence.get(sentence.size() - 1).setValue("of");
                sentence.get(sentence.size() - 1).setLemma("of");
                sentence.get(sentence.size() - 1).setTag("IN");
            }
            sentence.add(this.WORD_MISSING);
        }
        if ((postDo = matcher.groupNodes("$post_do")) != null) {
            sentence.addAll(postDo);
        }
        if (sentence.size() > 2 && !"IN".equals(sentence.get(sentence.size() - 2).tag()) && "CD".equals(sentence.get(sentence.size() - 1).tag())) {
            sentence.add(sentence.size() - 1, this.WORD_IN);
        }
        return sentence;
    }

    private List<CoreLabel> processWhenDo(TokenSequenceMatcher matcher) {
        List<CoreLabel> sentence = matcher.groupNodes("$statement_body");
        List in = matcher.groupNodes("$in");
        if (in != null && in.size() > 0) {
            sentence.addAll(in);
        } else {
            sentence.add(this.WORD_IN);
        }
        sentence.add(this.WORD_MISSING_TIME);
        return sentence;
    }

    private List<CoreLabel> processWhatHave(TokenSequenceMatcher matcher) {
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        List preVerb = matcher.groupNodes("$pre_verb");
        if (preVerb != null) {
            sentence.addAll(preVerb);
        }
        if (sentence.size() == 0) {
            sentence.add(this.WORD_MISSING);
            sentence.addAll(matcher.groupNodes("$have"));
            sentence.addAll(matcher.groupNodes("$verb"));
        } else {
            sentence.addAll(matcher.groupNodes("$have"));
            sentence.addAll(matcher.groupNodes("$verb"));
            sentence.add(this.WORD_MISSING);
        }
        List postVerb = matcher.groupNodes("$post_verb");
        if (postVerb != null) {
            sentence.addAll(postVerb);
        }
        return sentence;
    }

    public List<List<CoreLabel>> toStatement(List<CoreLabel> question) {
        TokenSequenceMatcher matcher = this.triggerWhatIsThere.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhatIsThere(matcher));
        }
        matcher = this.triggerWhNNIs.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhNNIs(matcher));
        }
        matcher = this.triggerWhNNHave.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhNNHave(matcher));
        }
        matcher = this.triggerWhNNHaveNN.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhNNHaveNN(matcher));
        }
        matcher = this.triggerWhatIs.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhatIs(matcher));
        }
        matcher = this.triggerWhatHave.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhatHave(matcher));
        }
        matcher = this.triggerWhereDo.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhereDo(matcher));
        }
        matcher = this.triggerWhereIs.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhereIs(matcher));
        }
        matcher = this.triggerWhoIs.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhoIs(matcher));
        }
        matcher = this.triggerWhoDid.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhoDid(matcher));
        }
        matcher = this.triggerWhatDo.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhatDo(matcher));
        }
        matcher = this.triggerWhenDo.matcher(question);
        if (matcher.matches()) {
            return Collections.singletonList(this.processWhenDo(matcher));
        }
        return Collections.emptyList();
    }

    public static class UnknownTokenMarker
    implements CoreAnnotation<Boolean> {
        @Override
        public Class<Boolean> getType() {
            return Boolean.class;
        }
    }
}

