/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli.demo;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OpenIEServlet
extends HttpServlet {
    private static Redwood.RedwoodChannels log = Redwood.channels(OpenIEServlet.class);
    StanfordCoreNLP pipeline = null;
    StanfordCoreNLP backoff = null;

    public void init() throws ServletException {
        Properties commonProps = new Properties(){
            {
                this.setProperty("depparse.extradependencies", "ref_only_uncollapsed");
                this.setProperty("parse.extradependencies", "ref_only_uncollapsed");
                this.setProperty("openie.splitter.threshold", "0.10");
                this.setProperty("openie.optimze_for", "GENERAL");
                this.setProperty("openie.ignoreaffinity", "false");
                this.setProperty("openie.max_entailments_per_clause", "1000");
                this.setProperty("openie.triple.strict", "true");
            }
        };
        try {
            String dataDir = this.getServletContext().getRealPath("/WEB-INF/data");
            System.setProperty("de.jollyday.config", this.getServletContext().getRealPath("/WEB-INF/classes/holidays/jollyday.properties"));
            commonProps.setProperty("pos.model", dataDir + "/english-left3words-distsim.tagger");
            commonProps.setProperty("ner.model", dataDir + "/english.all.3class.distsim.crf.ser.gz," + dataDir + "/english.conll.4class.distsim.crf.ser.gz," + dataDir + "/english.muc.7class.distsim.crf.ser.gz");
            commonProps.setProperty("depparse.model", dataDir + "/english_SD.gz");
            commonProps.setProperty("parse.model", dataDir + "/englishPCFG.ser.gz");
            commonProps.setProperty("sutime.rules", dataDir + "/defs.sutime.txt," + dataDir + "/english.sutime.txt," + dataDir + "/english.hollidays.sutime.txt");
            commonProps.setProperty("openie.splitter.model", dataDir + "/clauseSplitterModel.ser.gz");
            commonProps.setProperty("openie.affinity_models", dataDir);
        }
        catch (NullPointerException e) {
            log.info("Could not load servlet context. Are you on the command line?");
        }
        if (this.pipeline == null) {
            Properties fullProps = new Properties(commonProps);
            fullProps.setProperty("annotators", "tokenize,ssplit,pos,lemma,depparse,ner,natlog,openie");
            this.pipeline = new StanfordCoreNLP(fullProps);
        }
        if (this.backoff == null) {
            Properties backoffProps = new Properties(commonProps);
            backoffProps.setProperty("annotators", "parse,natlog,openie");
            backoffProps.setProperty("enforceRequirements", "false");
            this.backoff = new StanfordCoreNLP(backoffProps);
        }
    }

    public void annotate(StanfordCoreNLP pipeline, Annotation ann) {
        if (ann.get(CoreAnnotations.SentencesAnnotation.class) == null) {
            pipeline.annotate(ann);
        } else if (((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).size() == 1) {
            CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                token.remove(NaturalLogicAnnotations.OperatorAnnotation.class);
                token.remove(NaturalLogicAnnotations.PolarityAnnotation.class);
            }
            sentence.remove(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
            sentence.remove(NaturalLogicAnnotations.EntailedSentencesAnnotation.class);
            sentence.remove(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            sentence.remove(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
            sentence.remove(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
            pipeline.annotate(ann);
        }
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private void runWithPipeline(StanfordCoreNLP pipeline, Annotation ann, Set<String> triples, Set<String> entailments) {
        this.annotate(pipeline, ann);
        for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (Object fragment : (Collection)sentence.get(NaturalLogicAnnotations.EntailedSentencesAnnotation.class)) {
                entailments.add(OpenIEServlet.quote(((SentenceFragment)fragment).toString()));
            }
            for (Object fragment : (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) {
                triples.add("[ " + OpenIEServlet.quote(((RelationTriple)fragment).subjectGloss()) + ", " + OpenIEServlet.quote(((RelationTriple)fragment).relationGloss()) + ", " + OpenIEServlet.quote(((RelationTriple)fragment).objectGloss()) + " ]");
            }
        }
    }

    private void doGet(PrintWriter out2, String q) {
        if ((q = q.trim()).length() == 0) {
            return;
        }
        char lastChar = q.charAt(q.length() - 1);
        if (lastChar != '.' && lastChar != '!' && lastChar != '?') {
            q = q + ".";
        }
        Annotation ann = new Annotation(q);
        try {
            HashSet<String> entailments = new HashSet<String>();
            LinkedHashSet<String> triples = new LinkedHashSet<String>();
            this.runWithPipeline(this.pipeline, ann, triples, entailments);
            if (triples.size() == 0) {
                this.runWithPipeline(this.backoff, ann, triples, entailments);
            }
            out2.println("{ \"ok\":true, \"entailments\": [" + StringUtils.join(entailments, ",") + "], " + "\"triples\": [" + StringUtils.join(triples, ",") + "], " + "\"msg\": \"\"" + " }");
        }
        catch (Throwable t) {
            out2.println("{ok:false, entailments:[], triples:[], msg:" + OpenIEServlet.quote(t.getMessage()) + "}");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("utf-8");
        }
        response.setContentType("text/json; charset=UTF-8");
        PrintWriter out2 = response.getWriter();
        String raw = request.getParameter("q");
        if (raw == null || "".equals(raw)) {
            out2.println("{ok:false, entailments:[], triples=[], msg=\"\"}");
        } else {
            this.doGet(out2, raw);
        }
        out2.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public static void main(String[] args) throws ServletException, IOException {
        OpenIEServlet servlet = new OpenIEServlet();
        servlet.init();
        IOUtils.console(line -> {
            StringWriter str = new StringWriter();
            PrintWriter out2 = new PrintWriter(str);
            servlet.doGet(new PrintWriter(out2), (String)line);
            out2.close();
            System.out.println(str.toString());
        });
    }
}

