/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.LineIterator;
import java.io.StringReader;
import junit.framework.TestCase;

public class LineIteratorTest
extends TestCase {
    public void testLineIterator() {
        String s = "\n\n@@123\nthis\nis\na\nsentence\n\n@@124\nThis\nis another\n.\n\n@125\nThis is the\tlast\n";
        String[] output = new String[]{"", "", "@@123", "this", "is", "a", "sentence", "", "@@124", "This", "is another", ".", "", "@125", "This is the\tlast"};
        LineIterator di = new LineIterator(new StringReader(s), new IdentityFunction());
        try {
            for (String out2 : output) {
                String ans = (String)di.next();
                LineIteratorTest.assertEquals((String)"Wrong line", (String)out2, (String)ans);
            }
            if (di.hasNext()) {
                LineIteratorTest.fail((String)("Too many things in iterator: " + (String)di.next()));
            }
        }
        catch (Exception e) {
            LineIteratorTest.fail((String)("Probably too few things in iterator: " + e));
        }
    }
}

