/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.XMLBeginEndIterator;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;

public class XMLBeginEndIteratorTest
extends TestCase {
    public static final String TEST_STRING = "<xml><tagger>\n  <text>\n    This tests the xml input.\n  </text>  \n  This should not be found.  \n  <text>\n    This should be found.\n  </text>\n  <text>\n    The dog's barking kept the\n neighbors up all night.\n  </text>\n</tagging></xml>";
    public static final String EMPTY_TEST_STRING = "<text></text>";
    public static final String SINGLE_TAG_TEST_STRING = "<xml><text>This tests the xml input with single tags<text/>, which should not close the input</text><text/>and should not open it either.</xml>";
    public static final String NESTING_TEST_STRING = "<xml><text>A<text>B</text>C</text>D <text>A<text>B</text>C<text>D</text>E</text>F <text>A<text>B</text>C<text>D<text/></text>E</text>F</xml>";
    public static final String TAG_IN_TEXT_STRING = "<xml><bar>The dog's barking kept the neighbors up all night</bar></xml>";
    public static final String TWO_TAGS_STRING = "<xml><foo>This is the first sentence</foo><bar>The dog's barking kept the neighbors up all night</bar><foo>The owner could not stop the dog from barking</foo></xml>";

    public static ArrayList<String> getResults(XMLBeginEndIterator<String> iterator) {
        ArrayList<String> results = new ArrayList<String>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }

    public static void compareResults(XMLBeginEndIterator<String> iterator, String ... expectedResults) {
        ArrayList<String> results = XMLBeginEndIteratorTest.getResults(iterator);
        XMLBeginEndIteratorTest.assertEquals((int)expectedResults.length, (int)results.size());
        for (int i = 0; i < expectedResults.length; ++i) {
            XMLBeginEndIteratorTest.assertEquals((String)expectedResults[i], (String)results.get(i));
        }
    }

    public void testNotFound() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(TEST_STRING)), "zzzz");
        XMLBeginEndIteratorTest.compareResults(iterator, new String[0]);
    }

    public void testFound() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(TEST_STRING)), "text");
        XMLBeginEndIteratorTest.compareResults(iterator, "\n    This tests the xml input.\n  ", "\n    This should be found.\n  ", "\n    The dog's barking kept the\n neighbors up all night.\n  ");
    }

    public void testEmpty() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(EMPTY_TEST_STRING)), "text");
        XMLBeginEndIteratorTest.compareResults(iterator, "");
    }

    public void testSingleTags() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(SINGLE_TAG_TEST_STRING)), "text");
        XMLBeginEndIteratorTest.compareResults(iterator, "This tests the xml input with single tags, which should not close the input");
    }

    public void testNesting() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>((Reader)new BufferedReader(new StringReader(NESTING_TEST_STRING)), "text", false, false, true);
        XMLBeginEndIteratorTest.compareResults(iterator, "ABC", "ABCDE", "ABCDE");
    }

    public void testInternalTags() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>((Reader)new BufferedReader(new StringReader(NESTING_TEST_STRING)), "text", true, false, true);
        XMLBeginEndIteratorTest.compareResults(iterator, "A<text>B</text>C", "A<text>B</text>C<text>D</text>E", "A<text>B</text>C<text>D<text/></text>E");
    }

    public void testContainingTags() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>((Reader)new BufferedReader(new StringReader(NESTING_TEST_STRING)), "text", true, true, true);
        XMLBeginEndIteratorTest.compareResults(iterator, "<text>A<text>B</text>C</text>", "<text>A<text>B</text>C<text>D</text>E</text>", "<text>A<text>B</text>C<text>D<text/></text>E</text>");
    }

    public void testTagInText() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(TAG_IN_TEXT_STRING)), "bar");
        XMLBeginEndIteratorTest.compareResults(iterator, "The dog's barking kept the neighbors up all night");
    }

    public void testTwoTags() {
        XMLBeginEndIterator<String> iterator = new XMLBeginEndIterator<String>(new BufferedReader(new StringReader(TWO_TAGS_STRING)), "foo|bar");
        XMLBeginEndIteratorTest.compareResults(iterator, "This is the first sentence", "The dog's barking kept the neighbors up all night", "The owner could not stop the dog from barking");
    }
}

