/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.SparseMinimizer;
import edu.stanford.nlp.optimization.SparseOnlineFunction;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;

public class SparseAdaGradMinimizer<K, F extends SparseOnlineFunction<K>>
implements SparseMinimizer<K, F> {
    private static Redwood.RedwoodChannels log = Redwood.channels(SparseAdaGradMinimizer.class);
    public boolean quiet = false;
    protected int numPasses;
    protected int batchSize;
    protected double eta;
    protected double lambdaL1;
    protected double lambdaL2;
    protected Counter<K> sumGradSquare;
    protected Counter<K> x;
    protected Random randGenerator = new Random(1L);
    public final double EPS = 1.0E-15;
    public final double soften = 1.0E-4;
    private static final NumberFormat nf = new DecimalFormat("0.000E0");

    public SparseAdaGradMinimizer(int numPasses) {
        this(numPasses, 0.1);
    }

    public SparseAdaGradMinimizer(int numPasses, double eta) {
        this(numPasses, eta, 1, 0.0, 0.0);
    }

    public SparseAdaGradMinimizer(int numPasses, double eta, int batchSize, double lambdaL1, double lambdaL2) {
        this.numPasses = numPasses;
        this.eta = eta;
        this.batchSize = batchSize;
        this.lambdaL1 = lambdaL1;
        this.lambdaL2 = lambdaL2;
        this.sumGradSquare = new ClassicCounter<K>();
    }

    @Override
    public Counter<K> minimize(F function, Counter<K> initial) {
        return this.minimize(function, initial, -1);
    }

    @Override
    public Counter<K> minimize(F function, Counter<K> x, int maxIterations) {
        this.sayln("       Batch size of: " + this.batchSize);
        this.sayln("       Data dimension of: " + function.dataSize());
        int numBatches = (function.dataSize() - 1) / this.batchSize + 1;
        this.sayln("       Batches per pass through data:  " + numBatches);
        this.sayln("       Number of passes is = " + this.numPasses);
        this.sayln("       Max iterations is = " + maxIterations);
        ClassicCounter<K> lastUpdated = new ClassicCounter<K>();
        int timeStep = 0;
        Timing total = new Timing();
        total.start();
        for (int iter = 0; iter < this.numPasses; ++iter) {
            double totalObjValue = 0.0;
            block1: for (int j = 0; j < numBatches; ++j) {
                int[] selectedData = this.getSample(function, this.batchSize);
                Counter<K> gradient = function.derivativeAt(x, selectedData);
                totalObjValue += function.valueAt(x, selectedData);
                for (K feature : gradient.keySet()) {
                    double gradf = gradient.getCount(feature);
                    double prevrate = this.eta / (Math.sqrt(this.sumGradSquare.getCount(feature)) + 1.0E-4);
                    double sgsValue = this.sumGradSquare.incrementCount(feature, gradf * gradf);
                    double currentrate = this.eta / (Math.sqrt(sgsValue) + 1.0E-4);
                    double testupdate = x.getCount(feature) - currentrate * gradient.getCount(feature);
                    double lastUpdateTimeStep = lastUpdated.getCount(feature);
                    double idleinterval = (double)timeStep - lastUpdateTimeStep - 1.0;
                    lastUpdated.setCount(feature, timeStep);
                    double trunc = Math.max(0.0, Math.abs(testupdate) - (currentrate + prevrate * idleinterval) * this.lambdaL1);
                    double trunc2 = trunc * Math.pow(1.0 - this.lambdaL2, currentrate + prevrate * idleinterval);
                    double realupdate = Math.signum(testupdate) * trunc2;
                    if (realupdate < 1.0E-15) {
                        x.remove(feature);
                    } else {
                        x.setCount(feature, realupdate);
                    }
                    if (++timeStep > maxIterations) {
                        this.sayln("Stochastic Optimization complete.  Stopped after max iterations");
                        continue block1;
                    }
                    this.sayln(System.out.format("Iter %d \t batch: %d \t time=%.2f \t obj=%.4f", iter, timeStep, (double)total.report() / 1000.0, totalObjValue).toString());
                }
            }
        }
        return x;
    }

    private int[] getSample(F function, int sampleSize) {
        int[] sample = new int[sampleSize];
        for (int i = 0; i < sampleSize; ++i) {
            sample[i] = this.randGenerator.nextInt(function.dataSize());
        }
        return sample;
    }

    protected String getName() {
        return "SparseAdaGrad_batchsize" + this.batchSize + "_eta" + nf.format(this.eta) + "_lambdaL1" + nf.format(this.lambdaL1) + "_lambdaL2" + nf.format(this.lambdaL2);
    }

    protected void sayln(String s) {
        if (!this.quiet) {
            log.info(s);
        }
    }
}

