/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Generics;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class DependencyIndexITest
extends TestCase {
    public void testPositions() {
        try {
            Tree tree = new PennTreeReader(new StringReader("(S (NP (NNP Mary)) (VP (VBD had) (NP (DT a) (JJ little) (NN lamb))) (. .))"), new LabeledScoredTreeFactory(new StringLabelFactory())).readTree();
            DependencyIndexITest.checkTree(tree);
            tree = Tree.valueOf("(S (NP (NNP Mary)) (VP (VBD had) (NP (DT a) (JJ little) (NN lamb))) (. .))");
            DependencyIndexITest.checkTree(tree);
            tree = new PennTreeReader(new StringReader("(S (NP (NNP Mary)) (VP (VBD had) (NP (DT a) (JJ little) (NN lamb))) (. .))"), new LabeledScoredTreeFactory(CoreLabel.factory())).readTree();
            DependencyIndexITest.checkTree(tree);
            LexicalizedParser parser = LexicalizedParser.loadModel();
            tree = parser.parse("Mary had a little lamb .");
            tree.indexLeaves();
            DependencyIndexITest.checkTree(tree);
        }
        catch (IOException e) {
            DependencyIndexITest.fail((String)"IOException shouldn't happen.");
        }
    }

    private static void checkTree(Tree tree) {
        List leaves = tree.getLeaves();
        for (Tree leaf : leaves) {
            CoreLabel l = null;
            if (leaf.label() instanceof CoreLabel) {
                l = (CoreLabel)leaf.label();
            }
            if (l == null) continue;
            int index = (Integer)l.get(CoreAnnotations.IndexAnnotation.class);
            String text = (String)l.get(CoreAnnotations.TextAnnotation.class);
            if (text.equals("Mary")) {
                DependencyIndexITest.assertEquals((int)1, (int)index);
                continue;
            }
            if (text.equals("had")) {
                DependencyIndexITest.assertEquals((int)2, (int)index);
                continue;
            }
            if (text.equals("a")) {
                DependencyIndexITest.assertEquals((int)3, (int)index);
                continue;
            }
            if (text.equals("little")) {
                DependencyIndexITest.assertEquals((int)4, (int)index);
                continue;
            }
            if (text.equals("lamb")) {
                DependencyIndexITest.assertEquals((int)5, (int)index);
                continue;
            }
            if (!text.equals(".")) continue;
            DependencyIndexITest.assertEquals((int)6, (int)index);
        }
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        GrammaticalStructureFactory gsf = tlp.grammaticalStructureFactory();
        GrammaticalStructure gs = gsf.newGrammaticalStructure(tree);
        List<TypedDependency> deps = gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL);
        Set<IndexedWord> nodes = Generics.newHashSet();
        for (TypedDependency dep : deps) {
            nodes.add(dep.gov());
            nodes.add(dep.dep());
        }
        for (IndexedWord n : nodes) {
            String text = n.value();
            int index = (Integer)n.get(CoreAnnotations.IndexAnnotation.class);
            if (text.equals("Mary")) {
                DependencyIndexITest.assertEquals((int)1, (int)index);
                continue;
            }
            if (text.equals("had")) {
                DependencyIndexITest.assertEquals((int)2, (int)index);
                continue;
            }
            if (text.equals("a")) {
                DependencyIndexITest.assertEquals((int)3, (int)index);
                continue;
            }
            if (text.equals("little")) {
                DependencyIndexITest.assertEquals((int)4, (int)index);
                continue;
            }
            if (text.equals("lamb")) {
                DependencyIndexITest.assertEquals((int)5, (int)index);
                continue;
            }
            if (!text.equals(".")) continue;
            DependencyIndexITest.assertEquals((int)6, (int)index);
        }
    }

    public static void main(String[] args) {
        DependencyIndexITest dt = new DependencyIndexITest();
        dt.testPositions();
    }
}

