/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.io.FileSystem;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.dvparser.DVParser;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.util.TwoDimensionalMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.ejml.simple.SimpleMatrix;

public class DumpMatrices {
    private static Redwood.RedwoodChannels log = Redwood.channels(DumpMatrices.class);

    public static void help() {
        log.info("-model : DVModel to load");
        log.info("-output : where to dump the matrices");
        System.exit(2);
    }

    public static void dumpMatrix(String filename, SimpleMatrix matrix) throws IOException {
        String matrixString = matrix.toString();
        int newLine = matrixString.indexOf("\n");
        if (newLine >= 0) {
            matrixString = matrixString.substring(newLine + 1);
        }
        FileWriter fout = new FileWriter(filename);
        BufferedWriter bout = new BufferedWriter(fout);
        bout.write(matrixString);
        bout.close();
        fout.close();
    }

    public static void main(String[] args) throws IOException {
        String modelPath = null;
        String outputDir = null;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-model")) {
                modelPath = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                outputDir = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            log.info("Unknown argument " + args[argIndex]);
            DumpMatrices.help();
        }
        if (outputDir == null || modelPath == null) {
            DumpMatrices.help();
        }
        File outputFile = new File(outputDir);
        FileSystem.checkNotExistsOrFail(outputFile);
        FileSystem.mkdirOrFail(outputFile);
        LexicalizedParser parser = LexicalizedParser.loadModel(modelPath, new String[0]);
        DVModel model = DVParser.getModelFromLexicalizedParser(parser);
        String binaryWDir = outputDir + File.separator + "binaryW";
        FileSystem.mkdirOrFail(binaryWDir);
        for (TwoDimensionalMap.Entry<String, String, SimpleMatrix> entry : model.binaryTransform) {
            String string = binaryWDir + File.separator + entry.getFirstKey() + "_" + entry.getSecondKey() + ".txt";
            DumpMatrices.dumpMatrix(string, entry.getValue());
        }
        String binaryScoreDir = outputDir + File.separator + "binaryScore";
        FileSystem.mkdirOrFail(binaryScoreDir);
        for (TwoDimensionalMap.Entry<String, String, SimpleMatrix> entry : model.binaryScore) {
            String string = binaryScoreDir + File.separator + entry.getFirstKey() + "_" + entry.getSecondKey() + ".txt";
            DumpMatrices.dumpMatrix(string, entry.getValue());
        }
        String string = outputDir + File.separator + "unaryW";
        FileSystem.mkdirOrFail(string);
        for (Map.Entry<String, SimpleMatrix> entry : model.unaryTransform.entrySet()) {
            String string2 = string + File.separator + entry.getKey() + ".txt";
            DumpMatrices.dumpMatrix(string2, entry.getValue());
        }
        String string3 = outputDir + File.separator + "unaryScore";
        FileSystem.mkdirOrFail(string3);
        for (Map.Entry<String, SimpleMatrix> entry : model.unaryScore.entrySet()) {
            String filename = string3 + File.separator + entry.getKey() + ".txt";
            DumpMatrices.dumpMatrix(filename, entry.getValue());
        }
        String string4 = outputDir + File.separator + "embeddings.txt";
        FileWriter fileWriter = new FileWriter(string4);
        BufferedWriter bout = new BufferedWriter(fileWriter);
        for (Map.Entry<String, SimpleMatrix> entry : model.wordVectors.entrySet()) {
            bout.write(entry.getKey());
            SimpleMatrix vector = entry.getValue();
            for (int i = 0; i < vector.numRows(); ++i) {
                bout.write("  " + vector.get(i, 0));
            }
            bout.write("\n");
        }
        bout.close();
        fileWriter.close();
    }
}

