/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.TreeAnnotator;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Timing;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class GrammarCoverageChecker {
    private Options op;

    private void testOnTreebank(LexicalizedParser pd, TreebankLangParserParams tlpParams, Treebank testTreebank, String treebankRoot, Index<String> stateIndex) {
        Timing.startTime();
        TreeAnnotator annotator = new TreeAnnotator(tlpParams.headFinder(), tlpParams, this.op);
        this.op.trainOptions.splitters = ParentAnnotationStats.getEnglishSplitCategories(treebankRoot);
        this.op.trainOptions.sisterSplitters = Generics.newHashSet(Arrays.asList(this.op.tlpParams.sisterSplitters()));
        for (Tree goldTree : testTreebank) {
            goldTree = annotator.transformTree(goldTree);
            for (Tree localTree : goldTree) {
                if (localTree.isLeaf() || localTree.isPreTerminal() || localTree.children().length < 2) continue;
                System.out.println(GrammarCoverageChecker.localTreeToRule(localTree));
                double score = GrammarCoverageChecker.computeLocalTreeScore(localTree, stateIndex, pd);
                if (score == Double.NEGATIVE_INFINITY) {
                    // empty if block
                }
                System.out.println("score: " + score);
            }
        }
    }

    private static String localTreeToRule(Tree localTree) {
        StringBuilder sb = new StringBuilder();
        sb.append(localTree.value()).append(" -> ");
        for (int i = 0; i < localTree.children().length - 1; ++i) {
            sb.append(localTree.children()[i].value()).append(" ");
        }
        sb.append(localTree.children()[localTree.children().length - 1].value());
        return sb.toString();
    }

    private static double computeLocalTreeScore(Tree localTree, Index<String> stateIndex, LexicalizedParser pd) {
        try {
            String parent = localTree.value();
            int parentState = stateIndex.indexOf(parent);
            Tree[] children = localTree.children();
            String nextChild = children[0].value();
            String current = "@" + parent + "| [ [" + nextChild + "] ";
            int currentState = stateIndex.indexOf(current);
            List<UnaryRule> rules = pd.ug.rulesByParent(currentState);
            UnaryRule ur = rules.get(0);
            double localTreeScore = ur.score();
            for (int i = 1; i < children.length; ++i) {
                nextChild = children[i].value();
                int childState = stateIndex.indexOf(nextChild);
                List<BinaryRule> l = pd.bg.ruleListByLeftChild(currentState);
                BinaryRule foundBR = null;
                if (i < children.length - 1) {
                    for (BinaryRule br : l) {
                        if (br.rightChild != childState || br.parent == parentState) continue;
                        foundBR = br;
                        break;
                    }
                } else {
                    for (BinaryRule br : l) {
                        if (br.rightChild != childState || br.parent != parentState) continue;
                        foundBR = br;
                        break;
                    }
                }
                if (foundBR == null) {
                    return Double.NEGATIVE_INFINITY;
                }
                currentState = foundBR.parent;
                localTreeScore += (double)foundBR.score;
            }
            return localTreeScore;
        }
        catch (NoSuchElementException e) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    public static void main(String[] args) {
        new GrammarCoverageChecker().runTest(args);
    }

    public void runTest(String[] args) {
        LexicalizedParser pd = LexicalizedParser.loadModel(args[0], new String[0]);
        this.op = pd.getOp();
        MemoryTreebank testTreebank = this.op.tlpParams.memoryTreebank();
        int testlow = Integer.parseInt(args[2]);
        int testhigh = Integer.parseInt(args[3]);
        testTreebank.loadPath(args[1], (FileFilter)new NumberRangeFileFilter(testlow, testhigh, true));
        this.op.setOptionsOrWarn(args, 4, args.length);
        this.testOnTreebank(pd, new EnglishTreebankParserParams(), testTreebank, args[1], pd.stateIndex);
    }
}

