/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileFilter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParentAnnotationStats
implements TreeVisitor {
    private static Redwood.RedwoodChannels log = Redwood.channels(ParentAnnotationStats.class);
    private final TreebankLanguagePack tlp;
    private final boolean doTags;
    private Map<String, ClassicCounter<List<String>>> nodeRules = Generics.newHashMap();
    private Map<List<String>, ClassicCounter<List<String>>> pRules = Generics.newHashMap();
    private Map<List<String>, ClassicCounter<List<String>>> gPRules = Generics.newHashMap();
    private Map<String, ClassicCounter<List<String>>> tagNodeRules = Generics.newHashMap();
    private Map<List<String>, ClassicCounter<List<String>>> tagPRules = Generics.newHashMap();
    private Map<List<String>, ClassicCounter<List<String>>> tagGPRules = Generics.newHashMap();
    public static final double[] CUTOFFS = new double[]{100.0, 200.0, 500.0, 1000.0};
    public static final double SUPPCUTOFF = 100.0;

    private ParentAnnotationStats(TreebankLanguagePack tlp, boolean doTags) {
        this.tlp = tlp;
        this.doTags = doTags;
    }

    @Override
    public void visitTree(Tree t) {
        this.processTreeHelper("TOP", "TOP", t);
    }

    public static List<String> kidLabels(Tree t) {
        Tree[] kids = t.children();
        ArrayList<String> l = new ArrayList<String>(kids.length);
        for (Tree kid : kids) {
            l.add(kid.label().value());
        }
        return l;
    }

    public void processTreeHelper(String gP, String p, Tree t) {
        if (!(t.isLeaf() || !this.doTags && t.isPreTerminal())) {
            Tree[] kids;
            Map<List<String>, ClassicCounter<List<String>>> gpr;
            Map<List<String>, ClassicCounter<List<String>>> pr;
            Map<String, ClassicCounter<List<String>>> nr;
            if (t.isPreTerminal()) {
                nr = this.tagNodeRules;
                pr = this.tagPRules;
                gpr = this.tagGPRules;
            } else {
                nr = this.nodeRules;
                pr = this.pRules;
                gpr = this.gPRules;
            }
            String n = t.label().value();
            if (this.tlp != null) {
                p = this.tlp.basicCategory(p);
                gP = this.tlp.basicCategory(gP);
            }
            List<String> kidn = ParentAnnotationStats.kidLabels(t);
            ClassicCounter<List<String>> cntr = nr.get(n);
            if (cntr == null) {
                cntr = new ClassicCounter();
                nr.put(n, cntr);
            }
            cntr.incrementCount(kidn);
            ArrayList<String> pairStr = new ArrayList<String>(2);
            pairStr.add(n);
            pairStr.add(p);
            cntr = pr.get(pairStr);
            if (cntr == null) {
                cntr = new ClassicCounter();
                pr.put(pairStr, cntr);
            }
            cntr.incrementCount(kidn);
            ArrayList<String> tripleStr = new ArrayList<String>(3);
            tripleStr.add(n);
            tripleStr.add(p);
            tripleStr.add(gP);
            cntr = gpr.get(tripleStr);
            if (cntr == null) {
                cntr = new ClassicCounter();
                gpr.put(tripleStr, cntr);
            }
            cntr.incrementCount(kidn);
            for (Tree kid : kids = t.children()) {
                this.processTreeHelper(p, n, kid);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printStats() {
        void var5_16;
        void var5_14;
        void var5_12;
        String nd;
        double psd;
        Pair p;
        Pair answer;
        Iterator<List<String>> iterator;
        double support2;
        ClassicCounter<List<String>> cntr2;
        double support;
        ClassicCounter<List<String>> cntr;
        ArrayList<Pair<List<String>, Double>> answers;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        StringBuffer[] javaSB = new StringBuffer[CUTOFFS.length];
        for (int i2 = 0; i2 < CUTOFFS.length; ++i2) {
            javaSB[i2] = new StringBuffer("  private static String[] splitters" + (i2 + 1) + " = new String[] {");
        }
        ClassicCounter<List<String>> allScores = new ClassicCounter<List<String>>();
        for (String string : this.nodeRules.keySet()) {
            answers = Generics.newArrayList();
            cntr = this.nodeRules.get(string);
            support = cntr.totalCount();
            System.out.println("Node " + string + " support is " + support);
            for (List<String> key : this.pRules.keySet()) {
                if (!key.get(0).equals(string)) continue;
                cntr2 = this.pRules.get(key);
                support2 = cntr2.totalCount();
                double kl = Counters.klDivergence(cntr2, cntr);
                System.out.println("KL(" + key + "||" + string + ") = " + nf.format(kl) + "\t" + "support(" + key + ") = " + support2);
                double score = kl * support2;
                answers.add(new Pair<List<String>, Double>(key, new Double(score)));
                allScores.setCount(key, score);
            }
            System.out.println("----");
            System.out.println("Sorted descending support * KL");
            Collections.sort(answers, (o1, o2) -> ((Double)o2.second()).compareTo((Double)o1.second()));
            iterator = answers.iterator();
            while (iterator.hasNext()) {
                p = answer = (Pair)((Object)iterator.next());
                psd = (Double)p.second();
                System.out.println(p.first() + ": " + nf.format(psd));
                if (!(psd >= CUTOFFS[0])) continue;
                List lst = (List)p.first();
                nd = (String)lst.get(0);
                String par = (String)lst.get(1);
                for (int j = 0; j < CUTOFFS.length; ++j) {
                    if (!(psd >= CUTOFFS[j])) continue;
                    javaSB[j].append("\"").append(nd).append("^");
                    javaSB[j].append(par).append("\", ");
                }
            }
            System.out.println();
        }
        for (List list : this.pRules.keySet()) {
            answers = Generics.newArrayList();
            cntr = this.pRules.get(list);
            support = cntr.totalCount();
            if (support < 100.0) continue;
            System.out.println("Node " + list + " support is " + support);
            for (List<String> key : this.gPRules.keySet()) {
                if (!key.get(0).equals(list.get(0)) || !key.get(1).equals(list.get(1))) continue;
                cntr2 = this.gPRules.get(key);
                support2 = cntr2.totalCount();
                double kl = Counters.klDivergence(cntr2, cntr);
                System.out.println("KL(" + key + "||" + list + ") = " + nf.format(kl) + "\t" + "support(" + key + ") = " + support2);
                double score = kl * support2;
                answers.add(Pair.makePair(key, new Double(score)));
                allScores.setCount(key, score);
            }
            System.out.println("----");
            System.out.println("Sorted descending support * KL");
            Collections.sort(answers, (o1, o2) -> ((Double)o2.second()).compareTo((Double)o1.second()));
            iterator = answers.iterator();
            while (iterator.hasNext()) {
                p = answer = (Pair)((Object)iterator.next());
                psd = (Double)p.second();
                System.out.println(p.first() + ": " + nf.format(psd));
                if (!(psd >= CUTOFFS[0])) continue;
                List lst = (List)p.first();
                nd = (String)lst.get(0);
                String par = (String)lst.get(1);
                String gpar = (String)lst.get(2);
                for (int j = 0; j < CUTOFFS.length; ++j) {
                    if (!(psd >= CUTOFFS[j])) continue;
                    javaSB[j].append("\"").append(nd).append("^");
                    javaSB[j].append(par).append("~");
                    javaSB[j].append(gpar).append("\", ");
                }
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("All scores:");
        PriorityQueue<List> pq = Counters.toPriorityQueue(allScores);
        while (!pq.isEmpty()) {
            List list = (List)pq.getFirst();
            double score = pq.getPriority(list);
            pq.removeFirst();
            System.out.println(list + "\t" + score);
        }
        System.out.println("  // Automatically generated by ParentAnnotationStats -- preferably don't edit");
        boolean bl = false;
        while (var5_12 < CUTOFFS.length) {
            int len = javaSB[var5_12].length();
            javaSB[var5_12].replace(len - 2, len, "};");
            System.out.println(javaSB[var5_12]);
            ++var5_12;
        }
        System.out.print("  public static HashSet splitters = new HashSet(Arrays.asList(");
        int n = CUTOFFS.length;
        while (var5_14 > 0) {
            if (var5_14 == true) {
                System.out.print("splitters1");
            } else {
                System.out.print("selectiveSplit" + (int)var5_14 + " ? splitters" + (int)var5_14 + " : (");
            }
            --var5_14;
        }
        int n2 = CUTOFFS.length;
        while (var5_16 >= 0) {
            System.out.print(")");
            --var5_16;
        }
        System.out.println(";");
    }

    private static void getSplitters(double cutOff, Map<String, ClassicCounter<List<String>>> nr, Map<List<String>, ClassicCounter<List<String>>> pr, Map<List<String>, ClassicCounter<List<String>>> gpr, Set<String> splitters) {
        double support2;
        double support;
        ClassicCounter<List<String>> cntr;
        ArrayList<Pair<List<String>, Double>> answers;
        for (String string : nr.keySet()) {
            answers = new ArrayList<Pair<List<String>, Double>>();
            cntr = nr.get(string);
            support = cntr.totalCount();
            for (List<String> list : pr.keySet()) {
                if (!list.get(0).equals(string)) continue;
                ClassicCounter<List<String>> cntr2 = pr.get(list);
                support2 = cntr2.totalCount();
                double kl = Counters.klDivergence(cntr2, cntr);
                answers.add(new Pair<List<String>, Double>(list, new Double(kl * support2)));
            }
            Collections.sort(answers, (o1, o2) -> ((Double)o2.second()).compareTo((Double)o1.second()));
            for (Pair pair : answers) {
                double psd = (Double)pair.second();
                if (!(psd >= cutOff)) continue;
                List lst = (List)pair.first();
                String nd = (String)lst.get(0);
                String par = (String)lst.get(1);
                String name = nd + "^" + par;
                splitters.add(name);
            }
        }
        for (List list : pr.keySet()) {
            answers = Generics.newArrayList();
            cntr = pr.get(list);
            support = cntr.totalCount();
            if (support < 100.0) continue;
            for (List<String> list2 : gpr.keySet()) {
                if (!list2.get(0).equals(list.get(0)) || !list2.get(1).equals(list.get(1))) continue;
                ClassicCounter<List<String>> cntr2 = gpr.get(list2);
                support2 = cntr2.totalCount();
                double kl = Counters.klDivergence(cntr2, cntr);
                answers.add(new Pair<List<String>, Double>(list2, new Double(kl * support2)));
            }
            Collections.sort(answers, (o1, o2) -> ((Double)o2.second()).compareTo((Double)o1.second()));
            for (Pair pair : answers) {
                Pair p = pair;
                double psd = (Double)p.second();
                if (!(psd >= cutOff)) continue;
                List lst = (List)p.first();
                String nd = (String)lst.get(0);
                String par = (String)lst.get(1);
                String gpar = (String)lst.get(2);
                String name = nd + "^" + par + "~" + gpar;
                splitters.add(name);
            }
        }
    }

    public static void main(String[] args) {
        boolean doTags = false;
        if (args.length < 1) {
            System.out.println("Usage: java edu.stanford.nlp.parser.lexparser.ParentAnnotationStats [-tags] treebankPath");
        } else {
            int i = 0;
            boolean useCutOff = false;
            double cutOff = 0.0;
            while (args[i].startsWith("-")) {
                if (args[i].equals("-tags")) {
                    doTags = true;
                    ++i;
                    continue;
                }
                if (args[i].equals("-cutOff") && i + 1 < args.length) {
                    useCutOff = true;
                    cutOff = Double.parseDouble(args[i + 1]);
                    i += 2;
                    continue;
                }
                log.info("Unknown option: " + args[i]);
                ++i;
            }
            DiskTreebank treebank = new DiskTreebank(in -> new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), new BobChrisTreeNormalizer()));
            treebank.loadPath(args[i]);
            if (useCutOff) {
                Set<String> splitters = ParentAnnotationStats.getSplitCategories(treebank, doTags, 0, cutOff, cutOff, null);
                System.out.println(splitters);
            } else {
                ParentAnnotationStats pas = new ParentAnnotationStats(null, doTags);
                ((Treebank)treebank).apply(pas);
                pas.printStats();
            }
        }
    }

    public static Set<String> getSplitCategories(Treebank t, double cutOff, TreebankLanguagePack tlp) {
        return ParentAnnotationStats.getSplitCategories(t, true, 0, cutOff, cutOff, tlp);
    }

    public static Set<String> getSplitCategories(Treebank t, boolean doTags, int algorithm, double phrasalCutOff, double tagCutOff, TreebankLanguagePack tlp) {
        ParentAnnotationStats pas = new ParentAnnotationStats(tlp, doTags);
        t.apply(pas);
        Set<String> splitters = Generics.newHashSet();
        ParentAnnotationStats.getSplitters(phrasalCutOff, pas.nodeRules, pas.pRules, pas.gPRules, splitters);
        ParentAnnotationStats.getSplitters(tagCutOff, pas.tagNodeRules, pas.tagPRules, pas.tagGPRules, splitters);
        return splitters;
    }

    public static Set<String> getEnglishSplitCategories(String treebankRoot) {
        EnglishTreebankParserParams tlpParams = new EnglishTreebankParserParams();
        MemoryTreebank trees = tlpParams.memoryTreebank();
        trees.loadPath(treebankRoot, (FileFilter)new NumberRangeFileFilter(200, 2199, true));
        return ParentAnnotationStats.getSplitCategories(trees, 300.0, tlpParams.treebankLanguagePack());
    }
}

