/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.SpanishUnknownWordModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.HashIndex;
import junit.framework.TestCase;

public class SpanishUnknownWordModelTest
extends TestCase {
    private SpanishUnknownWordModel uwm;

    public void setUp() {
        Options op = new Options();
        op.lexOptions.useUnknownWordSignatures = 1;
        HashIndex<String> wordIndex = new HashIndex<String>();
        HashIndex<String> tagIndex = new HashIndex<String>();
        this.uwm = new SpanishUnknownWordModel(op, new BaseLexicon(op, wordIndex, tagIndex), wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>());
    }

    public void testGetSignature() throws Exception {
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-cond-c", (String)this.uwm.getSignature("marcar\u00eda", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-imp-c", (String)this.uwm.getSignature("marcaba", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-imp-c", (String)this.uwm.getSignature("marc\u00e1bamos", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-imp-c", (String)this.uwm.getSignature("viv\u00edas", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-imp-c", (String)this.uwm.getSignature("viv\u00edamos", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-inf-c", (String)this.uwm.getSignature("brindar", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-adv-c", (String)this.uwm.getSignature("r\u00e1pidamente", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-vb1p-c", (String)this.uwm.getSignature("mandamos", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-s-c", (String)this.uwm.getSignature("\u00faltimos", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-ger-c", (String)this.uwm.getSignature("marcando", 0));
        SpanishUnknownWordModelTest.assertEquals((String)"UNK-s-c", (String)this.uwm.getSignature("marcados", 0));
    }
}

