/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.parser.metrics.TreeSpanScoring;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import junit.framework.TestCase;

public class TreeSpanScoringTest
extends TestCase {
    TreebankLanguagePack tlp = new PennTreebankLanguagePack();

    public void testNoErrors() {
        Tree t1 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        TreeSpanScoringTest.assertEquals((int)0, (int)TreeSpanScoring.countSpanErrors(this.tlp, t1, t1));
    }

    public void testTagErrors() {
        Tree t1 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        Tree t2 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (VBG sausage))))) (. .)))");
        TreeSpanScoringTest.assertEquals((int)2, (int)TreeSpanScoring.countSpanErrors(this.tlp, t1, t2));
        TreeSpanScoringTest.assertEquals((int)2, (int)TreeSpanScoring.countSpanErrors(this.tlp, t2, t1));
    }

    public void testMislabeledSpans() {
        Tree t1 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        Tree t2 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (ADVP (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        TreeSpanScoringTest.assertEquals((int)2, (int)TreeSpanScoring.countSpanErrors(this.tlp, t1, t2));
        TreeSpanScoringTest.assertEquals((int)2, (int)TreeSpanScoring.countSpanErrors(this.tlp, t2, t1));
    }

    public void testExtraSpan() {
        Tree t1 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        Tree t2 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (ADVP (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage)))))) (. .)))");
        TreeSpanScoringTest.assertEquals((int)1, (int)TreeSpanScoring.countSpanErrors(this.tlp, t1, t2));
    }

    public void testMissingSpan() {
        Tree t1 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))");
        Tree t2 = Tree.valueOf("(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (VP (VBG eating) (NP (NN sausage)))) (. .)))");
        TreeSpanScoringTest.assertEquals((int)1, (int)TreeSpanScoring.countSpanErrors(this.tlp, t1, t2));
    }
}

