/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class TsarfatyEval
extends AbstractEval {
    private final boolean useTag;
    private final ConstituentFactory cf = new LabeledScoredConstituentFactory();
    private static final int minArgs = 2;
    private static final StringBuilder usage = new StringBuilder();

    public TsarfatyEval(String str, boolean tags) {
        super(str, false);
        this.useTag = tags;
    }

    @Override
    protected Set<?> makeObjects(Tree tree) {
        Set<Constituent> deps = Generics.newHashSet();
        if (tree != null) {
            this.extractDeps(tree, 0, deps);
        }
        return deps;
    }

    private int extractDeps(Tree t, int left, Set<Constituent> deps) {
        int position = left;
        if (!this.useTag && t.isLeaf()) {
            deps.add(this.cf.newConstituent(left, (position += t.label().value().length()) - 1, t.label(), 0.0));
        } else if (this.useTag && t.isPreTerminal()) {
            deps.add(this.cf.newConstituent(left, (position += t.firstChild().label().value().length()) - 1, t.label(), 0.0));
        } else {
            Tree[] kids;
            for (Tree kid : kids = t.children()) {
                position = this.extractDeps(kid, position, deps);
            }
        }
        return position;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(usage.toString());
            System.exit(-1);
        }
        TreebankLangParserParams tlpp = new EnglishTreebankParserParams();
        int maxGoldYield = Integer.MAX_VALUE;
        int maxGuessYield = Integer.MAX_VALUE;
        boolean VERBOSE = false;
        boolean skipGuess = false;
        boolean tagMode = false;
        String guessFile = null;
        String goldFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                switch (args[i]) {
                    case "-l": {
                        Language lang = Language.valueOf(args[++i].trim());
                        tlpp = lang.params;
                        break;
                    }
                    case "-y": {
                        maxGoldYield = Integer.parseInt(args[++i].trim());
                        break;
                    }
                    case "-t": {
                        tagMode = true;
                        break;
                    }
                    case "-v": {
                        VERBOSE = true;
                        break;
                    }
                    case "-g": {
                        maxGuessYield = Integer.parseInt(args[++i].trim());
                        skipGuess = true;
                        break;
                    }
                    default: {
                        System.out.println(usage.toString());
                        System.exit(-1);
                        break;
                    }
                }
                continue;
            }
            goldFile = args[i++];
            guessFile = args[i];
            break;
        }
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        String evalName = tagMode ? "TsarfatyTAG" : "TsarfatySEG";
        TsarfatyEval eval = new TsarfatyEval(evalName, tagMode);
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        int goldLineId = 0;
        int skippedGuessTrees = 0;
        block15: for (Tree guess : guessTreebank) {
            Tree evalGuess = tc.transformTree(guess);
            ArrayList<Label> guessSent = guess.yield();
            String guessChars = SentenceUtils.listToString(guessSent).replaceAll("\\s+", "");
            if (guessSent.size() > maxGuessYield) {
                ++skippedGuessTrees;
                continue;
            }
            boolean doneEval = false;
            while (goldItr.hasNext() && !doneEval) {
                Tree gold = (Tree)goldItr.next();
                Tree evalGold = tc.transformTree(gold);
                ++goldLineId;
                ArrayList<Label> goldSent = gold.yield();
                String goldChars = SentenceUtils.listToString(goldSent).replaceAll("\\s+", "");
                if (goldSent.size() > maxGoldYield) continue;
                if (goldChars.length() != guessChars.length()) {
                    pwOut.printf("Char level yield mismatch at line %d (guess: %d gold: %d)\n", goldLineId, guessChars.length(), goldChars.length());
                    ++skippedGuessTrees;
                    continue block15;
                }
                eval.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
                doneEval = true;
            }
        }
        pwOut.println("================================================================================");
        if (skippedGuessTrees != 0) {
            pwOut.printf("%s %d guess trees\n", skipGuess ? "Skipped" : "Unable to evaluate", skippedGuessTrees);
        }
        eval.display(true, pwOut);
        pwOut.println();
        pwOut.close();
    }

    static {
        usage.append(String.format("Usage: java %s [OPTS] gold guess\n\n", TsarfatyEval.class.getName()));
        usage.append("Options:\n");
        usage.append("  -v         : Verbose mode.\n");
        usage.append("  -l lang    : Select language settings from " + Language.class.getName() + "\n");
        usage.append("  -y num     : Skip gold trees with yields longer than num.\n");
        usage.append("  -g num     : Skip guess trees with yields longer than num.\n");
        usage.append("  -t         : Tagging mode (default: segmentation).\n");
    }
}

