/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.shiftreduce.Oracle;
import edu.stanford.nlp.parser.shiftreduce.OracleTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class OracleTest
extends TestCase {
    String[] TEST_TREES = new String[]{"(ROOT (S (S (NP (PRP I)) (VP (VBP like) (NP (JJ big) (NNS butts)))) (CC and) (S (NP (PRP I)) (VP (MD can) (RB not) (VP (VB lie)))) (. .)))", "(ROOT (S (NP (NP (RB Not) (PDT all) (DT those)) (SBAR (WHNP (WP who)) (S (VP (VBD wrote))))) (VP (VBP oppose) (NP (DT the) (NNS changes))) (. .)))", "(ROOT (S (NP (NP (DT The) (NNS anthers)) (PP (IN in) (NP (DT these) (NNS plants)))) (VP (VBP are) (ADJP (JJ difficult) (SBAR (S (VP (TO to) (VP (VB clip) (PRT (RP off)))))))) (. .)))"};

    public void testBuildParentMap() {
        Tree tree = Tree.valueOf("(A (B foo) (C bar))");
        IdentityHashMap<Tree, Tree> parents = Oracle.buildParentMap(tree);
        int total = OracleTest.recursiveTestBuildParentMap(tree, parents);
        OracleTest.assertEquals((int)total, (int)parents.size());
    }

    public static int recursiveTestBuildParentMap(Tree tree, Map<Tree, Tree> parents) {
        int children = tree.children().length;
        for (Tree child : tree.children()) {
            OracleTest.assertEquals((Object)tree, (Object)parents.get(child));
            children += OracleTest.recursiveTestBuildParentMap(child, parents);
        }
        return children;
    }

    public List<Tree> buildTestTreebank() {
        MemoryTreebank treebank = new MemoryTreebank();
        for (String text : this.TEST_TREES) {
            Tree tree = Tree.valueOf(text);
            treebank.add(tree);
        }
        List<Tree> binarizedTrees = ShiftReduceParser.binarizeTreebank(treebank, new Options());
        return binarizedTrees;
    }

    public void testEndToEndCompoundUnaries() {
        List<Tree> binarizedTrees = this.buildTestTreebank();
        Oracle oracle = new Oracle(binarizedTrees, true, Collections.singleton("ROOT"));
        OracleTest.runEndToEndTest(binarizedTrees, oracle);
    }

    public void testEndToEndSingleUnaries() {
        List<Tree> binarizedTrees = this.buildTestTreebank();
        Oracle oracle = new Oracle(binarizedTrees, false, Collections.singleton("ROOT"));
        OracleTest.runEndToEndTest(binarizedTrees, oracle);
    }

    public static void runEndToEndTest(List<Tree> binarizedTrees, Oracle oracle) {
        for (int index = 0; index < binarizedTrees.size(); ++index) {
            State state = ShiftReduceParser.initialStateFromGoldTagTree(binarizedTrees.get(index));
            while (!state.isFinished()) {
                OracleTransition gold = oracle.goldTransition(index, state);
                OracleTest.assertTrue((gold.transition != null ? 1 : 0) != 0);
                state = gold.transition.apply(state);
            }
            OracleTest.assertEquals((Object)binarizedTrees.get(index), (Object)state.stack.peek());
        }
    }
}

