/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TestOptions;
import edu.stanford.nlp.parser.lexparser.TrainOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceTestOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceTrainOptions;
import edu.stanford.nlp.util.ErasureUtils;

public class ShiftReduceOptions
extends Options {
    public boolean compoundUnaries = true;
    public String featureFactoryClass = "edu.stanford.nlp.parser.shiftreduce.BasicFeatureFactory";
    private static final long serialVersionUID = 1L;

    @Override
    public TrainOptions newTrainOptions() {
        return new ShiftReduceTrainOptions();
    }

    @Override
    public TestOptions newTestOptions() {
        return new ShiftReduceTestOptions();
    }

    ShiftReduceTrainOptions trainOptions() {
        return (ShiftReduceTrainOptions)ErasureUtils.uncheckedCast(this.trainOptions);
    }

    ShiftReduceTestOptions testOptions() {
        return (ShiftReduceTestOptions)ErasureUtils.uncheckedCast(this.testOptions);
    }

    @Override
    protected int setOptionFlag(String[] args, int i) {
        int j = super.setOptionFlag(args, i);
        if (i != j) {
            return j;
        }
        if (args[i].equalsIgnoreCase("-beamSize")) {
            this.testOptions().beamSize = Integer.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-trainBeamSize")) {
            this.trainOptions().beamSize = Integer.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-compoundUnaries")) {
            this.compoundUnaries = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-nocompoundUnaries")) {
            this.compoundUnaries = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-featureFactory")) {
            this.featureFactoryClass = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-averagedModels")) {
            this.trainOptions().averagedModels = Integer.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-cvAveragedModels")) {
            this.trainOptions().cvAveragedModels = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noCVAveragedModels")) {
            this.trainOptions().cvAveragedModels = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retrainAfterCutoff")) {
            this.trainOptions().retrainAfterCutoff = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noRetrainAfterCutoff")) {
            this.trainOptions().retrainAfterCutoff = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-trainingMethod")) {
            this.trainOptions().trainingMethod = ShiftReduceTrainOptions.TrainingMethod.valueOf(args[i + 1].toUpperCase());
            if (this.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.BEAM || this.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM) {
                if (this.trainOptions().beamSize <= 0) {
                    this.trainOptions().beamSize = 4;
                }
                if (this.testOptions().beamSize <= 0) {
                    this.testOptions().beamSize = this.trainOptions().beamSize;
                }
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-featureFrequencyCutoff")) {
            this.trainOptions().featureFrequencyCutoff = Integer.valueOf(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-saveIntermediateModels")) {
            this.trainOptions().saveIntermediateModels = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-nosaveIntermediateModels")) {
            this.trainOptions().saveIntermediateModels = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-oracleShiftToBinary")) {
            this.trainOptions().oracleShiftToBinary = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-oracleBinaryToShift")) {
            this.trainOptions().oracleBinaryToShift = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-recordBinarized")) {
            this.testOptions().recordBinarized = args[i + 1];
            i += 2;
        } else if (args[i].equalsIgnoreCase("-recordDebinarized")) {
            this.testOptions().recordDebinarized = args[i + 1];
            i += 2;
        }
        return i;
    }
}

