/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.Tree;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class ShiftReduceParserITest
extends TestCase {
    private static ShiftReduceParser englishParser = null;
    private static MaxentTagger englishTagger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        Class<ShiftReduceParserITest> clazz = ShiftReduceParserITest.class;
        synchronized (ShiftReduceParserITest.class) {
            if (englishParser == null) {
                englishParser = ShiftReduceParser.loadModel("edu/stanford/nlp/models/srparser/englishSR.ser.gz", new String[0]);
                englishTagger = new MaxentTagger("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testSimpleParse() {
        List<CoreLabel> sentence = SentenceUtils.toCoreLabelList("This", "is", "a", "simple", "test", ".");
        englishTagger.tagCoreLabels(sentence);
        Tree result = englishParser.apply(sentence);
    }

    public void testBasicConstraint() {
        List<CoreLabel> sentence = SentenceUtils.toCoreLabelList("It", "was", "Carolina", "Reapers", ".");
        englishTagger.tagCoreLabels(sentence);
        Tree result = englishParser.apply(sentence);
        ShiftReduceParserITest.assertEquals((String)"(ROOT (S (NP (PRP It)) (VP (VBD was) (NP (NNP Carolina) (NNP Reapers))) (. .)))", (String)result.toString());
        ParserConstraint constraint = new ParserConstraint(2, 4, ".*");
        List<ParserConstraint> constraints = Collections.singletonList(constraint);
        ParserQuery pq = englishParser.parserQuery();
        pq.setConstraints(constraints);
        ShiftReduceParserITest.assertTrue((boolean)pq.parse(sentence));
        result = pq.getBestParse();
        ShiftReduceParserITest.assertEquals((String)"(ROOT (S (NP (PRP It)) (VP (VBD was) (NP (NNP Carolina) (NNP Reapers))) (. .)))", (String)result.toString());
        constraint = new ParserConstraint(2, 4, "NP");
        constraints = Collections.singletonList(constraint);
        pq = englishParser.parserQuery();
        pq.setConstraints(constraints);
        ShiftReduceParserITest.assertTrue((boolean)pq.parse(sentence));
        result = pq.getBestParse();
        ShiftReduceParserITest.assertEquals((String)"(ROOT (S (NP (PRP It)) (VP (VBD was) (NP (NNP Carolina) (NNP Reapers))) (. .)))", (String)result.toString());
        constraint = new ParserConstraint(2, 4, "ADJP");
        constraints = Collections.singletonList(constraint);
        pq = englishParser.parserQuery();
        pq.setConstraints(constraints);
        ShiftReduceParserITest.assertTrue((boolean)pq.parse(sentence));
        result = pq.getBestParse();
        ShiftReduceParserITest.assertEquals((String)"(ROOT (S (NP (PRP It)) (VP (VBD was) (ADJP (NP (NNP Carolina) (NNP Reapers)))) (. .)))", (String)result.toString());
        constraint = new ParserConstraint(1, 3, "VP");
        constraints = Collections.singletonList(constraint);
        pq = englishParser.parserQuery();
        pq.setConstraints(constraints);
        ShiftReduceParserITest.assertTrue((boolean)pq.parse(sentence));
        result = pq.getBestParse();
        ShiftReduceParserITest.assertEquals((String)"(ROOT (S (NP (PRP It)) (VP (VBD was) (NP (NNP Carolina))) (NP (NNP Reapers)) (. .)))", (String)result.toString());
    }
}

