/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.BinaryHeadFinder;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.shiftreduce.CreateTransitionSequence;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import junit.framework.TestCase;

public class ShiftReduceParserTest
extends TestCase {
    String commaTreeString = "(ROOT (FRAG (NP (DT A) (@NP (ADJP (JJ short) (@ADJP (, ,) (JJ simple))) (NN test)))))";
    String[] treeStrings = new String[]{"(ROOT (S (INTJ (RB No)) (@S (, ,) (@S (NP (PRP it)) (@S (VP (@VP (VBD was) (RB n't)) (NP (NNP Black) (NNP Monday))) (. .))))) (.$$. .$.))", "(ROOT (S (CC But) (@S (SBAR (IN while) (S (NP (DT the) (@NP (NNP New) (@NP (NNP York) (@NP (NNP Stock) (NNP Exchange))))) (VP (@VP (VBD did) (RB n't)) (VP (@VP (@VP (VB fall) (ADVP (RB apart))) (NP (NNP Friday))) (SBAR (IN as) (S (NP (DT the) (@NP (NNP Dow) (@NP (NNP Jones) (@NP (NNP Industrial) (NNP Average))))) (VP (VBD plunged) (NP (NP (CD 190.58) (NNS points)) (PRN (: --) (@PRN (NP (@NP (NP (JJS most)) (PP (IN of) (NP (PRP it)))) (PP (IN in) (NP (DT the) (@NP (JJ final) (NN hour))))) (: --))))))))))) (@S (NP (PRP it)) (@S (ADVP (RB barely)) (@S (VP (VBD managed) (S (VP (TO to) (VP (VB stay) (NP (NP (DT this) (NN side)) (PP (IN of) (NP (NN chaos)))))))) (. .)))))) (.$$. .$.))", "(ROOT (S (NP (NP (DT Some) (@NP (`` ``) (@NP (NN circuit) (@NP (NNS breakers) ('' ''))))) (VP (VBN installed) (PP (IN after) (NP (DT the) (@NP (NNP October) (@NP (CD 1987) (NN crash))))))) (@S (VP (@VP (@VP (VBD failed) (NP (PRP$ their) (@NP (JJ first) (NN test)))) (PRN (, ,) (@PRN (S (NP (NNS traders)) (VP (VBP say))) (, ,)))) (S (ADJP (JJ unable) (S (VP (TO to) (VP (VB cool) (NP (NP (DT the) (@NP (NN selling) (NN panic))) (PP (IN in) (NP (DT both) (@NP (@NP (NNS stocks) (CC and)) (NNS futures))))))))))) (. .))) (.$$. .$.))", "(ROOT (S (NP (SBAR foo))))", this.commaTreeString};

    public void testUnaryTransitions() {
        for (String treeText : this.treeStrings) {
            Tree tree = this.convertTree(treeText);
            List<Transition> transitions = CreateTransitionSequence.createTransitionSequence(tree, false, Collections.singleton("ROOT"), Collections.singleton("ROOT"));
            State state = ShiftReduceParser.initialStateFromGoldTagTree(tree);
            for (Transition transition : transitions) {
                state = transition.apply(state);
            }
            ShiftReduceParserTest.assertEquals((Object)tree, (Object)state.stack.peek());
        }
    }

    public void testCompoundUnaryTransitions() {
        for (String treeText : this.treeStrings) {
            Tree tree = this.convertTree(treeText);
            List<Transition> transitions = CreateTransitionSequence.createTransitionSequence(tree, true, Collections.singleton("ROOT"), Collections.singleton("ROOT"));
            State state = ShiftReduceParser.initialStateFromGoldTagTree(tree);
            for (Transition transition : transitions) {
                state = transition.apply(state);
            }
            ShiftReduceParserTest.assertEquals((Object)tree, (Object)state.stack.peek());
        }
    }

    Tree convertTree(String treeText) {
        Options op = new Options();
        BinaryHeadFinder binaryHeadFinder = new BinaryHeadFinder(op.tlpParams.headFinder());
        Tree tree = Tree.valueOf(treeText);
        Trees.convertToCoreLabels(tree);
        tree.percolateHeadAnnotations(binaryHeadFinder);
        return tree;
    }

    public void testSeparators() {
        Tree tree = this.convertTree(this.commaTreeString);
        List<Transition> transitions = CreateTransitionSequence.createTransitionSequence(tree, true, Collections.singleton("ROOT"), Collections.singleton("ROOT"));
        List<String> expectedTransitions = Arrays.asList("Shift", "Shift", "Shift", "Shift", "RightBinary(@ADJP)", "RightBinary(ADJP)", "Shift", "RightBinary(@NP)", "RightBinary(NP)", "CompoundUnary*([ROOT, FRAG])", "Finalize", "Idle");
        ShiftReduceParserTest.assertEquals(expectedTransitions, CollectionUtils.transformAsList(transitions, new Function<Transition, String>(){

            @Override
            public String apply(Transition t) {
                return t.toString();
            }
        }));
        String expectedSeparators = "[{2=,}]";
        State state = ShiftReduceParser.initialStateFromGoldTagTree(tree);
        ShiftReduceParserTest.assertEquals((int)1, (int)state.separators.size());
        ShiftReduceParserTest.assertEquals((int)2, (int)state.separators.firstKey());
        ShiftReduceParserTest.assertEquals((String)",", (String)state.separators.get(2));
    }

    public void testInitialStateFromTagged() {
        String[] words = new String[]{"This", "is", "a", "short", "test", "."};
        String[] tags = new String[]{"DT", "VBZ", "DT", "JJ", "NN", "."};
        ShiftReduceParserTest.assertEquals((int)words.length, (int)tags.length);
        ArrayList<TaggedWord> sentence = SentenceUtils.toTaggedList(Arrays.asList(words), Arrays.asList(tags));
        State state = ShiftReduceParser.initialStateFromTaggedSentence(sentence);
        for (int i = 0; i < words.length; ++i) {
            ShiftReduceParserTest.assertEquals((String)tags[i], (String)state.sentence.get(i).value());
            ShiftReduceParserTest.assertEquals((int)1, (int)state.sentence.get(i).children().length);
            ShiftReduceParserTest.assertEquals((String)words[i], (String)state.sentence.get(i).children()[0].value());
        }
    }

    public void binarize() {
    }
}

