/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;

public class ShiftReduceUtilsTest
extends TestCase {
    public void testBinarySide() {
        String[] words = new String[]{"This", "is", "a", "short", "test", "."};
        String[] tags = new String[]{"DT", "VBZ", "DT", "JJ", "NN", "."};
        ShiftReduceUtilsTest.assertEquals((int)words.length, (int)tags.length);
        ArrayList<TaggedWord> sentence = SentenceUtils.toTaggedList(Arrays.asList(words), Arrays.asList(tags));
        State state = ShiftReduceParser.initialStateFromTaggedSentence(sentence);
        ShiftTransition shift = new ShiftTransition();
        state = shift.apply(shift.apply(state));
        BinaryTransition transition = new BinaryTransition("NP", BinaryTransition.Side.RIGHT);
        State next = transition.apply(state);
        ShiftReduceUtilsTest.assertEquals((Object)((Object)BinaryTransition.Side.RIGHT), (Object)((Object)ShiftReduceUtils.getBinarySide(next.stack.peek())));
        transition = new BinaryTransition("NP", BinaryTransition.Side.LEFT);
        next = transition.apply(state);
        ShiftReduceUtilsTest.assertEquals((Object)((Object)BinaryTransition.Side.LEFT), (Object)((Object)ShiftReduceUtils.getBinarySide(next.stack.peek())));
    }
}

