/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.surface.CreatePatterns;
import edu.stanford.nlp.patterns.surface.PatternsForEachTokenInMemory;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.Test;

public class CreatePatternsTest {
    @Test
    public void test() throws IOException {
        Properties props = new Properties();
        props.setProperty("patternType", "DEP");
        ConstantsAndVariables constvars = new ConstantsAndVariables(props, new HashSet<String>(), new HashMap<String, Class<? extends TypesafeMap.Key<String>>>());
        CreatePatterns createPatterns = new CreatePatterns(props, constvars);
        HashMap<String, DataInstance> sents = new HashMap<String, DataInstance>();
        ArrayCoreMap m = new ArrayCoreMap();
        String text = "We present a paper that focuses on semantic graphs applied to language.";
        String graphString = "[present/VBP-2 nsubj>We/PRP-1 dobj>[paper/NN-4 det>a/DT-3] ccomp>[applied/VBN-10 mark>that/IN-5 nsubj>[focuses/NN-6 nmod:on>[graphs/NNS-9 amod>semantic/JJ-8]] nmod:to>language/NN-12]]";
        SemanticGraph graph = SemanticGraph.valueOf(graphString);
        List<String> tokens = Arrays.asList("We", "present", "a", "paper", "that", "focuses", "on", "semantic", "graphs", "applied", "to", "language");
        m.set(CoreAnnotations.TokensAnnotation.class, tokens.stream().map(x -> {
            CoreLabel t = new CoreLabel();
            t.setWord((String)x);
            return t;
        }).collect(Collectors.toList()));
        m.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, graph);
        sents.put("sent1", DataInstance.getNewInstance(PatternFactory.PatternType.DEP, m));
        createPatterns.getAllPatterns(sents, props, ConstantsAndVariables.PatternForEachTokenWay.MEMORY);
        System.out.println("graph is " + graph);
        System.out.println(PatternsForEachTokenInMemory.patternsForEachToken);
    }
}

