/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.SentenceIndex;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.LuceneFieldType;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LuceneSentenceIndex<E extends Pattern>
extends SentenceIndex<E> {
    @ArgumentParser.Option(name="saveTokens")
    boolean saveTokens = false;
    IndexWriter indexWriter;
    File indexDir = null;
    Directory dir;
    Analyzer analyzer = new KeywordAnalyzer();
    IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_42, this.analyzer);
    DirectoryReader reader = null;
    IndexSearcher searcher;
    ProtobufAnnotationSerializer p = new ProtobufAnnotationSerializer();

    public LuceneSentenceIndex(Properties props, Set<String> stopWords, String indexDirStr, Function<CoreLabel, Map<String, String>> transformer) {
        super(stopWords, transformer);
        ArgumentParser.fillOptions((Object)this, props);
        this.indexDir = new File(indexDirStr);
    }

    void setIndexReaderSearcher() throws IOException {
        FSDirectory index = FSDirectory.open((File)this.indexDir);
        if (this.reader == null) {
            this.reader = DirectoryReader.open((Directory)index);
            this.searcher = new IndexSearcher((IndexReader)this.reader);
        } else {
            DirectoryReader newreader = DirectoryReader.openIfChanged((DirectoryReader)this.reader);
            if (newreader != null) {
                this.reader.close();
                this.reader = newreader;
                this.searcher = new IndexSearcher((IndexReader)this.reader);
            }
        }
    }

    Set<String> queryIndexGetSentences(CollectionValuedMap<String, String> words) throws IOException, ParseException {
        this.setIndexReaderSearcher();
        BooleanQuery query = new BooleanQuery();
        String pkey = Token.getKeyForClass(PatternsAnnotations.ProcessedTextAnnotation.class);
        for (Map.Entry<String, Collection<String>> en : words.entrySet()) {
            boolean processedKey = en.getKey().equals(pkey);
            for (String en2 : en.getValue()) {
                if (processedKey && this.stopWords.contains(en2.toLowerCase())) continue;
                query.add(new BooleanClause((Query)new TermQuery(new Term(en.getKey(), en2)), BooleanClause.Occur.MUST));
            }
        }
        TopDocs tp = this.searcher.search((Query)query, Integer.MAX_VALUE);
        HashSet<String> sentids = new HashSet<String>();
        if (tp.totalHits > 0) {
            for (ScoreDoc s : tp.scoreDocs) {
                int docId = s.doc;
                Document d = this.searcher.doc(docId);
                sentids.add(d.get("sentid"));
            }
        } else {
            throw new RuntimeException("how come no documents for " + words + ". Query formed is " + query);
        }
        return sentids;
    }

    @Override
    public void add(Map<String, DataInstance> sentences, boolean addProcessedText) {
        try {
            this.setIndexWriter();
            for (Map.Entry<String, DataInstance> en : sentences.entrySet()) {
                this.add(en.getValue().getTokens(), en.getKey(), addProcessedText);
            }
            this.indexWriter.commit();
            this.closeIndexWriter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<E, Set<String>> queryIndex(Collection<E> patterns) {
        try {
            HashMap<Pattern, Set<String>> sents = new HashMap<Pattern, Set<String>>();
            for (Pattern p : patterns) {
                Set<String> sentids = this.queryIndexGetSentences(p.getRelevantWords());
                sents.put(p, sentids);
            }
            return sents;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void listAllDocuments() throws IOException {
        this.setIndexReaderSearcher();
        for (int i = 0; i < this.reader.numDocs(); ++i) {
            Document d = this.searcher.doc(i);
            System.out.println(d.get("sentid"));
        }
    }

    private List<CoreLabel> readProtoBufAnnotation(byte[] sent) throws IOException {
        CoreNLPProtos.Token d;
        ProtobufAnnotationSerializer p = new ProtobufAnnotationSerializer();
        ArrayList<CoreLabel> toks = new ArrayList<CoreLabel>();
        ByteArrayInputStream is = new ByteArrayInputStream(sent);
        do {
            if ((d = CoreNLPProtos.Token.parseDelimitedFrom(is)) == null) continue;
            toks.add(p.fromProto(d));
        } while (d != null);
        return toks;
    }

    byte[] getProtoBufAnnotation(List<CoreLabel> tokens) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (CoreLabel token : tokens) {
            CoreNLPProtos.Token ptoken = this.p.toProto(token);
            ptoken.writeDelimitedTo(os);
        }
        os.flush();
        return os.toByteArray();
    }

    @Override
    protected void add(List<CoreLabel> tokens, String sentid, boolean addProcessedText) {
        try {
            this.setIndexWriter();
            Document doc = new Document();
            for (CoreLabel l : tokens) {
                String ptxt;
                for (Map.Entry en : ((Map)this.transformCoreLabeltoString.apply(l)).entrySet()) {
                    doc.add((IndexableField)new StringField((String)en.getKey(), (String)en.getValue(), Field.Store.YES));
                }
                if (!addProcessedText || this.stopWords.contains((ptxt = (String)l.get(PatternsAnnotations.ProcessedTextAnnotation.class)).toLowerCase())) continue;
                doc.add((IndexableField)new StringField(Token.getKeyForClass(PatternsAnnotations.ProcessedTextAnnotation.class), ptxt, Field.Store.YES));
            }
            doc.add((IndexableField)new StringField("sentid", sentid, Field.Store.YES));
            if (tokens != null && this.saveTokens) {
                doc.add((IndexableField)new Field("tokens", this.getProtoBufAnnotation(tokens), LuceneFieldType.NOT_INDEXED));
            }
            this.indexWriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finishUpdating() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.commit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closeIndexWriter();
    }

    @Override
    public void update(List<CoreLabel> tokens, String sentid) {
        try {
            this.setIndexWriter();
            this.indexWriter.deleteDocuments(new Query[]{new TermQuery(new Term("sentid", sentid))});
            this.add(tokens, sentid, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void setIndexWriter() {
        try {
            if (this.indexWriter == null) {
                this.dir = FSDirectory.open((File)this.indexDir);
                Redwood.log(new Object[]{Redwood.DBG, "Updating lucene index at " + this.indexDir});
                this.indexWriter = new IndexWriter(this.dir, this.iwc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void closeIndexWriter() {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
            }
            this.indexWriter = null;
            if (this.dir != null) {
                this.dir.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveIndex(String dir) {
        if (!this.indexDir.toString().equals(dir)) {
            try {
                IOUtils.cp(this.indexDir, new File(dir), true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static LuceneSentenceIndex createIndex(Map<String, List<CoreLabel>> sentences, Properties props, Set<String> stopWords, String indexDiskDir, Function<CoreLabel, Map<String, String>> transformer) {
        try {
            LuceneSentenceIndex sentindex = new LuceneSentenceIndex(props, stopWords, indexDiskDir, transformer);
            System.out.println("Creating lucene index at " + indexDiskDir);
            IOUtils.deleteDirRecursively(sentindex.indexDir);
            if (sentences != null) {
                sentindex.setIndexWriter();
                sentindex.add(sentences, true);
                sentindex.closeIndexWriter();
                sentindex.setIndexReaderSearcher();
                System.out.println("Number of documents added are " + sentindex.reader.numDocs());
                sentindex.numAllSentences += sentindex.reader.numDocs();
            }
            return sentindex;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LuceneSentenceIndex loadIndex(Properties props, Set<String> stopwords, String dir, Function<CoreLabel, Map<String, String>> transformSentenceToString) {
        try {
            LuceneSentenceIndex sentindex = new LuceneSentenceIndex(props, stopwords, dir, transformSentenceToString);
            sentindex.setIndexReaderSearcher();
            System.out.println("Number of documents read from the index " + dir + " are " + sentindex.reader.numDocs());
            sentindex.numAllSentences += sentindex.reader.numDocs();
            return sentindex;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

