/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.patterns.TextAnnotationPatterns;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SPIEDServlet
extends HttpServlet {
    Logger logger = Logger.getAnonymousLogger();
    String testPropertiesFile;
    Map<String, String> modelNametoDirName;

    public void init() throws ServletException {
        this.testPropertiesFile = this.getServletContext().getRealPath("/WEB-INF/data/test.properties");
        this.modelNametoDirName = new HashMap<String, String>();
        this.modelNametoDirName.put("food", "food");
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private void run(PrintWriter out2, String q, String seedWords, String model) throws Exception {
        String suggestions;
        if ((q = q.trim()).length() == 0) {
            return;
        }
        char lastChar = q.charAt(q.length() - 1);
        if (lastChar != '.' && lastChar != '!' && lastChar != '?') {
            q = q + ".";
        }
        TextAnnotationPatterns annotate = new TextAnnotationPatterns();
        String quotedString = SPIEDServlet.quote(q);
        String jsonObject = "{\"input\":" + quotedString + ",\"seedWords\":{\"NAME\":[\"" + StringUtils.join(seedWords.split("[,;]"), "\",\"") + "\"]}}";
        boolean testmode = true;
        if (model.equalsIgnoreCase("new")) {
            testmode = false;
        }
        this.logger.info("Testmode is " + testmode);
        this.logger.info("model is " + model);
        if (testmode) {
            Properties testProps = new Properties();
            if (this.testPropertiesFile != null && new File(this.testPropertiesFile).exists()) {
                try {
                    String props = IOUtils.stringFromFile(this.testPropertiesFile);
                    testProps.load(new StringReader(props));
                }
                catch (IOException e) {
                    this.writeError(e, out2, "Cannot read test properties file");
                    return;
                }
            } else {
                this.writeError(new RuntimeException("test prop file not found"), out2, "Test properties file not found");
                return;
            }
            String modelDir = this.getServletContext().getRealPath("/WEB-INF/data/" + this.modelNametoDirName.get(model));
            testProps.setProperty("patternsWordsDir", modelDir);
            this.logger.info("Reading saved model from " + modelDir);
            String seedWordsFiles = "NAME," + modelDir + "/NAME/seedwords.txt," + modelDir + "/NAME/phrases.txt";
            String modelPropertiesFile = modelDir + "/model.properties";
            this.logger.info("Loading model properties from " + modelPropertiesFile);
            String stopWordsFile = modelDir + "/stopwords.txt";
            boolean writeOutputFile = false;
            annotate.setUpProperties(jsonObject, false, writeOutputFile, seedWordsFiles);
            suggestions = annotate.suggestPhrasesTest(testProps, modelPropertiesFile, stopWordsFile);
        } else {
            boolean writeOutputFile = false;
            annotate.setUpProperties(jsonObject, false, writeOutputFile, null);
            annotate.processText(writeOutputFile);
            suggestions = annotate.suggestPhrases();
        }
        out2.print(suggestions);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("GET SPIED query from " + request.getRemoteAddr());
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("utf-8");
        }
        response.setContentType("text/json; charset=UTF-8");
        PrintWriter out2 = response.getWriter();
        try {
            String raw = request.getParameter("q");
            String seedwords = request.getParameter("seedwords");
            String model = request.getParameter("model");
            if (raw == null || "".equals(raw)) {
                out2.print("{\"okay\":false,\"reason\":\"No data provided\"}");
            } else {
                this.run(out2, raw, seedwords, model);
            }
        }
        catch (Exception t) {
            this.writeError(t, out2, request.toString());
        }
        out2.close();
    }

    void writeError(Throwable t, PrintWriter out2, String input) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        this.logger.info("input is " + input);
        this.logger.info(sw.toString());
        out2.print("{\"okay\":false, \"reason\":\"Something bad happened. Contact the author.\"}");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Responding to the request for SPIED");
        this.getServletContext().log("Responding through SPIED through servlet context!!");
        this.doGet(request, response);
    }

    public static void main(String[] args) throws ServletException, IOException {
        SPIEDServlet servlet = new SPIEDServlet();
        servlet.init();
    }
}

