/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TypesafeMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class TextAnnotationPatterns {
    Map<String, Class<? extends TypesafeMap.Key<String>>> humanLabelClasses = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
    Map<String, Class<? extends TypesafeMap.Key<String>>> machineAnswerClasses = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
    Properties props;
    String outputFile;
    Counter<String> matchedSeedWords;
    Map<String, Set<CandidatePhrase>> seedWords = new HashMap<String, Set<CandidatePhrase>>();
    private String backgroundSymbol = "O";
    Logger logger = Logger.getAnonymousLogger();

    public String getAllAnnotations() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        for (Map.Entry<String, DataInstance> sent : Data.sents.entrySet()) {
            boolean sentHasLabel = false;
            JsonObjectBuilder objsent = Json.createObjectBuilder();
            int tokenid = 0;
            for (CoreLabel l : sent.getValue().getTokens()) {
                boolean haslabel = false;
                JsonArrayBuilder labelArr = Json.createArrayBuilder();
                for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> en : this.humanLabelClasses.entrySet()) {
                    if (((String)l.get(en.getValue())).equals(this.backgroundSymbol)) continue;
                    haslabel = true;
                    sentHasLabel = true;
                    labelArr.add(en.getKey());
                }
                if (haslabel) {
                    objsent.add(String.valueOf(tokenid), labelArr);
                }
                ++tokenid;
            }
            if (!sentHasLabel) continue;
            obj.add(sent.getKey(), objsent);
        }
        return obj.build().toString();
    }

    public String getAllAnnotations(String input) {
        JsonObjectBuilder objsent = Json.createObjectBuilder();
        int tokenid = 0;
        for (CoreLabel l : Data.sents.get(input).getTokens()) {
            boolean haslabel = false;
            JsonArrayBuilder labelArr = Json.createArrayBuilder();
            for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> en : this.humanLabelClasses.entrySet()) {
                if (((String)l.get(en.getValue())).equals(this.backgroundSymbol)) continue;
                haslabel = true;
                labelArr.add(en.getKey());
            }
            if (haslabel) {
                objsent.add(String.valueOf(tokenid), labelArr);
            }
            ++tokenid;
        }
        return objsent.build().toString();
    }

    public String suggestPhrases() throws IOException, ClassNotFoundException, IllegalAccessException, InterruptedException, ExecutionException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.resetPatternLabelsInSents(Data.sents);
        GetPatternsFromDataMultiClass model = new GetPatternsFromDataMultiClass(this.props, Data.sents, this.seedWords, false, this.humanLabelClasses);
        model.iterateExtractApply();
        return model.constVars.getLearnedWordsAsJson();
    }

    public String suggestPhrasesTest(Properties testProps, String modelPropertiesFile, String stopWordsFile) throws IllegalAccessException, InterruptedException, ExecutionException, IOException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException, SQLException {
        String label2;
        String[] removeProperties;
        this.logger.info("Suggesting phrases in test");
        this.logger.info("test properties are " + testProps);
        Properties runProps = StringUtils.argsToPropertiesWithResolve(new String[]{"-props", modelPropertiesFile});
        for (String s : removeProperties = new String[]{"allPatternsDir", "storePatsForEachToken", "invertedIndexClass", "savePatternsWordsDir", "batchProcessSents", "outDir", "saveInvertedIndex", "removeOverLappingLabels", "numThreads"}) {
            if (!runProps.containsKey(s)) continue;
            runProps.remove(s);
        }
        runProps.setProperty("stopWordsPatternFiles", stopWordsFile);
        runProps.setProperty("englishWordsFiles", stopWordsFile);
        runProps.setProperty("commonWordsPatternFiles", stopWordsFile);
        runProps.putAll((Map<?, ?>)this.props);
        runProps.putAll((Map<?, ?>)testProps);
        this.props.putAll((Map<?, ?>)runProps);
        this.processText(false);
        GetPatternsFromDataMultiClass model = new GetPatternsFromDataMultiClass(runProps, Data.sents, this.seedWords, true, this.humanLabelClasses);
        ArgumentParser.fillOptions(model, runProps);
        GetPatternsFromDataMultiClass.loadFromSavedPatternsWordsDir(model, runProps);
        HashMap<String, Integer> alreadyLearnedIters = new HashMap<String, Integer>();
        for (String label2 : model.constVars.getLabels()) {
            alreadyLearnedIters.put(label2, model.constVars.getLearnedWordsEachIter().get(label2).lastEntry().getKey());
        }
        if (model.constVars.learn) {
            model.iterateExtractApply(null, null, null);
        }
        HashMap<String, Counter<CandidatePhrase>> allExtractions = new HashMap<String, Counter<CandidatePhrase>>();
        label2 = model.constVars.getLabels().iterator().next();
        allExtractions.put(label2, new ClassicCounter());
        for (Map.Entry<String, DataInstance> sent : Data.sents.entrySet()) {
            StringBuffer str = new StringBuffer();
            for (CoreLabel l : sent.getValue().getTokens()) {
                if (l.get(PatternsAnnotations.MatchedPatterns.class) != null && !((Set)l.get(PatternsAnnotations.MatchedPatterns.class)).isEmpty()) {
                    str.append(" " + l.word());
                    continue;
                }
                ((Counter)allExtractions.get(label2)).incrementCount(CandidatePhrase.createOrGet(str.toString().trim()));
                str.setLength(0);
            }
        }
        allExtractions.putAll(model.matchedSeedWords);
        return model.constVars.getSetWordsAsJson(allExtractions);
    }

    private void resetPatternLabelsInSents(Map<String, DataInstance> sents) {
        for (Map.Entry<String, DataInstance> sent : sents.entrySet()) {
            for (CoreLabel l : sent.getValue().getTokens()) {
                for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> cl : this.humanLabelClasses.entrySet()) {
                    l.set(this.machineAnswerClasses.get(cl.getKey()), l.get(cl.getValue()));
                }
            }
        }
    }

    public String getMatchedTokensByAllPhrases() {
        return GetPatternsFromDataMultiClass.matchedTokensByPhraseJsonString();
    }

    public String getMatchedTokensByPhrase(String input) {
        return GetPatternsFromDataMultiClass.matchedTokensByPhraseJsonString(input);
    }

    private void setProperties(Properties props) {
        if (!props.containsKey("fileFormat")) {
            props.setProperty("fileFormat", "txt");
        }
        if (!props.containsKey("learn")) {
            props.setProperty("learn", "false");
        }
        if (!props.containsKey("patternType")) {
            props.setProperty("patternType", "SURFACE");
        }
        props.setProperty("preserveSentenceSequence", "true");
        if (!props.containsKey("debug")) {
            props.setProperty("debug", "3");
        }
        if (!props.containsKey("thresholdWordExtract")) {
            props.setProperty("thresholdWordExtract", "0.00000000000000001");
        }
        if (!props.containsKey("thresholdNumPatternsApplied")) {
            props.setProperty("thresholdNumPatternsApplied", "1");
        }
        if (!props.containsKey("writeMatchedTokensIdsForEachPhrase")) {
            props.setProperty("writeMatchedTokensIdsForEachPhrase", "true");
        }
    }

    void setUpProperties(String line, boolean readFile, boolean writeOutputToFile, String additionalSeedWordsFiles) throws IOException, ClassNotFoundException {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(line));
        JsonObject objarr = jsonReader.readObject();
        jsonReader.close();
        Properties props = new Properties();
        for (Object o : objarr.keySet()) {
            if (((String)o).equals("seedWords")) {
                JsonObject obj = objarr.getJsonObject((String)o);
                for (String st : obj.keySet()) {
                    this.seedWords.put(st, new HashSet());
                    JsonArray arr = obj.getJsonArray(st);
                    for (int i = 0; i < arr.size(); ++i) {
                        String val = arr.getString(i);
                        this.seedWords.get(st).add(CandidatePhrase.createOrGet(val));
                        System.out.println("adding " + val + " for label " + st);
                    }
                }
                continue;
            }
            props.setProperty((String)o, objarr.getString((String)o));
        }
        System.out.println("seedwords are " + this.seedWords);
        if (additionalSeedWordsFiles != null && !additionalSeedWordsFiles.isEmpty()) {
            Map<String, Set<CandidatePhrase>> additionalSeedWords = GetPatternsFromDataMultiClass.readSeedWords(additionalSeedWordsFiles);
            this.logger.info("additional seed words are " + additionalSeedWords);
            for (String label : this.seedWords.keySet()) {
                if (!additionalSeedWords.containsKey(label)) continue;
                this.seedWords.get(label).addAll((Collection<CandidatePhrase>)additionalSeedWords.get(label));
            }
        }
        this.outputFile = null;
        if (readFile) {
            System.out.println("input value is " + objarr.getString("input"));
            this.outputFile = props.getProperty("input") + "_processed";
            props.setProperty("file", objarr.getString("input"));
            if (writeOutputToFile && !props.containsKey("columnOutputFile")) {
                props.setProperty("columnOutputFile", this.outputFile);
            }
        } else {
            String systemdir = System.getProperty("java.io.tmpdir");
            File tempFile = File.createTempFile("sents", ".tmp", new File(systemdir));
            tempFile.deleteOnExit();
            IOUtils.writeStringToFile(props.getProperty("input"), tempFile.getPath(), "utf8");
            props.setProperty("file", tempFile.getAbsolutePath());
        }
        this.setProperties(props);
        this.props = props;
        int i = 1;
        for (String label : this.seedWords.keySet()) {
            String ansclstr = "edu.stanford.nlp.patterns.PatternsAnnotations$PatternLabel" + i;
            Class<?> mcCl = Class.forName(ansclstr);
            this.machineAnswerClasses.put(label, mcCl);
            String humanansclstr = "edu.stanford.nlp.patterns.PatternsAnnotations$PatternHumanLabel" + i;
            this.humanLabelClasses.put(label, Class.forName(humanansclstr));
            ++i;
        }
    }

    public String processText(boolean writeOutputToFile) throws IOException, InstantiationException, InvocationTargetException, ExecutionException, SQLException, InterruptedException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException {
        this.logger.info("Starting to process text");
        this.logger.info("all seed words are " + this.seedWords);
        Pair<Map<String, DataInstance>, Map<String, DataInstance>> sentsPair = GetPatternsFromDataMultiClass.processSents(this.props, this.seedWords.keySet());
        Data.sents = sentsPair.first();
        ConstantsAndVariables constVars = new ConstantsAndVariables(this.props, this.seedWords.keySet(), this.machineAnswerClasses);
        for (String label : this.seedWords.keySet()) {
            GetPatternsFromDataMultiClass.runLabelSeedWords(Data.sents, this.humanLabelClasses.get(label), label, (Collection<CandidatePhrase>)this.seedWords.get(label), constVars, true);
        }
        if (writeOutputToFile) {
            GetPatternsFromDataMultiClass.writeColumnOutput(this.outputFile, false, this.humanLabelClasses);
            System.out.println("written the output to " + this.outputFile);
        }
        this.logger.info("Finished processing text");
        return "SUCCESS";
    }

    public String doRemovePhrases(String line) {
        return "not yet implemented";
    }

    public String doRemoveAnnotations(String line) {
        int tokensNum = this.changeAnnotation(line, true);
        return "SUCCESS . Labeled " + tokensNum + " tokens ";
    }

    public String doNewAnnotations(String line) {
        int tokensNum = this.changeAnnotation(line, false);
        return "SUCCESS . Labeled " + tokensNum + " tokens ";
    }

    private int changeAnnotation(String line, boolean remove) {
        int tokensNum = 0;
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(line));
        JsonObject objarr = jsonReader.readObject();
        for (String label : objarr.keySet()) {
            JsonObject obj4label = objarr.getJsonObject(label);
            for (String sentid : obj4label.keySet()) {
                JsonArray tokenArry = obj4label.getJsonArray(sentid);
                for (JsonValue tokenid : tokenArry) {
                    ++tokensNum;
                    Data.sents.get(sentid).getTokens().get(Integer.valueOf(tokenid.toString())).set(this.humanLabelClasses.get(label), remove ? this.backgroundSymbol : label);
                }
            }
        }
        return tokensNum;
    }

    public String currentSummary() {
        return "Phrases hand labeled : " + this.seedWords.toString();
    }

    public String doNewPhrases(String line) throws Exception {
        System.out.println("adding new phrases");
        ConstantsAndVariables constVars = new ConstantsAndVariables(this.props, this.humanLabelClasses.keySet(), this.humanLabelClasses);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(line));
        JsonObject objarr = jsonReader.readObject();
        for (Map.Entry o : objarr.entrySet()) {
            String label = (String)o.getKey();
            HashSet<CandidatePhrase> seed = new HashSet<CandidatePhrase>();
            JsonArray arr = objarr.getJsonArray((String)o.getKey());
            for (int i = 0; i < arr.size(); ++i) {
                String seedw = arr.getString(i);
                System.out.println("adding " + seedw + " to seed ");
                seed.add(CandidatePhrase.createOrGet(seedw));
            }
            this.seedWords.get(label).addAll(seed);
            constVars.addSeedWords(label, seed);
            GetPatternsFromDataMultiClass.runLabelSeedWords(Data.sents, this.humanLabelClasses.get(label), label, seed, constVars, false);
        }
        return "SUCCESS added new phrases";
    }
}

