/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class AnnotatorPool {
    private static Redwood.RedwoodChannels log = Redwood.channels(AnnotatorPool.class);
    private final Map<String, CachedAnnotator> factories = Generics.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String name, Properties props, Lazy<Annotator> annotator) {
        boolean newAnnotator = false;
        Map<String, CachedAnnotator> map = this.factories;
        synchronized (map) {
            CachedAnnotator oldAnnotator = this.factories.get(name);
            String newSig = PropertiesUtils.getSignature(name, props);
            if (oldAnnotator == null || !Objects.equals(oldAnnotator.signature, newSig)) {
                if (oldAnnotator != null) {
                    log.info("Replacing old annotator \"" + name + "\" with signature [" + oldAnnotator.signature + "] with new annotator with signature [" + newSig + "]");
                }
                this.factories.put(name, new CachedAnnotator(newSig, annotator));
                Optional.ofNullable(oldAnnotator).flatMap(ann -> Optional.ofNullable(ann.annotator.getIfDefined())).ifPresent(Annotator::unmount);
                newAnnotator = true;
            }
        }
        return newAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Map<String, CachedAnnotator> map = this.factories;
        synchronized (map) {
            for (Map.Entry<String, CachedAnnotator> entry : new HashSet<Map.Entry<String, CachedAnnotator>>(this.factories.entrySet())) {
                Optional.ofNullable(entry.getValue()).flatMap(ann -> Optional.ofNullable(ann.annotator.getIfDefined())).ifPresent(Annotator::unmount);
                this.factories.remove(entry.getKey());
            }
        }
    }

    public synchronized Annotator get(String name) {
        CachedAnnotator factory = this.factories.get(name);
        if (factory != null) {
            return factory.annotator.get();
        }
        throw new IllegalArgumentException("No annotator named " + name);
    }

    private static class CachedAnnotator {
        public final String signature;
        public final Lazy<Annotator> annotator;

        private CachedAnnotator(String signature, Lazy<Annotator> annotator) {
            this.signature = signature;
            this.annotator = annotator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedAnnotator that = (CachedAnnotator)o;
            return this.signature != null ? this.signature.equals(that.signature) : that.signature == null && (this.annotator != null ? this.annotator.equals(that.annotator) : that.annotator == null);
        }

        public int hashCode() {
            int result = this.signature != null ? this.signature.hashCode() : 0;
            result = 31 * result + (this.annotator != null ? this.annotator.hashCode() : 0);
            return result;
        }
    }
}

