/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.util.Lazy;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;

public class AnnotatorPoolTest
extends TestCase {
    public void testSignature() throws Exception {
        Properties props = new Properties();
        props.setProperty("sample.prop", "v1");
        AnnotatorPool pool = new AnnotatorPool();
        pool.register("sample", props, new SampleAnnotatorFactory(props));
        Annotator a1 = pool.get("sample");
        System.out.println("First annotator: " + a1);
        pool.register("sample", props, new SampleAnnotatorFactory(props));
        Annotator a2 = pool.get("sample");
        System.out.println("Second annotator: " + a2);
        Assert.assertTrue((a1 == a2 ? 1 : 0) != 0);
        props.setProperty("sample.prop", "v2");
        pool.register("sample", props, new SampleAnnotatorFactory(props));
        Annotator a3 = pool.get("sample");
        System.out.println("Third annotator: " + a3);
        Assert.assertTrue((a1 != a3 ? 1 : 0) != 0);
    }

    static class SampleAnnotatorFactory
    extends Lazy<Annotator> {
        private static final long serialVersionUID = 1L;

        public SampleAnnotatorFactory(Properties props) {
        }

        @Override
        protected Annotator compute() {
            return new Annotator(){

                @Override
                public void annotate(Annotation annotation) {
                }

                @Override
                public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
                    return Collections.emptySet();
                }

                @Override
                public Set<Class<? extends CoreAnnotation>> requires() {
                    return Collections.emptySet();
                }
            };
        }

        @Override
        protected boolean shouldGC() {
            return false;
        }
    }
}

