/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class ArabicSegmenterAnnotatorITest
extends TestCase {
    StanfordCoreNLP pipeline = null;

    public void setUp() throws Exception {
        if (this.pipeline != null) {
            return;
        }
        Properties props = new Properties();
        props.setProperty("annotators", "segment");
        props.setProperty("customAnnotatorClass.segment", "edu.stanford.nlp.pipeline.ArabicSegmenterAnnotator");
        props.setProperty("segment.model", "/u/nlp/data/arabic-segmenter/arabic-segmenter-atb+bn+arztrain.ser.gz");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public void testPipeline() {
        String query = "\u0648\u0645\u0627 \u0647\u064a \u0643\u0644\u0645\u062a\u064f\u0643 \u0627\u0644\u0645\u0641\u0636\u0644\u0629 \u0644\u0644\u062f\u0631\u0627\u0633\u0629\u061f";
        String[] expectedWords = new String[]{"\u0648", "\u0645\u0627", "\u0647\u064a", "\u0643\u0644\u0645\u0629", "\u0643", "\u0627\u0644\u0645\u0641\u0636\u0644\u0629", "\u0644", "\u0627\u0644\u062f\u0631\u0627\u0633\u0629", "?"};
        int[] expectedStartPositions = new int[]{0, 1, 4, 7, 12, 14, 22, 23, 29};
        int[] expectedEndPositions = new int[]{1, 3, 6, 11, 13, 21, 23, 29, 30};
        Annotation annotation = new Annotation(query);
        this.pipeline.annotate(annotation);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        ArabicSegmenterAnnotatorITest.assertEquals((int)expectedWords.length, (int)tokens.size());
        for (int i = 0; i < expectedWords.length; ++i) {
            ArabicSegmenterAnnotatorITest.assertEquals((String)expectedWords[i], (String)((CoreLabel)tokens.get(i)).word());
            ArabicSegmenterAnnotatorITest.assertEquals((int)expectedStartPositions[i], (int)((CoreLabel)tokens.get(i)).beginPosition());
            ArabicSegmenterAnnotatorITest.assertEquals((int)expectedEndPositions[i], (int)((CoreLabel)tokens.get(i)).endPosition());
        }
    }
}

