/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SegmenterCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import junit.framework.TestCase;

public class ChineseAnnotationPipelineITest
extends TestCase {
    AnnotationPipeline pipeline = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<ChineseAnnotationPipelineITest> clazz = ChineseAnnotationPipelineITest.class;
        synchronized (ChineseAnnotationPipelineITest.class) {
            if (this.pipeline == null) {
                this.pipeline = new StanfordCoreNLP("StanfordCoreNLP-chinese.properties");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testFullPipeline() {
        String query = "\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f";
        String[] expectedWords = new String[]{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"};
        String[] expectedCharacters = new String[]{"\u4f60", "\u9a6c", "\u4e0a", "\u56de", "\u6765", "\u5317", "\u4eac", "\u5417", "\uff1f"};
        boolean[] expectedSegs = new boolean[]{true, true, false, true, false, true, false, true, true};
        String[] expectedNer = new String[]{"O", "O", "O", "GPE", "O", "O"};
        ChineseAnnotationPipelineITest.assertEquals((int)expectedCharacters.length, (int)expectedSegs.length);
        ChineseAnnotationPipelineITest.assertEquals((int)expectedWords.length, (int)expectedNer.length);
        Annotation ann = new Annotation(query);
        this.pipeline.annotate(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        ChineseAnnotationPipelineITest.assertFalse((sentences == null ? 1 : 0) != 0);
        ChineseAnnotationPipelineITest.assertEquals((int)1, (int)sentences.size());
        List tokens = (List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class);
        ChineseAnnotationPipelineITest.assertEquals((int)expectedWords.length, (int)tokens.size());
        for (int i = 0; i < expectedWords.length; ++i) {
            ChineseAnnotationPipelineITest.assertEquals((String)expectedWords[i], (String)((CoreLabel)tokens.get(i)).word());
            ChineseAnnotationPipelineITest.assertEquals((String)expectedNer[i], (String)((CoreLabel)tokens.get(i)).ner());
        }
        List characters = (List)ann.get(SegmenterCoreAnnotations.CharactersAnnotation.class);
        ChineseAnnotationPipelineITest.assertEquals((int)expectedCharacters.length, (int)characters.size());
        for (int i = 0; i < expectedCharacters.length; ++i) {
            CoreLabel word = (CoreLabel)characters.get(i);
            ChineseAnnotationPipelineITest.assertEquals((String)expectedCharacters[i], (String)((String)word.get(CoreAnnotations.ChineseCharAnnotation.class)));
            ChineseAnnotationPipelineITest.assertEquals((String)(expectedSegs[i] ? "1" : "0"), (String)((String)word.get(CoreAnnotations.ChineseSegAnnotation.class)));
        }
    }

    public void testTwoSentences() {
        String query = "\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f\u6211\u8981\u56de\u53bb\u7f8e\u56fd\u3002";
        Annotation ann = new Annotation(query);
        this.pipeline.annotate(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        ChineseAnnotationPipelineITest.assertFalse((sentences == null ? 1 : 0) != 0);
        ChineseAnnotationPipelineITest.assertEquals((int)2, (int)sentences.size());
        String[][] expectedWords = new String[][]{{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"}, {"\u6211", "\u8981", "\u56de\u53bb", "\u7f8e\u56fd", "\u3002"}};
        int[][] expectedPositions = new int[][]{{0, 1, 3, 5, 7, 8, 9}, {9, 10, 11, 13, 15, 16}};
        for (int i = 0; i < 2; ++i) {
            List tokens = (List)((CoreMap)sentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            ChineseAnnotationPipelineITest.assertEquals((int)expectedWords[i].length, (int)tokens.size());
            for (int j = 0; j < expectedWords.length; ++j) {
                ChineseAnnotationPipelineITest.assertEquals((String)expectedWords[i][j], (String)((CoreLabel)tokens.get(j)).word());
                ChineseAnnotationPipelineITest.assertEquals((int)expectedPositions[i][j], (int)((CoreLabel)tokens.get(j)).beginPosition());
                ChineseAnnotationPipelineITest.assertEquals((int)expectedPositions[i][j + 1], (int)((CoreLabel)tokens.get(j)).endPosition());
            }
        }
    }
}

