/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class ChineseSegmenterAnnotatorITest
extends TestCase {
    StanfordCoreNLP pipeline = null;

    public void setUp() throws Exception {
        if (this.pipeline != null) {
            return;
        }
        Properties props = new Properties();
        props.setProperty("annotators", "cseg");
        props.setProperty("customAnnotatorClass.cseg", "edu.stanford.nlp.pipeline.ChineseSegmenterAnnotator");
        props.setProperty("cseg.model", "/u/nlp/data/gale/segtool/stanford-seg/classifiers-2010/05202008-ctb6.processed-chris6.lex.gz");
        props.setProperty("cseg.sighanCorporaDict", "/u/nlp/data/gale/segtool/stanford-seg/releasedata");
        props.setProperty("cseg.serDictionary", "/u/nlp/data/gale/segtool/stanford-seg/classifiers/dict-chris6.ser.gz");
        props.setProperty("cseg.sighanPostProcessing", "true");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public void testPipeline() {
        String query = "\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f";
        String[] expectedWords = new String[]{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"};
        int[] expectedPositions = new int[]{0, 1, 3, 5, 7, 8, 9};
        Annotation annotation = new Annotation(query);
        this.pipeline.annotate(annotation);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        ChineseSegmenterAnnotatorITest.assertEquals((int)expectedWords.length, (int)tokens.size());
        for (int i = 0; i < expectedWords.length; ++i) {
            ChineseSegmenterAnnotatorITest.assertEquals((String)expectedWords[i], (String)((CoreLabel)tokens.get(i)).word());
            ChineseSegmenterAnnotatorITest.assertEquals((int)expectedPositions[i], (int)((CoreLabel)tokens.get(i)).beginPosition());
            ChineseSegmenterAnnotatorITest.assertEquals((int)expectedPositions[i + 1], (int)((CoreLabel)tokens.get(i)).endPosition());
        }
    }
}

