/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.SegmenterCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class ChineseSerializationITest {
    @Test
    public void testChineseSerialization() {
        try {
            ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
            String sampleChineseDocument = "\u5df4\u62c9\u514b\u00b7\u5965\u5df4\u9a6c\u662f\u7f8e\u56fd\u603b\u7edf\u3002\u4ed6\u57282008\u5e74\u5f53\u9009";
            Properties chineseProperties = StringUtils.argsToProperties("-props", "StanfordCoreNLP-chinese.properties");
            Annotation doc = new StanfordCoreNLP(chineseProperties).process(sampleChineseDocument);
            ByteArrayOutputStream ks = new ByteArrayOutputStream();
            ((AnnotationSerializer)serializer).write(doc, ks).close();
            ByteArrayInputStream kis = new ByteArrayInputStream(ks.toByteArray());
            Pair<Annotation, InputStream> pair = ((AnnotationSerializer)serializer).read(kis);
            ((InputStream)pair.second).close();
            Annotation readDoc = (Annotation)pair.first;
            ((InputStream)kis).close();
            List docChars = (List)doc.get(SegmenterCoreAnnotations.CharactersAnnotation.class);
            List readDocChars = (List)doc.get(SegmenterCoreAnnotations.CharactersAnnotation.class);
            Assert.assertEquals((long)docChars.size(), (long)readDocChars.size());
            int numChars = docChars.size();
            for (int currChar = 0; currChar < numChars; ++currChar) {
                Assert.assertEquals(docChars.get(currChar), readDocChars.get(currChar));
            }
            String docJSON = JSONOutputter.jsonPrint(doc);
            String readDocJSON = JSONOutputter.jsonPrint(readDoc);
            Assert.assertEquals((Object)docJSON, (Object)readDocJSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

