/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class CleanXmlAnnotatorTest
extends TestCase {
    private static Annotator ptbInvertible;
    private static Annotator ptbNotInvertible;
    private static Annotator cleanXmlAllTags;
    private static Annotator cleanXmlSomeTags;
    private static Annotator cleanXmlEndSentences;
    private static Annotator cleanXmlWithFlaws;
    private static Annotator wtsSplitter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<CleanXmlAnnotatorTest> clazz = CleanXmlAnnotatorTest.class;
        synchronized (CleanXmlAnnotatorTest.class) {
            if (ptbInvertible == null) {
                ptbInvertible = new TokenizerAnnotator(false, "en", "invertible,ptb3Escaping=true");
            }
            if (ptbNotInvertible == null) {
                ptbNotInvertible = new TokenizerAnnotator(false, "en", "invertible=false,ptb3Escaping=true");
            }
            if (cleanXmlAllTags == null) {
                cleanXmlAllTags = new CleanXmlAnnotator(".*", "", "", false);
            }
            if (cleanXmlSomeTags == null) {
                cleanXmlSomeTags = new CleanXmlAnnotator("p", "", "", false);
            }
            if (cleanXmlEndSentences == null) {
                cleanXmlEndSentences = new CleanXmlAnnotator(".*", "p", "", false);
            }
            if (cleanXmlWithFlaws == null) {
                cleanXmlWithFlaws = new CleanXmlAnnotator(".*", "", "", true);
            }
            if (wtsSplitter == null) {
                wtsSplitter = new WordsToSentencesAnnotator(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Annotation annotate(String text, Annotator tokenizer, Annotator xmlRemover, Annotator splitter) {
        Annotation annotation = new Annotation(text);
        tokenizer.annotate(annotation);
        if (xmlRemover != null) {
            xmlRemover.annotate(annotation);
        }
        if (splitter != null) {
            splitter.annotate(annotation);
        }
        return annotation;
    }

    private static void checkResult(Annotation annotation, String ... gold) {
        ArrayList goldTokens = new ArrayList();
        Annotation[] goldAnnotations = new Annotation[gold.length];
        for (int i = 0; i < gold.length; ++i) {
            goldAnnotations[i] = CleanXmlAnnotatorTest.annotate(gold[i], ptbInvertible, null, null);
            goldTokens.addAll((Collection)goldAnnotations[i].get(CoreAnnotations.TokensAnnotation.class));
        }
        List annotationLabels = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (goldTokens.size() != annotationLabels.size()) {
            for (CoreLabel annotationLabel : annotationLabels) {
                System.err.print(annotationLabel.word());
                System.err.print(' ');
            }
            System.err.println();
            for (CoreLabel goldToken : goldTokens) {
                System.err.print(goldToken.word());
                System.err.print(' ');
            }
            System.err.println();
        }
        CleanXmlAnnotatorTest.assertEquals((String)"Token count mismatch (gold vs: actual)", (int)goldTokens.size(), (int)annotationLabels.size());
        for (int i = 0; i < annotationLabels.size(); ++i) {
            CleanXmlAnnotatorTest.assertEquals((String)((CoreLabel)goldTokens.get(i)).word(), (String)((CoreLabel)annotationLabels.get(i)).word());
        }
        if (annotation.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            CleanXmlAnnotatorTest.assertEquals((String)"Sentence count mismatch", (int)gold.length, (int)sentences.size());
        }
    }

    private static void checkInvert(Annotation annotation, String gold) {
        List annotationLabels = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        StringBuilder original = new StringBuilder();
        for (CoreLabel label : annotationLabels) {
            original.append((String)label.get(CoreAnnotations.BeforeAnnotation.class));
            original.append((String)label.get(CoreAnnotations.OriginalTextAnnotation.class));
        }
        original.append((String)((CoreLabel)annotationLabels.get(annotationLabels.size() - 1)).get(CoreAnnotations.AfterAnnotation.class));
        CleanXmlAnnotatorTest.assertEquals((String)gold, (String)original.toString());
    }

    private static void checkContext(CoreLabel label, String ... expectedContext) {
        List xmlContext = (List)label.get(CoreAnnotations.XmlContextAnnotation.class);
        CleanXmlAnnotatorTest.assertEquals((int)expectedContext.length, (int)xmlContext.size());
        for (int i = 0; i < expectedContext.length; ++i) {
            CleanXmlAnnotatorTest.assertEquals((String)expectedContext[i], (String)((String)xmlContext.get(i)));
        }
    }

    public void testRemoveXML() {
        String testString = "<xml>This is a test string.</xml>";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter), "This is a test string.");
    }

    public void testExtractSpecificTag() {
        String testString = "<p>This is a test string.</p><foo>This should not be found</foo>";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlSomeTags, wtsSplitter), "This is a test string.");
    }

    public void testSentenceSplitting() {
        String testString = "<p>This sentence is split</p><foo>over two tags</foo>";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter), "This sentence is split over two tags");
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlEndSentences, wtsSplitter), "This sentence is split", "over two tags");
    }

    public void testNestedTags() {
        String testString = "<p><p>This text is in a</p>nested tag</p>";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter), "This text is in a nested tag");
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlEndSentences, wtsSplitter), "This text is in a", "nested tag");
    }

    public void testMissingCloseTags() {
        String testString = "<text><p>This text <p>has closing tags wrong</text>";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlWithFlaws, wtsSplitter), "This text has closing tags wrong");
        try {
            CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter), "This text has closing tags wrong");
            throw new RuntimeException("it was supposed to barf");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testEarlyEnd() {
        String testString = "<text>This text ends before all tags closed";
        CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlWithFlaws, wtsSplitter), "This text ends before all tags closed");
        try {
            CleanXmlAnnotatorTest.checkResult(CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter), "This text ends before all tags closed");
            throw new RuntimeException("it was supposed to barf");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void testInvertible() {
        String testNoTags = "This sentence should be invertible.";
        String testTags = "  <xml>  This sentence should  be  invertible.  </xml>  ";
        String testManyTags = " <xml>   <foo>       <bar>This sentence should     </bar>be invertible.   </foo>   </xml> ";
        Annotation annotation = CleanXmlAnnotatorTest.annotate(testNoTags, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        CleanXmlAnnotatorTest.checkResult(annotation, testNoTags);
        CleanXmlAnnotatorTest.checkInvert(annotation, testNoTags);
        annotation = CleanXmlAnnotatorTest.annotate(testTags, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        CleanXmlAnnotatorTest.checkResult(annotation, testNoTags);
        CleanXmlAnnotatorTest.checkInvert(annotation, testTags);
        annotation = CleanXmlAnnotatorTest.annotate(testManyTags, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        CleanXmlAnnotatorTest.checkResult(annotation, testNoTags);
        CleanXmlAnnotatorTest.checkInvert(annotation, testManyTags);
    }

    public void testContext() {
        int i;
        String testManyTags = " <xml>   <foo>       <bar>This sentence should     </bar>be invertible.   </foo>   </xml> ";
        Annotation annotation = CleanXmlAnnotatorTest.annotate(testManyTags, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        List annotationLabels = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        for (i = 0; i < 3; ++i) {
            CleanXmlAnnotatorTest.checkContext((CoreLabel)annotationLabels.get(i), "xml", "foo", "bar");
        }
        for (i = 3; i < 5; ++i) {
            CleanXmlAnnotatorTest.checkContext((CoreLabel)annotationLabels.get(i), "xml", "foo");
        }
    }

    public void testOffsets() {
        String testString = "<p><p>This text is in a</p>nested tag</p>";
        Annotation annotation = CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        CleanXmlAnnotatorTest.checkResult(annotation, "This text is in a nested tag");
        List labels = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        CleanXmlAnnotatorTest.assertEquals((int)6, (int)((Integer)((CoreLabel)labels.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        CleanXmlAnnotatorTest.assertEquals((int)10, (int)((Integer)((CoreLabel)labels.get(0)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
    }

    public void testAttributes() {
        String testString = "<p a=\"b\">This text has an attribute</p>";
        Annotation annotation = CleanXmlAnnotatorTest.annotate(testString, ptbInvertible, cleanXmlAllTags, wtsSplitter);
        CleanXmlAnnotatorTest.checkResult(annotation, "This text has an attribute");
    }

    public void testViaCoreNlp() {
        int i;
        String testManyTags = " <xml>   <foo>       <bar>This sentence should     </bar>be invertible.   </foo>   </xml> ";
        Annotation anno = new Annotation(testManyTags);
        Properties props = PropertiesUtils.asProperties("annotators", "tokenize, ssplit, cleanxml", "tokenizer.options", "invertible,ptb3Escaping=true", "cleanxml.xmltags", ".*", "cleanxml.sentenceendingtags", "p", "cleanxml.datetags", "", "cleanxml.allowflawedxml", "false");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(anno);
        CleanXmlAnnotatorTest.checkInvert(anno, testManyTags);
        List annotationLabels = (List)anno.get(CoreAnnotations.TokensAnnotation.class);
        for (i = 0; i < 3; ++i) {
            CleanXmlAnnotatorTest.checkContext((CoreLabel)annotationLabels.get(i), "xml", "foo", "bar");
        }
        for (i = 3; i < 5; ++i) {
            CleanXmlAnnotatorTest.checkContext((CoreLabel)annotationLabels.get(i), "xml", "foo");
        }
    }
}

