/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.StringUtils;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Test;

public class CorefAnnotatorSanityITest
extends TestCase {
    public StanfordCoreNLP pipeline;
    public String englishDoc = "Barack Obama is the president of the United States. He was elected in 2008.  Over the course of the election, Obama inspired many young voters.";
    public String englishCorefResult = "(2,1,[1,2]) -> (1,2,[1,3]), that is: \"He\" -> \"Barack Obama\"\n(3,8,[8,9]) -> (1,2,[1,3]), that is: \"Obama\" -> \"Barack Obama\"";
    public String chineseDoc = "\u5df4\u62c9\u514b\u00b7\u5965\u5df4\u9a6c\u662f\u7f8e\u56fd\u603b\u7edf\u3002\u4ed6\u57282008\u5e74\u5f53\u9009";
    public String chineseCorefResult = "(2,1,[1,2]) -> (1,1,[1,2]), that is: \"\u4ed6\" -> \"\u5df4\u62c9\u514b\u00b7\u5965\u5df4\u9a6c\"";

    public String getCorefChainString(Map<Integer, CorefChain> corefChains) {
        String returnString = "";
        if (corefChains != null) {
            for (CorefChain chain : corefChains.values()) {
                CorefChain.CorefMention representative = chain.getRepresentativeMention();
                boolean outputHeading = false;
                for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                    if (mention == representative) continue;
                    String corefResultString = String.format("(%d,%d,[%d,%d]) -> (%d,%d,[%d,%d]), that is: \"%s\" -> \"%s\"%n", mention.sentNum, mention.headIndex, mention.startIndex, mention.endIndex, representative.sentNum, representative.headIndex, representative.startIndex, representative.endIndex, mention.mentionSpan, representative.mentionSpan);
                    returnString = returnString + corefResultString;
                }
            }
        }
        return returnString.trim();
    }

    @Test
    public void testStatisticalEnglishSlow() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,parse,mention,coref");
        props.setProperty("coref.algorithm", "clustering");
        props.setProperty("coref.md.type", "rule");
        this.pipeline = new StanfordCoreNLP(props);
        Annotation annotation = new Annotation(this.englishDoc);
        this.pipeline.annotate(annotation);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CorefAnnotatorSanityITest.assertEquals((String)this.getCorefChainString(corefChains), (String)this.englishCorefResult);
    }

    @Test
    public void testStatisticalEnglishFast() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,mention,coref");
        props.setProperty("coref.algorithm", "statistical");
        props.setProperty("coref.md.type", "dependency");
        this.pipeline = new StanfordCoreNLP(props);
        Annotation annotation = new Annotation(this.englishDoc);
        this.pipeline.annotate(annotation);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CorefAnnotatorSanityITest.assertEquals((String)this.getCorefChainString(corefChains), (String)this.englishCorefResult);
    }

    @Test
    public void testNeuralEnglish() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,parse,mention,coref");
        props.setProperty("coref.algorithm", "neural");
        props.setProperty("coref.md.type", "rule");
        this.pipeline = new StanfordCoreNLP(props);
        Annotation annotation = new Annotation(this.englishDoc);
        this.pipeline.annotate(annotation);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CorefAnnotatorSanityITest.assertEquals((String)this.getCorefChainString(corefChains), (String)this.englishCorefResult);
    }

    @Test
    public void testHybridChinese() {
        Properties props = StringUtils.argsToProperties("-props", "StanfordCoreNLP-chinese.properties");
        this.pipeline = new StanfordCoreNLP(props);
        Annotation annotation = new Annotation(this.chineseDoc);
        this.pipeline.annotate(annotation);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CorefAnnotatorSanityITest.assertEquals((String)this.getCorefChainString(corefChains), (String)this.chineseCorefResult);
    }

    @Test
    public void testNeuralChinese() {
        Properties props = StringUtils.argsToProperties("-props", "StanfordCoreNLP-chinese.properties");
        props.setProperty("coref.algorithm", "neural");
        props.setProperty("coref.md.liberalChineseMD", "true");
        this.pipeline = new StanfordCoreNLP(props);
        Annotation annotation = new Annotation(this.chineseDoc);
        this.pipeline.annotate(annotation);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CorefAnnotatorSanityITest.assertEquals((String)this.getCorefChainString(corefChains), (String)this.chineseCorefResult);
    }
}

