/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CustomAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;

public class CustomAnnotationSerializerITest
extends TestCase {
    static StanfordCoreNLP fullPipeline = null;
    static CustomAnnotationSerializer serializer = new CustomAnnotationSerializer(false, false);
    Class[] tokenAnnotations = new Class[]{CoreAnnotations.TextAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        Class<CustomAnnotationSerializerITest> clazz = CustomAnnotationSerializerITest.class;
        synchronized (CustomAnnotationSerializerITest.class) {
            if (fullPipeline == null) {
                fullPipeline = new StanfordCoreNLP();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testSimple() throws IOException {
        Annotation annotation = new Annotation("This is a test");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    public void testCollapsedGraphs() throws IOException {
        Annotation annotation = new Annotation("I bought a bone for my dog.");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    public void testTwoSentences() throws IOException {
        Annotation annotation = new Annotation("I bought a bone for my dog.  He chews it every day.");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    public void testCopyWordGraphs() throws IOException {
        Annotation annotation = new Annotation("I went over the river and through the woods");
        fullPipeline.annotate(annotation);
        this.runTest(annotation);
    }

    private void runTest(Annotation annotation) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        serializer.write(annotation, out2);
        byte[] serialized = out2.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(serialized);
        Annotation deserialized = serializer.read(in).first();
        CustomAnnotationSerializerITest.assertEquals((int)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size(), (int)((List)deserialized.get(CoreAnnotations.SentencesAnnotation.class)).size());
        for (int i = 0; i < ((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size(); ++i) {
            this.verifySentence((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(i), (CoreMap)((List)deserialized.get(CoreAnnotations.SentencesAnnotation.class)).get(i));
        }
    }

    private void verifySentence(CoreMap expected, CoreMap result) {
        CustomAnnotationSerializerITest.assertEquals((int)((List)expected.get(CoreAnnotations.TokensAnnotation.class)).size(), (int)((List)result.get(CoreAnnotations.TokensAnnotation.class)).size());
        for (int i = 0; i < ((List)expected.get(CoreAnnotations.TokensAnnotation.class)).size(); ++i) {
            this.verifyWord((CoreLabel)((List)expected.get(CoreAnnotations.TokensAnnotation.class)).get(i), (CoreLabel)((List)result.get(CoreAnnotations.TokensAnnotation.class)).get(i));
        }
        this.verifyTree((Tree)expected.get(TreeCoreAnnotations.TreeAnnotation.class), (Tree)result.get(TreeCoreAnnotations.TreeAnnotation.class));
        this.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
        this.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class));
        this.verifyGraph((SemanticGraph)expected.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class), (SemanticGraph)result.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
    }

    private void verifyTree(Tree expected, Tree result) {
        if (expected == null) {
            CustomAnnotationSerializerITest.assertEquals((Object)expected, (Object)result);
            return;
        }
        CustomAnnotationSerializerITest.assertEquals((String)expected.toString(), (String)result.toString());
    }

    private void verifyGraph(SemanticGraph expected, SemanticGraph result) {
        if (expected == null) {
            CustomAnnotationSerializerITest.assertEquals((Object)expected, (Object)result);
            return;
        }
        CustomAnnotationSerializerITest.assertEquals(expected.vertexSet(), result.vertexSet());
        CustomAnnotationSerializerITest.assertEquals((String)expected.toString(), (String)result.toString());
    }

    private void verifyWord(CoreLabel expected, CoreLabel result) {
        for (Class annotation : this.tokenAnnotations) {
            if (expected.get(annotation) == null && result.get(annotation) != null && "".equals(result.get(annotation))) continue;
            CustomAnnotationSerializerITest.assertEquals((String)("Different for class " + annotation), expected.get(annotation), result.get(annotation));
        }
    }
}

