/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class KBPAnnotatorBenchmark
extends TestCase {
    public HashMap<String, String> docIDToText;
    public HashMap<String, Set<String>> docIDToRelations;
    public StanfordCoreNLP pipeline;
    public String KBP_DOCS_DIR;
    public String GOLD_RELATIONS_PATH;
    public double KBP_MINIMUM_SCORE;

    public void loadGoldData() {
        File[] allFiles;
        this.docIDToText = new HashMap();
        this.docIDToRelations = new HashMap();
        List<String> goldRelationLines = IOUtils.linesFromFile(this.GOLD_RELATIONS_PATH);
        for (String relationLine : goldRelationLines) {
            String[] docIDAndRelation = relationLine.split("\t");
            if (this.docIDToRelations.get(docIDAndRelation[0]) == null) {
                this.docIDToRelations.put(docIDAndRelation[0], new HashSet());
            }
            this.docIDToRelations.get(docIDAndRelation[0]).add(docIDAndRelation[1]);
        }
        File directoryWithDocs = new File(this.KBP_DOCS_DIR);
        for (File kbpTestDocFile : allFiles = directoryWithDocs.listFiles()) {
            String kbpTestDocID = kbpTestDocFile.getName();
            String kbpTestDocPath = kbpTestDocFile.getAbsolutePath();
            String kbpTestDocContents = IOUtils.stringFromFile(kbpTestDocPath);
            this.docIDToText.put(kbpTestDocID, kbpTestDocContents);
        }
    }

    private String convertRelationName(String relationName) {
        if (relationName.equals("per:employee_of")) {
            return "per:employee_or_member_of";
        }
        if (relationName.equals("per:stateorprovinces_of_residence")) {
            return "per:statesorprovinces_of_residence";
        }
        if (relationName.equals("org:number_of_employees/members")) {
            return "org:number_of_employees_members";
        }
        if (relationName.equals("org:stateorprovince_of_headquarters")) {
            return "org:stateprovince_of_headquarters";
        }
        if (relationName.equals("per:other_family")) {
            return "per:otherfamily";
        }
        if (relationName.equals("org:founded")) {
            return "org:date_founded";
        }
        if (relationName.equals("org:political/religious_affiliation")) {
            return "org:political_religious_affiliation";
        }
        return relationName;
    }

    public Set<String> convertKBPTriplesToStrings(List<RelationTriple> relationTripleList) {
        HashSet<String> foundRelationStrings = new HashSet<String>();
        for (RelationTriple rt : relationTripleList) {
            String relationName = this.convertRelationName(rt.relationGloss());
            String relationString = relationName + "(" + rt.subjectGloss() + "," + rt.objectGloss() + ")";
            foundRelationStrings.add(relationString);
        }
        return foundRelationStrings;
    }

    public void testKBPAnnotatorResults() {
        int totalGoldRelations = 0;
        int totalCorrectFoundRelations = 0;
        int totalWrongFoundRelations = 0;
        int totalGuessRelations = 0;
        double finalF1 = 0.0;
        for (String docID : this.docIDToText.keySet()) {
            System.out.println("---");
            System.out.println(docID);
            Annotation currAnnotation = new Annotation(this.docIDToText.get(docID));
            this.pipeline.annotate(currAnnotation);
            int docGoldRelationSetSize = 0;
            if (this.docIDToRelations.get(docID) != null) {
                docGoldRelationSetSize = this.docIDToRelations.get(docID).size();
            }
            totalGoldRelations += docGoldRelationSetSize;
            ArrayList<RelationTriple> relationTriplesForThisDoc = new ArrayList<RelationTriple>();
            for (CoreMap sentence : (List)currAnnotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List rtList = (List)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class);
                for (RelationTriple rt : rtList) {
                    System.out.println("\t" + rt.toString());
                    relationTriplesForThisDoc.add(rt);
                }
            }
            Set<String> foundRelationStrings = this.convertKBPTriplesToStrings(relationTriplesForThisDoc);
            HashSet<String> intersectionOfFoundAndGold = new HashSet<String>(foundRelationStrings);
            if (this.docIDToRelations.get(docID) != null) {
                intersectionOfFoundAndGold.retainAll((Collection)this.docIDToRelations.get(docID));
                totalCorrectFoundRelations += intersectionOfFoundAndGold.size();
                totalWrongFoundRelations += foundRelationStrings.size() - intersectionOfFoundAndGold.size();
            } else {
                totalWrongFoundRelations += foundRelationStrings.size();
            }
            System.out.println("curr score: ");
            double recall = (double)totalCorrectFoundRelations / (double)totalGoldRelations;
            double precision = (double)totalCorrectFoundRelations / (double)(totalGuessRelations += foundRelationStrings.size());
            System.out.println("\trecall: " + recall);
            System.out.println("\tprecision: " + precision);
            double f1 = 2.0 * (precision * recall) / (precision + recall);
            System.out.println("\tf1: " + f1);
            finalF1 = f1;
        }
        KBPAnnotatorBenchmark.assertTrue((String)("f1 score: " + finalF1 + " is below threshold of " + this.KBP_MINIMUM_SCORE), (finalF1 >= this.KBP_MINIMUM_SCORE ? 1 : 0) != 0);
    }
}

