/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class NumberAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(NumberAnnotator.class);
    private final AbstractSequenceClassifier<CoreLabel> nsc;
    private boolean VERBOSE = true;
    private static final String DEFAULT_BACKGROUND_SYMBOL = "O";
    private final String BACKGROUND_SYMBOL;
    public static final String BACKGROUND_SYMBOL_PROPERTY = "background";

    public NumberAnnotator() {
        this(DEFAULT_BACKGROUND_SYMBOL, true, NumberSequenceClassifier.USE_SUTIME_DEFAULT);
    }

    public NumberAnnotator(boolean verbose) {
        this(DEFAULT_BACKGROUND_SYMBOL, verbose, NumberSequenceClassifier.USE_SUTIME_DEFAULT);
    }

    public NumberAnnotator(boolean verbose, boolean useSUTime) {
        this(DEFAULT_BACKGROUND_SYMBOL, verbose, useSUTime);
    }

    public NumberAnnotator(String backgroundSymbol, boolean verbose, boolean useSUTime) {
        this.BACKGROUND_SYMBOL = backgroundSymbol;
        this.VERBOSE = verbose;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    public NumberAnnotator(String name, Properties props) {
        String property = name + "." + BACKGROUND_SYMBOL_PROPERTY;
        this.BACKGROUND_SYMBOL = props.getProperty(property, DEFAULT_BACKGROUND_SYMBOL);
        boolean useSUTime = PropertiesUtils.getBool(props, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        this.VERBOSE = false;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            log.info("Adding number annotation ... ");
        }
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                this.doOneSentenceNew(tokens, annotation, sentence);
            }
            if (this.VERBOSE) {
                log.info("done. Output: " + annotation.get(CoreAnnotations.SentencesAnnotation.class));
            }
        } else if (annotation.containsKey(CoreAnnotations.TokensAnnotation.class)) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            this.doOneSentenceNew(tokens, annotation, null);
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void doOneSentenceNew(List<CoreLabel> words, Annotation doc, CoreMap sentence) {
        List<CoreLabel> newWords = NumberSequenceClassifier.copyTokens(words, sentence);
        this.nsc.classifyWithGlobalInformation(newWords, doc, sentence);
        Iterator<CoreLabel> newFLIter = newWords.iterator();
        for (CoreLabel origWord : words) {
            CoreLabel newWord = newFLIter.next();
            String before = origWord.ner();
            String newGuess = (String)newWord.get(CoreAnnotations.AnswerAnnotation.class);
            if (this.VERBOSE) {
                log.info(newWord);
            }
            if ((before == null || before.equals(this.BACKGROUND_SYMBOL) || before.equals("MISC")) && !newGuess.equals(this.BACKGROUND_SYMBOL)) {
                origWord.setNER(newGuess);
            }
            NumberSequenceClassifier.transferAnnotations(newWord, origWord);
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.NumerizedTokensAnnotation.class);
    }
}

