/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;

public class QuoteAnnotatorTest
extends TestCase {
    private static StanfordCoreNLP pipeline;
    private static StanfordCoreNLP pipelineNoSingleQuotes;
    private static StanfordCoreNLP pipelineMaxFive;
    private static StanfordCoreNLP pipelineAsciiQuotes;
    private static StanfordCoreNLP pipelineAllowEmbeddedSame;
    private static StanfordCoreNLP pipelineUnclosedQuotes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        Class<QuoteAnnotatorTest> clazz = QuoteAnnotatorTest.class;
        synchronized (QuoteAnnotatorTest.class) {
            Properties props;
            if (pipeline == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote1");
                props.setProperty("customAnnotatorClass.quote1", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("singleQuotes", "true");
                pipeline = new StanfordCoreNLP(props);
            }
            if (pipelineNoSingleQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote2");
                props.setProperty("customAnnotatorClass.quote2", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                pipelineNoSingleQuotes = new StanfordCoreNLP(props);
            }
            if (pipelineMaxFive == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote3");
                props.setProperty("customAnnotatorClass.quote3", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("maxLength", "5");
                pipelineMaxFive = new StanfordCoreNLP(props);
            }
            if (pipelineAsciiQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote4");
                props.setProperty("customAnnotatorClass.quote4", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("asciiQuotes", "true");
                pipelineAsciiQuotes = new StanfordCoreNLP(props);
            }
            if (pipelineAllowEmbeddedSame == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote5");
                props.setProperty("customAnnotatorClass.quote5", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("allowEmbeddedSame", "true");
                pipelineAllowEmbeddedSame = new StanfordCoreNLP(props);
            }
            if (pipelineUnclosedQuotes == null) {
                props = new Properties();
                props.setProperty("annotators", "tokenize, ssplit, quote6");
                props.setProperty("customAnnotatorClass.quote6", "edu.stanford.nlp.pipeline.QuoteAnnotator");
                props.setProperty("extractUnclosedQuotes", "true");
                pipelineUnclosedQuotes = new StanfordCoreNLP(props);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testBasicEmbeddedSameUnicode() {
        String text = "\u201cHello,\u201d he said, \u201chow \u201care\u201d you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipeline);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow \u201care\u201d you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(1).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorTest.assertEquals((int)embedded.size(), (int)0);
    }

    public void testBasicAllowEmbeddedSameUnicode() {
        String text = "\u201cHello,\u201d he said, \u201chow \u201care\u201d you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow \u201care\u201d you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("\u201care\u201d", "\u201chow \u201care\u201d you doing?\u201d", quotes);
    }

    public void testBasicAsciiQuotes() {
        String text = "\u201cHello,\u201c he said, \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAsciiQuotes);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201c", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMaxLength() {
        String text = "`Hel,' he said, ``how are \"you\" blar a \"farrrrrooom\"";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineMaxFive);
        QuoteAnnotatorTest.assertEquals((String)"`Hel,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\"you\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testTis() {
        String text = "\"'Tis Impossible, \u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d, impossible, when 'tis I am not acquainted with him\n myself; how can you be so teasing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("\u201cMr. Bennet\u201d", "\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", quotes);
        QuoteAnnotatorTest.assertEmbedded("\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", text, quotes);
    }

    public void testDashes() {
        String text = "\"Hello\"--said Mr. Cornwallaby";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        text = "\u201c-Wish- you success!\u201d\u2014In what";
        quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\u201c-Wish- you success!\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        text = "\"-Wish- you success!\"\u2014In what";
        quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"-Wish- you success!\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicInternalPunc() {
        String text = "\"Impossible, Mr. Bennet, impossible, when I am not acquainted with him\n myself; how can you be so teasing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 24);
    }

    public void testBasicLatexQuotes() {
        String text = "`Hello,' he said, ``how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"`Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"``how are you doing?''", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 3);
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(1), 1, 0, 0, 7, 13);
    }

    public void testLatexQuotesWithDirectedApostrophes() {
        String text = "John`s he said, ``how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"``how are you doing?''", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testEmbeddedLatexQuotes() {
        String text = "``Hello ``how are you doing?''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("``how are you doing?''", text, quotes);
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 9);
    }

    public void testEmbeddedLatexQuotesNoEmbedded() {
        String text = "``Hello ``how are you doing?''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipeline);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorTest.assertEquals((int)0, (int)embedded.size());
    }

    public void testEmbeddedSingleLatexQuotes() {
        String text = "`Hello `how are you doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("`how are you doing?'", text, quotes);
    }

    public void testEmbeddedLatexQuotesAllEndSamePlace() {
        String text = "``Hello ``how `are ``you doing?'''''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("``how `are ``you doing?'''''", text, quotes);
        QuoteAnnotatorTest.assertEmbedded("`are ``you doing?'''", "``how `are ``you doing?'''''", quotes);
        QuoteAnnotatorTest.assertEmbedded("``you doing?''", "`are ``you doing?'''", quotes);
    }

    public void testEmbeddedLatexQuotesAllEndSamePlaceNoEmbedded() {
        String text = "``Hello ``how ``are ``you doing?''''''''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipeline);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorTest.assertEquals((int)0, (int)embedded.size());
    }

    public void testTripleEmbeddedLatexQuotes() {
        String text = "``Hel ``lo ``how'' are you'' doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("``lo ``how'' are you''", text, quotes);
        QuoteAnnotatorTest.assertEmbedded("``how''", "``lo ``how'' are you''", quotes);
    }

    public void testTripleEmbeddedLatexQuotesNoEmbedded() {
        String text = "``Hel ``lo ``how'' are you'' doing?''";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineNoSingleQuotes);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        List embedded = (List)quotes.get(0).get(CoreAnnotations.QuotationsAnnotation.class);
        QuoteAnnotatorTest.assertEquals((int)0, (int)embedded.size());
    }

    public void testTripleEmbeddedUnicodeQuotes() {
        String text = "\u201cHel \u00ablo \u201chow\u201d are you\u00bb doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("\u00ablo \u201chow\u201d are you\u00bb", text, quotes);
        QuoteAnnotatorTest.assertEmbedded("\u201chow\u201d", "\u00ablo \u201chow\u201d are you\u00bb", quotes);
    }

    public void testBasicIgnoreSingleQuotes() {
        String text = "\u201cHello,\u201d he 'said', \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        text = "\"'Tis Impossible, \u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d, impossible, when 'tis I am not acquainted with him\n myself; how can you be so teasing?\"";
        quotes = this.runQuotes(text, 1, pipelineAllowEmbeddedSame);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("\u201cMr. Bennet\u201d", "\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", quotes);
        QuoteAnnotatorTest.assertEmbedded("\u201cMr. 'tis \u201cMr. Bennet\u201d Bennet\u201d", text, quotes);
    }

    public void testBasicUnicodeQuotes() {
        String text = "\u201cHello,\u201d he said, \u201chow are you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow are you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnicodeQuotesWithBadUnicodeQuotes() {
        String text = "\u201cHello,\u201d he said, \u201chow\u201a are\u2018 you doing?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201chow\u201a are\u2018 you doing?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnicodeQuotesWithApostrophes() {
        String text = "\u201cHello,\u201d he said, \u201cwhere is the dog\u2018s ball today?\u201d";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"\u201cHello,\u201d", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\u201cwhere is the dog\u2018s ball today?\u201d", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicDoubleQuotes() {
        String text = "\"Hello,\" he said, \"how are you doing?\"";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((int)((List)quotes.get(0).get(CoreAnnotations.TokensAnnotation.class)).size(), (int)4);
        QuoteAnnotatorTest.assertEquals((String)"\"how are you doing?\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedInitialQuotes() {
        String text = "Hello,   \" he said, 'how are you doing?'";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"'how are you doing?'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastDoubleQuotes() {
        String text = "\"Hello,\" he said, \"how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testDoubleEnclosedInSingle() {
        String text = "'\"Hello,\" he said, \"how are you doing?\"'";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"'\"Hello,\" he said, \"how are you doing?\"'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("\"Hello,\"", text, quotes);
        QuoteAnnotatorTest.assertEmbedded("\"how are you doing?\"", text, quotes);
    }

    public void testSingleEnclosedInDouble() {
        String text = "\"'Hello,' he said, 'how are you doing?'\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)text, (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEmbedded("'Hello,'", text, quotes);
        QuoteAnnotatorTest.assertEmbedded("'how are you doing?'", text, quotes);
    }

    public void testEmbeddedQuotes() {
        String text = "\"'Enter,' said De Lacy; 'and I will\n\ntry in what manner I can relieve your\n\nwants; but, unfortunately, my children\n\nare from home, and, as I am blind, I\n\nam afraid I shall find it difficult to procure\n\nfood for you.'\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEmbedded("'Enter,'", text, quotes);
        String second = "'and I will\n\ntry in what manner I can relieve your\n\nwants; but, unfortunately, my children\n\nare from home, and, as I am blind, I\n\nam afraid I shall find it difficult to procure\n\nfood for you.'";
        QuoteAnnotatorTest.assertEmbedded(second, text, quotes);
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 0, 55);
    }

    public void testEmbeddedQuotesTwo() {
        String text = "It was all very well to say 'Drink me,' but the wise little Alice was\nnot going to do THAT in a hurry. 'No, I'll \"look\" first,' she said, 'and\nsee whether it's marked \"poison\" or not';";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorTest.assertEmbedded("\"poison\"", "'and\nsee whether it's marked \"poison\" or not'", quotes);
        QuoteAnnotatorTest.assertEmbedded("\"look\"", "'No, I'll \"look\" first,'", quotes);
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 0, 7, 11);
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(1), 1, 1, 1, 27, 37);
    }

    public void testEmbeddedMixedComplicated() {
        String text = "It was all very \u300cwell to say `Drink me,' but the wise little Alice was\nnot going to do THAT in a hurry. \u2018No, I'll \"look\" first,\u2019 she said, \u00aband\nsee whether it's marked ``poison'' or \"not\u00bb";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorTest.assertEmbedded("``poison''", "\u00aband\nsee whether it's marked ``poison'' or \"not\u00bb", quotes);
        QuoteAnnotatorTest.assertEmbedded("\"look\"", "\u2018No, I'll \"look\" first,\u2019", quotes);
    }

    public void testQuotesFollowEachother() {
        String text = "\"Where?\"\n\n\"I don't see 'im!\"\n\n\"Bigger, he's behind the trunk!\" the girl whimpered.";
        List<CoreMap> quotes = this.runQuotes(text, 3);
        QuoteAnnotatorTest.assertEquals((String)"\"Where?\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\"I don't see 'im!\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\"Bigger, he's behind the trunk!\"", (String)((String)quotes.get(2).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testBasicSingleQuotes() {
        String text = "'Hello,' he said, 'how are you doing?'";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"'Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"'how are you doing?'", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastSingleQuotes() {
        String text = "'Hello,' he said, 'how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"'Hello,'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiParagraphQuoteDouble() {
        String text = "Words blah bla \"Hello,\n\n \"I am the second paragraph.\n\n\"I am the last.\" followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello,\n\n \"I am the second paragraph.\n\n\"I am the last.\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiParagraphQuoteSingle() {
        String text = "Words blah bla 'Hello,\n\n 'I am the second paragraph.\n\n'I am the second to last.\n\n'see there's more here.' followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"'Hello,\n\n 'I am the second paragraph.\n\n'I am the second to last.\n\n'see there's more here.'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertInnerAnnotationValues(quotes.get(0), 0, 0, 2, 3, 28);
    }

    public void testMultiLineQuoteDouble() {
        String text = "Words blah bla \"Hello,\nI am the second paragraph.\nI am the last.\" followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello,\nI am the second paragraph.\nI am the last.\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testMultiLineQuoteSingle() {
        String text = "Words blah bla 'Hello,\nI am the second paragraph.\nI am the last.' followed by more words";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"'Hello,\nI am the second paragraph.\nI am the last.'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordBeginningWithApostropheAtQuoteBeginningSingleQuotes() {
        String text = "''Tis nobler' Words blah bla 'I went to the house yesterday,' he said";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"''Tis nobler'", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"'I went to the house yesterday,'", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordsWithApostropheTerminalsInOneDoubleQuote() {
        String text = "\"Jones' cow is cuter!\"";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        QuoteAnnotatorTest.assertEquals((String)"\"Jones' cow is cuter!\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testWordsWithApostropheTerminalsInDoubleQuotes() {
        String text = "\"I said that Jones' cow was better,\" but then he rebutted. I was shocked--\"My cow is better than any one of Jones' bovines!\"";
        List<CoreMap> quotes = this.runQuotes(text, 2);
        QuoteAnnotatorTest.assertEquals((String)"\"I said that Jones' cow was better,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\"My cow is better than any one of Jones' bovines!\"", (String)((String)quotes.get(1).get(CoreAnnotations.TextAnnotation.class)));
    }

    public void testUnclosedLastDoubleQuotesUnclosedAnnotation() {
        String text = "\"Hello,\" he said, \"how are you doing?";
        List<CoreMap> quotes = this.runQuotes(text, 1);
        List<CoreMap> unclosedQuotes = this.runUnclosedQuotes(text, 1, pipelineUnclosedQuotes);
        QuoteAnnotatorTest.assertEquals((String)"\"Hello,\"", (String)((String)quotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
        QuoteAnnotatorTest.assertEquals((String)"\"how are you doing?", (String)((String)unclosedQuotes.get(0).get(CoreAnnotations.TextAnnotation.class)));
    }

    public List<CoreMap> runQuotes(String text, int numQuotes) {
        return this.runQuotes(text, numQuotes, pipeline);
    }

    public List<CoreMap> runQuotes(String text, int numQuotes, StanfordCoreNLP pipeline) {
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        Assert.assertNotNull((Object)quotes);
        Assert.assertEquals((long)numQuotes, (long)quotes.size());
        return quotes;
    }

    public static void assertInnerAnnotationValues(CoreMap quote, int quoteIndex, int sentenceBegin, int sentenceEnd, int tokenBegin, int tokenEnd) {
        QuoteAnnotatorTest.assertEquals((int)((Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class)), (int)quoteIndex);
        QuoteAnnotatorTest.assertEquals((int)((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class)), (int)sentenceBegin);
        QuoteAnnotatorTest.assertEquals((int)((Integer)quote.get(CoreAnnotations.SentenceEndAnnotation.class)), (int)sentenceEnd);
        QuoteAnnotatorTest.assertEquals((int)((Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class)), (int)tokenBegin);
        QuoteAnnotatorTest.assertEquals((int)((Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class)), (int)tokenEnd);
        List quoteTokens = (List)quote.get(CoreAnnotations.TokensAnnotation.class);
        if (quoteTokens != null && quote.get(CoreAnnotations.QuotationsAnnotation.class) == null) {
            for (CoreLabel qt : quoteTokens) {
                QuoteAnnotatorTest.assertEquals((int)((Integer)qt.get(CoreAnnotations.QuotationIndexAnnotation.class)), (int)quoteIndex);
            }
        }
    }

    public static void assertEmbedded(String embedded, String bed, List<CoreMap> quotes) {
        boolean found = QuoteAnnotatorTest.assertEmbeddedHelper(embedded, bed, quotes);
        QuoteAnnotatorTest.assertTrue((boolean)found);
    }

    public static boolean assertEmbeddedHelper(String embedded, String bed, List<CoreMap> quotes) {
        for (CoreMap b : quotes) {
            if (((String)b.get(CoreAnnotations.TextAnnotation.class)).equals(bed)) {
                List eqs = (List)b.get(CoreAnnotations.QuotationsAnnotation.class);
                for (CoreMap eq : eqs) {
                    if (!((String)eq.get(CoreAnnotations.TextAnnotation.class)).equals(embedded)) continue;
                    return true;
                }
                continue;
            }
            List bEmbed = (List)b.get(CoreAnnotations.QuotationsAnnotation.class);
            boolean recurse = QuoteAnnotatorTest.assertEmbeddedHelper(embedded, bed, bEmbed);
            if (!recurse) continue;
            return true;
        }
        return false;
    }

    public List<CoreMap> runUnclosedQuotes(String text, int numQuotes, StanfordCoreNLP pipeline) {
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        List quotes = (List)doc.get(CoreAnnotations.UnclosedQuotationsAnnotation.class);
        Assert.assertNotNull((Object)quotes);
        Assert.assertEquals((long)numQuotes, (long)quotes.size());
        return quotes;
    }
}

