/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.RegexNERAnnotator;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class RegexNERAnnotatorITest
extends TestCase {
    private static final String MAPPING = "/u/nlp/data/TAC-KBP2010/sentence_extraction/itest_map";
    private static RegexNERAnnotator annotator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<RegexNERAnnotator> clazz = RegexNERAnnotator.class;
        synchronized (RegexNERAnnotator.class) {
            if (annotator == null) {
                annotator = new RegexNERAnnotator(MAPPING, false, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void checkTags(List<CoreLabel> tokens, String ... tags) {
        RegexNERAnnotatorITest.assertEquals((int)tags.length, (int)tokens.size());
        for (int i = 0; i < tags.length; ++i) {
            RegexNERAnnotatorITest.assertEquals((String)("Mismatch for token " + i + " " + tokens.get(i)), (String)tags[i], (String)((String)tokens.get(i).get(CoreAnnotations.NamedEntityTagAnnotation.class)));
        }
    }

    public void testBasicMatching() {
        String str = "President Barack Obama lives in Chicago , Illinois , and is a practicing Christian .";
        String[] split = str.split(" ");
        List<CoreLabel> tokens = SentenceUtils.toCoreLabelList(split);
        tokens.get(1).set(CoreAnnotations.NamedEntityTagAnnotation.class, "PERSON");
        tokens.get(2).set(CoreAnnotations.NamedEntityTagAnnotation.class, "PERSON");
        tokens.get(5).set(CoreAnnotations.NamedEntityTagAnnotation.class, "LOCATION");
        tokens.get(7).set(CoreAnnotations.NamedEntityTagAnnotation.class, "LOCATION");
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(sentence);
        Annotation corpus = new Annotation("President Barack Obama lives in Chicago, Illinois,and is a practicing Christian.");
        corpus.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        annotator.annotate(corpus);
        RegexNERAnnotatorITest.checkTags(tokens, "TITLE", "PERSON", "PERSON", "O", "O", "LOCATION", "O", "STATE_OR_PROVINCE", "O", "O", "O", "O", "O", "IDEOLOGY", "O");
    }

    public void testOverwrite() {
        String str = "I like Ontario Place , and I like the Native American Church , too .";
        String[] split = str.split(" ");
        List<CoreLabel> tokens = SentenceUtils.toCoreLabelList(split);
        tokens.get(2).set(CoreAnnotations.NamedEntityTagAnnotation.class, "LOCATION");
        tokens.get(3).set(CoreAnnotations.NamedEntityTagAnnotation.class, "LOCATION");
        tokens.get(9).set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORGANIZATION");
        tokens.get(10).set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORGANIZATION");
        tokens.get(11).set(CoreAnnotations.NamedEntityTagAnnotation.class, "ORGANIZATION");
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(sentence);
        Annotation corpus = new Annotation("I like Ontario Place, and I like the NativeAmerican Church, too.");
        corpus.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        annotator.annotate(corpus);
        RegexNERAnnotatorITest.checkTags(tokens, "O", "O", "LOCATION", "LOCATION", "O", "O", "O", "O", "O", "RELIGION", "RELIGION", "RELIGION", "O", "O", "O");
    }

    public void testPriority() {
        String str = "Christianity is of higher regex priority than Early Christianity . ";
        String[] split = str.split(" ");
        List<CoreLabel> tokens = SentenceUtils.toCoreLabelList(split);
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(sentence);
        Annotation corpus = new Annotation("Christianity is of higher regex priority than Early Christianity. ");
        corpus.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        annotator.annotate(corpus);
        RegexNERAnnotatorITest.checkTags(tokens, "RELIGION", "O", "O", "O", "O", "O", "O", "O", "RELIGION", "O");
    }

    public void testEmptyAnnotation() {
        try {
            annotator.annotate(new Annotation(""));
        }
        catch (RuntimeException e) {
            return;
        }
        RegexNERAnnotatorITest.fail((String)"Never expected to get this far... the annotator should have thrown an exception by now");
    }
}

