/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.machinereading.BasicRelationExtractor;
import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.domains.roth.RothCONLL04Reader;
import edu.stanford.nlp.ie.machinereading.domains.roth.RothEntityExtractor;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RelationExtractorAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(RelationExtractorAnnotator.class);
    MachineReading mr;
    private static boolean verbose = false;

    public RelationExtractorAnnotator(Properties props) {
        verbose = Boolean.parseBoolean(props.getProperty("sup.relation.verbose", "false"));
        String relationModel = props.getProperty("sup.relation.model", "edu/stanford/nlp/models/supervised_relation_extractor/roth_relation_model_pipelineNER.ser");
        try {
            RothEntityExtractor entityExtractor = new RothEntityExtractor();
            BasicRelationExtractor relationExtractor = BasicRelationExtractor.load(relationModel);
            log.info("Loading relation model from " + relationModel);
            this.mr = MachineReading.makeMachineReadingForAnnotation(new RothCONLL04Reader(), entityExtractor, relationExtractor, null, null, null, true, verbose);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        Annotation output = this.mr.annotate(annotation);
        List outputSentences = (List)output.get(CoreAnnotations.SentencesAnnotation.class);
        List origSentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < outputSentences.size(); ++i) {
            CoreMap outSent = (CoreMap)outputSentences.get(i);
            CoreMap origSent = (CoreMap)origSentences.get(i);
            List entities = (List)outSent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            origSent.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, entities);
            if (verbose && entities != null) {
                log.info("Extracted the following entities:");
                for (EntityMention e : entities) {
                    log.info("\t" + e);
                }
            }
            List relations = (List)outSent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
            origSent.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, relations);
            if (!verbose || relations == null) continue;
            log.info("Extracted the following relations:");
            for (RelationMention r : relations) {
                if (r.getType().equals("_NR")) continue;
                log.info(r);
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(MachineReadingAnnotations.EntityMentionsAnnotation.class, MachineReadingAnnotations.RelationMentionsAnnotation.class)));
    }

    public static void main(String[] args) {
        try {
            Properties props = StringUtils.argsToProperties(args);
            props.setProperty("annotators", "tokenize,ssplit,lemma,pos,parse,ner");
            StanfordCoreNLP pipeline = new StanfordCoreNLP();
            String sentence = "Barack Obama lives in America. Obama works for the Federal Goverment.";
            Annotation doc = new Annotation(sentence);
            pipeline.annotate(doc);
            RelationExtractorAnnotator r = new RelationExtractorAnnotator(props);
            r.annotate(doc);
            for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                System.out.println("For sentence " + (String)s.get(CoreAnnotations.TextAnnotation.class));
                List rls = (List)s.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                for (RelationMention rl : rls) {
                    System.out.println(rl.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

