/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class RequirementsCorrectSlowITest {
    private String dummyString = "Joe said his car would be fixed on June 7, 1987  after 2 hours of work. He also said this document is nonsense. Joe was born in Hawaii.";

    private void testAnnotatorSequence(final List<String> annotators) {
        HashSet keysRead = new HashSet();
        ArrayCoreMap.listener = keysRead::add;
        Annotation ann = new Annotation(this.dummyString);
        for (int annotatorI = 0; annotatorI < annotators.size(); ++annotatorI) {
            keysRead.clear();
            final String annotatorName = annotators.get(annotatorI);
            System.err.println("Running " + annotatorName);
            StanfordCoreNLP corenlp = new StanfordCoreNLP(new Properties(){
                {
                    this.setProperty("annotators", annotatorName);
                    this.setProperty("enforceRequirements", "false");
                }
            });
            corenlp.annotate(ann);
            Annotator annotator = StanfordCoreNLP.getExistingAnnotator(annotatorName);
            Assert.assertNotNull((Object)annotator);
            Set<Class<? extends CoreAnnotation>> declared = annotator.requires();
            HashSet used = new HashSet(keysRead);
            used.removeAll(annotator.requirementsSatisfied());
            if (annotatorI <= 0) continue;
            if (!declared.equals(used)) {
                System.err.println("ANNOTATOR " + annotatorName);
                System.err.println("Used but not declared:");
                for (Class<? extends CoreAnnotation> key : CollectionUtils.diffAsSet(used, declared)) {
                    System.err.println("  " + key);
                }
                System.err.println("Declared but not Used:");
                for (Class<? extends CoreAnnotation> key : CollectionUtils.diffAsSet(declared, used)) {
                    System.err.println("  " + key);
                }
            }
            Assert.assertEquals(declared, used);
        }
        StanfordCoreNLP corenlp = new StanfordCoreNLP(new Properties(){
            {
                this.setProperty("annotators", StringUtils.join(annotators, ","));
            }
        });
        corenlp.annotate(ann);
    }

    @Test
    public void testDepparsePipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "depparse"));
    }

    @Test
    public void testQuotePipeline() {
        this.testAnnotatorSequence(Arrays.asList("quote"));
    }

    @Test
    public void testOpenIEPipeline() {
        this.testAnnotatorSequence(Arrays.asList("tokenize", "ssplit", "pos", "lemma", "depparse", "natlog", "openie"));
    }

    @Test
    public void testMentionRegression() {
        this.testAnnotatorSequence(Arrays.asList(new String[0]));
    }
}

