/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.sentiment.CollapseUnaryTransformer;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCostAndGradient;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SentimentAnnotator
implements Annotator {
    private static final String DEFAULT_MODEL = "edu/stanford/nlp/models/sentiment/sentiment.ser.gz";
    private final String modelPath;
    private final SentimentModel model;
    private final CollapseUnaryTransformer transformer = new CollapseUnaryTransformer();

    public SentimentAnnotator(String name, Properties props) {
        this.modelPath = props.getProperty(name + ".model", DEFAULT_MODEL);
        if (this.modelPath == null) {
            throw new IllegalArgumentException("No model specified for Sentiment annotator");
        }
        this.model = SentimentModel.loadSerialized(this.modelPath);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, TreeCoreAnnotations.BinarizedTreeAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (CoreMap sentence : sentences) {
                IntPair p;
                Tree binarized = (Tree)sentence.get(TreeCoreAnnotations.BinarizedTreeAnnotation.class);
                if (binarized == null) {
                    throw new AssertionError((Object)"Binarized sentences not built by parser");
                }
                Tree collapsedUnary = this.transformer.transformTree(binarized);
                SentimentCostAndGradient scorer = new SentimentCostAndGradient(this.model, null);
                scorer.forwardPropagateTree(collapsedUnary);
                sentence.set(SentimentCoreAnnotations.SentimentAnnotatedTree.class, collapsedUnary);
                int sentiment = RNNCoreAnnotations.getPredictedClass(collapsedUnary);
                sentence.set(SentimentCoreAnnotations.SentimentClass.class, SentimentUtils.sentimentString(this.model, sentiment));
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                if (tree == null) continue;
                collapsedUnary.setSpans();
                Map<IntPair, String> spanSentiment = Generics.newHashMap();
                for (Tree bt : collapsedUnary) {
                    p = bt.getSpan();
                    int sen = RNNCoreAnnotations.getPredictedClass(bt);
                    String sentStr = SentimentUtils.sentimentString(this.model, sen);
                    if (spanSentiment.containsKey(p)) continue;
                    spanSentiment.put(p, sentStr);
                }
                if (((CoreLabel)tree.label()).containsKey(CoreAnnotations.SpanAnnotation.class)) {
                    throw new IllegalStateException("This code assumes you don't have SpanAnnotation");
                }
                tree.setSpans();
                for (Tree t : tree) {
                    p = t.getSpan();
                    String str = (String)spanSentiment.get(p);
                    if (str == null) continue;
                    CoreLabel cl = (CoreLabel)t.label();
                    cl.set(SentimentCoreAnnotations.SentimentClass.class, str);
                    cl.remove(CoreAnnotations.SpanAnnotation.class);
                }
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }
}

