/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;

public class StanfordCoreNLPITest
extends TestCase {
    public void testRequires() throws Exception {
        Properties props = new Properties();
        try {
            props.setProperty("annotators", "tokenize,ssplit,lemma,pos,ner,parse");
            new StanfordCoreNLP(props);
            throw new RuntimeException("Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            props.setProperty("annotators", "tokenize,ssplit,parse,lemma,ner");
            new StanfordCoreNLP(props);
            return;
        }
    }

    public void testRequiresForCoref() throws Exception {
        Properties props = new Properties();
        try {
            props.setProperty("annotators", "tokenize,ssplit,lemma,pos,ner,coref");
            new StanfordCoreNLP(props);
            throw new RuntimeException("Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            props.setProperty("annotators", "tokenize,ssplit,parse,lemma,ner");
            new StanfordCoreNLP(props);
            return;
        }
    }

    public void test() throws Exception {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,parse");
        String text = "Dan Ramage is working for\nMicrosoft. He's in Seattle! \n";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((long)12L, (long)tokens.size());
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((long)2L, (long)sentences.size());
        for (CoreMap sentence : sentences) {
            List sentenceTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            Assert.assertNotNull((Object)sentenceTokens);
            for (CoreLabel token : sentenceTokens) {
                Assert.assertNotNull(token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
                Assert.assertNotNull(token.get(CoreAnnotations.LemmaAnnotation.class));
                Assert.assertNotNull(token.get(CoreAnnotations.NamedEntityTagAnnotation.class));
            }
            Assert.assertNotNull(sentence.get(TreeCoreAnnotations.TreeAnnotation.class));
            SemanticGraph deps = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
            for (IndexedWord vertex : deps.vertexSet()) {
                Assert.assertNotNull((Object)vertex.word());
                Assert.assertEquals((Object)vertex.word(), (Object)vertex.value());
            }
        }
        StringWriter stringWriter = new StringWriter();
        pipeline.prettyPrint(document, new PrintWriter(stringWriter));
        String result = stringWriter.getBuffer().toString();
        Assert.assertTrue((String)("Tokens are wrong in " + result), (boolean)StringUtils.find(result, "\\[Text=Dan .*PartOfSpeech=NNP Lemma=Dan NamedEntityTag=PERSON\\]"));
        Assert.assertTrue((String)("Parses are wrong in " + result), (boolean)result.contains("(NP (PRP He))"));
        Assert.assertTrue((String)("Parses are wrong in " + result), (boolean)result.contains("(VP (VBZ 's)"));
        Assert.assertTrue((String)("Sentence header is wrong in " + result), (boolean)result.contains("Sentence #1 (7 tokens)"));
        Assert.assertTrue((String)("Dependencies are wrong in " + result), (boolean)result.contains("nsubj(working-4, Ramage-2)"));
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        pipeline.xmlPrint(document, os);
        result = new String(os.toByteArray(), "UTF-8");
        Assert.assertTrue((String)("XML header is wrong in " + result), (boolean)result.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assert.assertTrue((String)("XML root is wrong in " + result), (boolean)result.contains("<?xml-stylesheet href=\"CoreNLP-to-HTML.xsl\" type=\"text/xsl\"?>"));
        Assert.assertTrue((String)("XML word info is wrong in " + result), (boolean)StringUtils.find(result, "<token id=\"2\">\\s*<word>Ramage</word>\\s*<lemma>Ramage</lemma>\\s*<CharacterOffsetBegin>4</CharacterOffsetBegin>\\s*<CharacterOffsetEnd>10</CharacterOffsetEnd>\\s*<POS>NNP</POS>\\s*<NER>PERSON</NER>"));
        Assert.assertTrue((String)("XML dependencies are wrong in " + result), (boolean)StringUtils.find(result, "<dep type=\"compound\">\\s*<governor idx=\"2\">Ramage</governor>\\s*<dependent idx=\"1\">Dan</dependent>\\s*</dep>"));
    }

    private static void checkNer(String message, String[][][] expected, CoreMap coremap, String coremapOutput) {
        List sentences = (List)coremap.get(CoreAnnotations.SentencesAnnotation.class);
        StanfordCoreNLPITest.assertEquals((String)(message + ": number of sentences for\n" + coremapOutput), (int)expected.length, (int)sentences.size());
        for (int i = 0; i < expected.length; ++i) {
            CoreMap sentence = (CoreMap)sentences.get(i);
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            StanfordCoreNLPITest.assertEquals((String)(message + ": number of tokens for sentence " + (i + 1) + "\n" + coremapOutput), (int)expected[i].length, (int)tokens.size());
            for (int j = 0; j < expected[i].length; ++j) {
                String text = expected[i][j][0];
                String ner = expected[i][j][1];
                String debug = "sentence " + (i + 1) + ", token " + (j + 1);
                StanfordCoreNLPITest.assertEquals((String)(message + ": text mismatch for " + debug + "\n" + coremapOutput), (String)text, (String)((CoreLabel)tokens.get(j)).word());
                StanfordCoreNLPITest.assertEquals((String)(message + ": ner mismatch for " + debug + "(" + ((CoreLabel)tokens.get(j)).word() + ")\n" + coremapOutput), (String)ner, (String)((CoreLabel)tokens.get(j)).ner());
            }
        }
    }

    public void testRegexNer() throws Exception {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,regexner");
        props.setProperty("regexner.ignorecase", "true");
        String text = "Barack Obama is the 44th President of the United States.  He is the first African American president.";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        StringWriter stringWriter = new StringWriter();
        pipeline.prettyPrint(document, new PrintWriter(stringWriter));
        String result = stringWriter.getBuffer().toString();
        String[][][] expected = new String[][][]{{{"Barack", "PERSON"}, {"Obama", "PERSON"}, {"is", "O"}, {"the", "O"}, {"44th", "ORDINAL"}, {"President", "TITLE"}, {"of", "O"}, {"the", "O"}, {"United", "COUNTRY"}, {"States", "COUNTRY"}, {".", "O"}}, {{"He", "O"}, {"is", "O"}, {"the", "O"}, {"first", "ORDINAL"}, {"African", "NATIONALITY"}, {"American", "NATIONALITY"}, {"president", "TITLE"}, {".", "O"}}};
        StanfordCoreNLPITest.checkNer("testRegexNer", expected, document, result);
    }

    public void testRelationExtractor() throws Exception {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,parse,relation");
        String text = "Barack Obama, a Yale professor, is president.";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        CoreMap sentence = (CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        List rel = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
        StanfordCoreNLPITest.assertEquals((String)((RelationMention)rel.get(0)).getType(), (String)"Work_For");
    }

    public void testSerialization() throws Exception {
        StanfordCoreNLP pipeline = new StanfordCoreNLP();
        Annotation document = new Annotation("Stanford University is located in California. It is a great university.");
        pipeline.annotate(document);
        CoreMap sentence = (CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        SemanticGraph g = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        StanfordCoreNLPITest.processSerialization(g);
        StanfordCoreNLPITest.processSerialization(sentence.get(TreeCoreAnnotations.TreeAnnotation.class));
        StanfordCoreNLPITest.processSerialization(sentence.get(CoreAnnotations.TokensAnnotation.class));
        StanfordCoreNLPITest.processSerialization(sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class));
        StanfordCoreNLPITest.processSerialization(sentence);
        Object processed = StanfordCoreNLPITest.processSerialization(document);
        StanfordCoreNLPITest.assertTrue((boolean)(processed instanceof Annotation));
        Annotation newDocument = (Annotation)processed;
        StanfordCoreNLPITest.assertEquals((int)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).size(), (int)((List)newDocument.get(CoreAnnotations.SentencesAnnotation.class)).size());
        for (int i = 0; i < ((List)document.get(CoreAnnotations.SentencesAnnotation.class)).size(); ++i) {
            CoreMap oldSentence = (CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
            CoreMap newSentence = (CoreMap)((List)newDocument.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
            StanfordCoreNLPITest.assertEquals(oldSentence.get(TreeCoreAnnotations.TreeAnnotation.class), newSentence.get(TreeCoreAnnotations.TreeAnnotation.class));
            StanfordCoreNLPITest.assertEquals(oldSentence.get(CoreAnnotations.TokensAnnotation.class), newSentence.get(CoreAnnotations.TokensAnnotation.class));
        }
        StanfordCoreNLPITest.assertTrue((boolean)document.equals(newDocument));
    }

    private static Object processSerialization(Object input) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(input);
        oout.flush();
        oout.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream oin = new ObjectInputStream(bin);
        return oin.readObject();
    }

    public void testSentenceNewlines() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos");
        props.setProperty("ssplit.isOneSentence", "true");
        String text = "At least a few female committee members are from Scandinavia. \n";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((String)("Wrong number of tokens: " + tokens), (long)11L, (long)tokens.size());
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((String)"Wrong number of sentences", (long)1L, (long)sentences.size());
    }

    public void testSentenceNewlinesTwo() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize");
        String text = "At least a few female committee members\nare from Scandinavia.\n";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((String)("Wrong number of tokens: " + tokens), (long)11L, (long)tokens.size());
    }

    public void testSentenceNewlinesThree() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos");
        String text = "At least a few female committee members\nare from Scandinavia.\n";
        Annotation document = new Annotation(text);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(document);
        List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((String)("Wrong number of tokens: " + tokens), (long)11L, (long)tokens.size());
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((String)"Wrong number of sentences", (long)1L, (long)sentences.size());
        CoreMap firstSentence = (CoreMap)sentences.get(0);
        List sentTokens = (List)firstSentence.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)sentTokens);
        Assert.assertEquals((String)("Wrong number of sentTokens: " + sentTokens), (long)11L, (long)sentTokens.size());
    }

    private static void checkSUTimeAnnotation(String message, StanfordCoreNLP pipeline, String text, int nExpectedSentences, int nExpectedTokens, Map<Integer, String> expectedNormalizedNER) {
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        Assert.assertNotNull((Object)sentences);
        Assert.assertEquals((String)(message + ": number of sentences"), (long)nExpectedSentences, (long)sentences.size());
        List tokens = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertNotNull((Object)tokens);
        Assert.assertEquals((String)(message + ": number of tokens"), (long)nExpectedTokens, (long)tokens.size());
        for (Map.Entry<Integer, String> kv : expectedNormalizedNER.entrySet()) {
            Assert.assertEquals((String)(message + ": token " + kv.getKey()), (Object)kv.getValue(), ((CoreLabel)tokens.get(kv.getKey())).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
    }

    public void testSUTimeProperty() {
        String text = "The date is 2001-10-02.  There is a meeting tomorrow.";
        int nExpectedSentences = 2;
        int nExpectedTokens = 11;
        StanfordCoreNLP pipeline1 = new StanfordCoreNLP();
        HashMap<Integer, String> expectedValues1 = new HashMap<Integer, String>();
        expectedValues1.put(3, "2001-10-02");
        expectedValues1.put(9, "OFFSET P1D");
        StanfordCoreNLPITest.checkSUTimeAnnotation("Default properties", pipeline1, text, nExpectedSentences, nExpectedTokens, expectedValues1);
        Properties props = new Properties();
        props.setProperty("sutime.searchForDocDate", "true");
        StanfordCoreNLP pipeline2 = new StanfordCoreNLP(props);
        HashMap<Integer, String> expectedValues2 = new HashMap<Integer, String>();
        expectedValues2.put(3, "2001-10-02");
        expectedValues2.put(9, "2001-10-03");
        StanfordCoreNLPITest.checkSUTimeAnnotation("With searchForDocDate", pipeline2, text, nExpectedSentences, nExpectedTokens, expectedValues2);
    }
}

