/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.Sets;
import java.util.Set;
import junit.framework.TestCase;

public class TaggerParserPosTagCompatibilityITest
extends TestCase {
    private static final String[] englishTaggers = new String[]{"edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", "edu/stanford/nlp/models/pos-tagger/english-bidirectional/english-bidirectional-distsim.tagger", "edu/stanford/nlp/models/pos-tagger/english-caseless-left3words-distsim.tagger"};
    private static final String[] englishParsers = new String[]{"edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz", "edu/stanford/nlp/models/lexparser/englishPCFG.caseless.ser.gz", "edu/stanford/nlp/models/lexparser/englishRNN.ser.gz", "edu/stanford/nlp/models/lexparser/englishFactored.ser.gz"};
    private static final String[] englishSrParsers = new String[]{"edu/stanford/nlp/models/srparser/englishSR.beam.ser.gz", "edu/stanford/nlp/models/srparser/englishSR.ser.gz"};
    private static final String[] englishNnParsers = new String[]{"edu/stanford/nlp/models/parser/nndep/english_SD.gz", "edu/stanford/nlp/models/parser/nndep/english_UD.gz"};
    private static final String[] germanTaggers = new String[]{"edu/stanford/nlp/models/pos-tagger/german/german-fast.tagger", "edu/stanford/nlp/models/pos-tagger/german/german-fast-caseless.tagger", "edu/stanford/nlp/models/pos-tagger/german/german-hgc.tagger"};
    private static final String[] germanParsers = new String[]{"edu/stanford/nlp/models/lexparser/germanPCFG.ser.gz", "edu/stanford/nlp/models/lexparser/germanFactored.ser.gz"};
    private static final String[] germanSrParsers = new String[]{"edu/stanford/nlp/models/srparser/germanSR.ser.gz"};
    private static final String[] germanNnParsers = new String[0];
    private static final String[] chineseTaggers = new String[]{"edu/stanford/nlp/models/pos-tagger/chinese-distsim/chinese-distsim.tagger"};
    private static final String[] chineseParsers = new String[]{"edu/stanford/nlp/models/lexparser/chineseFactored.ser.gz", "edu/stanford/nlp/models/lexparser/chinesePCFG.ser.gz"};
    private static final String[] chineseSrParsers = new String[]{"edu/stanford/nlp/models/srparser/chineseSR.ser.gz"};
    private static final String[] chineseNnParsers = new String[0];
    private static final String[] spanishTaggers = new String[]{"edu/stanford/nlp/models/pos-tagger/spanish/spanish.tagger", "edu/stanford/nlp/models/pos-tagger/spanish/spanish-distsim.tagger"};
    private static final String[] spanishParsers = new String[]{"edu/stanford/nlp/models/lexparser/spanishPCFG.ser.gz"};
    private static final String[] spanishSrParsers = new String[0];
    private static final String[] spanishNnParsers = new String[0];
    private static final String[] frenchTaggers = new String[]{"edu/stanford/nlp/models/pos-tagger/french/french.tagger"};
    private static final String[] frenchParsers = new String[]{"edu/stanford/nlp/models/lexparser/frenchFactored.ser.gz"};
    private static final String[] frenchSrParsers = new String[0];
    private static final String[] frenchNnParsers = new String[0];

    private static void testTagSet4(String[] lexParsers, String[] maxentTaggers, String[] srParsers, String[] nnDepParsers) {
        LexicalizedParser lp = LexicalizedParser.loadModel(lexParsers[0], new String[0]);
        Set<String> tagSet = lp.getLexicon().tagSet(lp.treebankLanguagePack().getBasicCategoryFunction());
        for (String name : maxentTaggers) {
            MaxentTagger tagger = new MaxentTagger(name);
            TaggerParserPosTagCompatibilityITest.assertEquals((String)(lexParsers[0] + " vs. " + name + " tag set mismatch:\n" + "left - right: " + Sets.diff(tagSet, tagger.tagSet()) + "; right - left: " + Sets.diff(tagger.tagSet(), tagSet) + "\n"), tagSet, tagger.tagSet());
        }
        for (String name : lexParsers) {
            LexicalizedParser lp2 = LexicalizedParser.loadModel(name, new String[0]);
            TaggerParserPosTagCompatibilityITest.assertEquals((String)(lexParsers[0] + " vs. " + name + " tag set mismatch:\n" + "left - right: " + Sets.diff(tagSet, lp2.getLexicon().tagSet(lp.treebankLanguagePack().getBasicCategoryFunction())) + "; right - left: " + Sets.diff(lp2.getLexicon().tagSet(lp.treebankLanguagePack().getBasicCategoryFunction()), tagSet) + "\n"), tagSet, lp2.getLexicon().tagSet(lp.treebankLanguagePack().getBasicCategoryFunction()));
        }
        for (String name : srParsers) {
            ShiftReduceParser srp = ShiftReduceParser.loadModel(name, new String[0]);
            TaggerParserPosTagCompatibilityITest.assertEquals((String)(lexParsers[0] + " vs. " + name + " tag set mismatch:\n" + "left - right: " + Sets.diff(tagSet, srp.tagSet()) + "; right - left: " + Sets.diff(srp.tagSet(), tagSet) + "\n"), tagSet, srp.tagSet());
        }
        for (String name : nnDepParsers) {
            DependencyParser dp = DependencyParser.loadFromModelFile(name);
            TaggerParserPosTagCompatibilityITest.assertEquals((String)(lexParsers[0] + " vs. " + name + " tag set mismatch:\n" + "left - right: " + Sets.diff(tagSet, dp.getPosSet()) + "; right - left: " + Sets.diff(dp.getPosSet(), tagSet) + "\n"), tagSet, dp.getPosSet());
        }
    }

    public void testEnglishTagSet() {
        TaggerParserPosTagCompatibilityITest.testTagSet4(englishParsers, englishTaggers, englishSrParsers, englishNnParsers);
    }

    public void testGermanTagSet() {
        TaggerParserPosTagCompatibilityITest.testTagSet4(germanParsers, germanTaggers, germanSrParsers, germanNnParsers);
    }

    public void testChineseTagSet() {
        TaggerParserPosTagCompatibilityITest.testTagSet4(chineseParsers, chineseTaggers, chineseSrParsers, chineseNnParsers);
    }

    public void testSpanishTagSet() {
        TaggerParserPosTagCompatibilityITest.testTagSet4(spanishParsers, spanishTaggers, spanishSrParsers, spanishNnParsers);
    }

    public void testFrenchTagSet() {
        TaggerParserPosTagCompatibilityITest.testTagSet4(frenchParsers, frenchTaggers, frenchSrParsers, frenchNnParsers);
    }
}

