/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TokensRegexAnnotator
implements Annotator {
    private final Env env;
    private final CoreMapExpressionExtractor<MatchedExpression> extractor;
    private final Options options = new Options();
    private final boolean verbose;

    public TokensRegexAnnotator(String ... files) {
        this.env = TokenSequencePattern.getNewEnv();
        this.extractor = CoreMapExpressionExtractor.createExtractorFromFiles(this.env, files);
        this.verbose = false;
    }

    public TokensRegexAnnotator(String name, Properties props) {
        String prefix = name == null ? "" : name + '.';
        String[] files = PropertiesUtils.getStringArray(props, prefix + "rules");
        this.env = TokenSequencePattern.getNewEnv();
        this.env.bind("options", this.options);
        if (PropertiesUtils.getBool(props, prefix + "caseInsensitive")) {
            System.err.println("using case insensitive!");
            this.env.setDefaultStringMatchFlags(2);
            this.env.setDefaultStringPatternFlags(2);
        }
        this.extractor = files.length != 0 ? CoreMapExpressionExtractor.createExtractorFromFiles(this.env, files) : null;
        this.verbose = PropertiesUtils.getBool(props, prefix + "verbose", false);
        this.options.setTokenOffsets = PropertiesUtils.getBool(props, prefix + "setTokenOffsets", this.options.setTokenOffsets);
        this.options.extractWithTokens = PropertiesUtils.getBool(props, prefix + "extractWithTokens", this.options.extractWithTokens);
        this.options.flatten = PropertiesUtils.getBool(props, prefix + "flatten", this.options.flatten);
        String matchedExpressionsAnnotationKeyName = props.getProperty(prefix + "matchedExpressionsAnnotationKey");
        if (matchedExpressionsAnnotationKeyName != null) {
            this.options.matchedExpressionsAnnotationKey = EnvLookup.lookupAnnotationKeyWithClassname(this.env, matchedExpressionsAnnotationKeyName);
            if (this.options.matchedExpressionsAnnotationKey == null) {
                String propName = prefix + "matchedExpressionsAnnotationKey";
                throw new RuntimeException("Cannot determine annotation key for " + propName + '=' + matchedExpressionsAnnotationKeyName);
            }
        }
    }

    public TokensRegexAnnotator(Properties props) {
        this(null, props);
    }

    private static void addTokenOffsets(CoreMap annotation) {
        Integer startTokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (startTokenOffset == null) {
            startTokenOffset = 0;
        }
        int i = 0;
        for (CoreMap c : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            c.set(CoreAnnotations.TokenBeginAnnotation.class, i + startTokenOffset);
            c.set(CoreAnnotations.TokenEndAnnotation.class, ++i + startTokenOffset);
        }
    }

    private List<CoreMap> extract(CoreMap annotation) {
        List<CoreMap> cms = this.options.extractWithTokens ? this.extractor.extractCoreMapsMergedWithTokens(annotation) : this.extractor.extractCoreMaps(annotation);
        if (this.options.flatten) {
            return this.extractor.flatten(cms);
        }
        return cms;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            Redwood.log(new Object[]{Redwood.DBG, "Adding TokensRegexAnnotator annotation..."});
        }
        if (this.options.setTokenOffsets) {
            TokensRegexAnnotator.addTokenOffsets(annotation);
        }
        if (this.extractor != null) {
            List<Object> allMatched;
            if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
                allMatched = new ArrayList();
                List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
                for (CoreMap sentence : sentences) {
                    List<CoreMap> matched = this.extract(sentence);
                    if (matched == null || this.options.matchedExpressionsAnnotationKey == null) continue;
                    allMatched.addAll(matched);
                    sentence.set(this.options.matchedExpressionsAnnotationKey, matched);
                    for (CoreMap cm : matched) {
                        cm.set(CoreAnnotations.SentenceIndexAnnotation.class, sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
                    }
                }
            } else {
                allMatched = this.extract(annotation);
            }
            if (this.options.matchedExpressionsAnnotationKey != null) {
                annotation.set(this.options.matchedExpressionsAnnotationKey, allMatched);
            }
        }
        if (this.verbose) {
            Redwood.log(new Object[]{Redwood.DBG, "done."});
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.singleton(CoreAnnotations.TokensAnnotation.class);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    public static class Options {
        public Class matchedExpressionsAnnotationKey;
        public boolean setTokenOffsets;
        public boolean extractWithTokens;
        public boolean flatten;
    }
}

